/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.config;

import java.util.Optional;
import org.mule.runtime.api.config.Feature;

public enum MuleRuntimeFeature implements Feature
{
    HONOUR_RESERVED_PROPERTIES("Whether reserved properties such as 'app.name' can't be overridden by global properties.", "MULE-19038", "4.4.0, 4.3.1", "mule.honour.reserved.properties"),
    BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER("If set to true, then fixed batch aggregator will only commit when a full block is processed.", "EE-7443", "4.4.0, 4.3.1, 4.2.3", "mule.batch.fixed.aggregator.transaction.record.buffer"),
    COMPUTE_CONNECTION_ERRORS_IN_STATS(" If set to true, the connection errors will be computed to trigger alerts.", "MULE-19020", "4.4.0, 4.3.1", "mule.compute.connection.errors.in.stats"),
    ENABLE_POLICY_ISOLATION("If set to true, extensions imported by a policy will be managed in complete isolation from the extensions imported by the application that is being applied to, and validations will prevent the usage of explicit configurations declared by the application as part of the policy initialization.", "MULE-19226", "4.4.0, 4.3.1", "mule.enable.policy.isolation"),
    SET_VARIABLE_WITH_NULL_VALUE("If set to true, the set variable will create a variable even if the value is null", "MULE-19443", "4.4.0", "mule.setVariable.WithNullValue"),
    START_EXTENSION_COMPONENTS_WITH_ARTIFACT_CLASSLOADER("When enabled, extensions will only be able to load exported resources from the deployable artifacts (application, policy, domain).", "MULE-19815", "4.4.0", "mule.startExtensionComponentsWithArtifactClassloader"),
    DEFAULT_ERROR_HANDLER_NOT_ROLLBACK_IF_NOT_CORRESPONDING("When enabled, the default error handler added by the runtime will not rollback a transaction that should not be rollback by it", "MULE-19919", "4.4.1, 4.3.1", "mule.enable.default.errorhandler.not.rollback.incorrect.tx"),
    PARALLEL_FOREACH_FLATTEN_MESSAGE("When enabled, if the items to iterate over on a parallel-foreach scope are messages (such as the output of an operation that returns Result objects), they will be flattened in a way that is consistent with what the foreach scope does.", "MULE-20067", "4.5.0", "mule.parallelForeach.flattenMessage"),
    ENABLE_BYTE_BUDDY_OBJECT_CREATION("When enabled, the Objects factories will be created with Byte Buddy instead of CGLIB.", "W-10672687", "4.5.0", "mule.enable.byteBuddy.objectCreation"),
    HONOUR_ERROR_MAPPINGS_WHEN_POLICY_APPLIED_ON_OPERATION("When set to true, the operation policy's error resolution is ignored so that the error mappings of the processor on which the policy was applied are set successfully", "W-11147961", "4.5.0", "mule.honourErrorMappingsWhenPolicyAppliedOnOperation");

    private final String description;
    private final String issueId;
    private final String since;
    private final String overridingSystemPropertyName;

    private MuleRuntimeFeature(String description, String issue, String since) {
        this(description, issue, since, null);
    }

    private MuleRuntimeFeature(String description, String issueId, String since, String overridingSystemPropertyName) {
        this.description = description;
        this.issueId = issueId;
        this.since = since;
        this.overridingSystemPropertyName = overridingSystemPropertyName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public Optional<String> getOverridingSystemPropertyName() {
        return Optional.ofNullable(this.overridingSystemPropertyName);
    }
}

