/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.handler.TypeHandlerManagerFactory;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeHandlerManagerFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class ExtensionModelHelper {
    private final Set<ExtensionModel> extensionsModels;
    private final Cache<ComponentIdentifier, Optional<? extends ComponentModel>> extensionComponentModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<? extends ConnectionProviderModel>> extensionConnectionProviderModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<? extends ConfigurationModel>> extensionConfigurationModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<NestableElementModel>> extensionNestableElementModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final LoadingCache<ExtensionModel, DslSyntaxResolver> dslSyntaxResolversByExtension;
    private final JavaTypeLoader javaTypeLoader = new JavaTypeLoader(ExtensionModelHelper.class.getClassLoader(), (TypeHandlerManagerFactory)new ExtensionsTypeHandlerManagerFactory());
    private final DslResolvingContext dslResolvingContext;

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels) {
        this(extensionModels, DslResolvingContext.getDefault(extensionModels));
    }

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels, DslResolvingContext dslResolvingCtx) {
        this.extensionsModels = extensionModels;
        this.dslSyntaxResolversByExtension = Caffeine.newBuilder().build(key -> DslSyntaxResolver.getDefault((ExtensionModel)key, (DslResolvingContext)dslResolvingCtx));
        this.dslResolvingContext = dslResolvingCtx;
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentIdentifier componentIdentifier) {
        return this.findComponentModel(componentIdentifier).map(extensionComponentModel -> this.findComponentType((ComponentModel)extensionComponentModel)).orElseGet(() -> {
            Optional<NestableElementModel> nestableElementModelOptional = this.findNestableElementModel(componentIdentifier);
            return nestableElementModelOptional.map(nestableElementModel -> {
                Reference componentTypeReference = new Reference();
                nestableElementModel.accept((NestableElementModelVisitor)new IsRouteVisitor((Reference<TypedComponentIdentifier.ComponentType>)componentTypeReference));
                return componentTypeReference.get() == null ? TypedComponentIdentifier.ComponentType.UNKNOWN : (TypedComponentIdentifier.ComponentType)componentTypeReference.get();
            }).orElse(TypedComponentIdentifier.ComponentType.UNKNOWN);
        });
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentModel extensionComponentModel) {
        final Reference componentTypeReference = new Reference();
        extensionComponentModel.accept(new ComponentModelVisitor(){

            public void visit(OperationModel model) {
                componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.OPERATION);
            }

            public void visit(SourceModel model) {
                componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.SOURCE);
            }

            public void visit(ConstructModel model) {
                if (model.getStereotype().equals(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                    return;
                }
                if (model.getStereotype().equals(MuleStereotypes.FLOW)) {
                    componentTypeReference.set((Object)TypedComponentIdentifier.ComponentType.FLOW);
                    return;
                }
                NestedComponentVisitor nestedComponentVisitor = new NestedComponentVisitor((Reference<TypedComponentIdentifier.ComponentType>)componentTypeReference);
                for (NestableElementModel nestableElementModel : model.getNestedComponents()) {
                    nestableElementModel.accept((NestableElementModelVisitor)nestedComponentVisitor);
                    if (componentTypeReference.get() == null) continue;
                    return;
                }
            }
        });
        return componentTypeReference.get() == null ? TypedComponentIdentifier.ComponentType.UNKNOWN : (TypedComponentIdentifier.ComponentType)componentTypeReference.get();
    }

    private Optional<NestableElementModel> findNestableElementModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionNestableElementModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(extensionModel -> {
            String componentName = NameUtils.toCamelCase((String)componentIdentifier.getName(), (String)"-");
            Optional<NestableElementModel> elementModelOptional = this.searchNestableElementModel((ExtensionModel)extensionModel, componentName);
            if (elementModelOptional.isPresent()) {
                return elementModelOptional;
            }
            return this.searchNestableElementModel((ExtensionModel)extensionModel, componentIdentifier.getName());
        }));
    }

    private Optional<NestableElementModel> searchNestableElementModel(ExtensionModel extensionModel, final String componentName) {
        final Reference reference = new Reference();
        IdempotentExtensionWalker walker = new IdempotentExtensionWalker(){

            protected void onConstruct(ConstructModel model) {
                model.getNestedComponents().stream().filter(nestedComponent -> nestedComponent.getName().equals(componentName)).findFirst().ifPresent(foundComponent -> {
                    reference.set(foundComponent);
                    this.stop();
                });
            }
        };
        walker.walk(extensionModel);
        return Optional.ofNullable(reference.get());
    }

    public Optional<? extends ComponentModel> findComponentModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionComponentModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(extensionModel -> {
            AtomicReference modelRef = new AtomicReference();
            new ExtensionWalker((ExtensionModel)extensionModel, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$extensionModel;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$extensionModel = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$extensionModel);
                }

                protected void onOperation(HasOperationModels owner, OperationModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }

                protected void onSource(HasSourceModels owner, SourceModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }

                protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk(extensionModel);
            return Optional.ofNullable(modelRef.get());
        }));
    }

    public Optional<? extends ConnectionProviderModel> findConnectionProviderModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConnectionProviderModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new ExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
                }

                protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk(currentExtension);
            return Optional.ofNullable(modelRef.get());
        }));
    }

    public Optional<? extends ConfigurationModel> findConfigurationModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConfigurationModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new ExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
                }

                protected void onConfiguration(ConfigurationModel model) {
                    if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk(currentExtension);
            return Optional.ofNullable(modelRef.get());
        }));
    }

    public Optional<ParameterModel> findParameterModel(ComponentIdentifier nestedComponentId, ParameterizedModel model) {
        return this.lookupExtensionModelFor(nestedComponentId).flatMap(currentExtension -> {
            DslSyntaxResolver dslSyntaxResolver = (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get(currentExtension);
            return model.getAllParameterModels().stream().filter(pm -> dslSyntaxResolver.resolve(pm).getElementName().equals(nestedComponentId.getName())).findAny();
        });
    }

    public void walkToComponent(ComponentIdentifier componentIdentifier, ExtensionWalkerModelDelegate delegate) {
        this.lookupExtensionModelFor(componentIdentifier).ifPresent(currentExtension -> new ExtensionWalker((ExtensionModel)currentExtension, componentIdentifier, delegate){
            final DslSyntaxResolver dslSyntaxResolver;
            final /* synthetic */ ExtensionModel val$currentExtension;
            final /* synthetic */ ComponentIdentifier val$componentIdentifier;
            final /* synthetic */ ExtensionWalkerModelDelegate val$delegate;
            {
                this.val$currentExtension = extensionModel;
                this.val$componentIdentifier = componentIdentifier;
                this.val$delegate = extensionWalkerModelDelegate;
                this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
            }

            protected void onConfiguration(ConfigurationModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                    this.val$delegate.onConfiguration(model);
                    this.stop();
                }
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                    this.val$delegate.onConnectionProvider(model);
                    this.stop();
                }
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                    this.val$delegate.onOperation(model);
                    this.stop();
                }
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                    this.val$delegate.onSource(model);
                    this.stop();
                }
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                    this.val$delegate.onConstruct(model);
                    this.stop();
                }
            }

            protected void onNestable(ComposableModel owner, NestableElementModel model) {
                if (this.dslSyntaxResolver.resolve((NamedObject)model).getElementName().equals(this.val$componentIdentifier.getName())) {
                    this.val$delegate.onNestableElement(model);
                    this.stop();
                }
            }
        }.walk(currentExtension));
    }

    public Optional<? extends MetadataType> findMetadataType(Class<?> type) {
        if (type != null && !Processor.class.isAssignableFrom(type)) {
            return Optional.of(this.javaTypeLoader.load(type));
        }
        return Optional.empty();
    }

    private Optional<ExtensionModel> lookupExtensionModelFor(ComponentIdentifier componentIdentifier) {
        return this.extensionsModels.stream().filter(e -> e.getXmlDslModel().getPrefix().equals(componentIdentifier.getNamespace())).findFirst();
    }

    public DslElementSyntax resolveDslElementModel(NamedObject component, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(component);
    }

    private DslSyntaxResolver getDslSyntaxResolver(ComponentIdentifier componentIdentifier) {
        Optional<ExtensionModel> optionalExtensionModel = this.lookupExtensionModelFor(componentIdentifier);
        ExtensionModel extensionModel = optionalExtensionModel.orElseThrow(() -> new IllegalStateException("Extension Model in context not present for componentIdentifier: " + componentIdentifier));
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel);
    }

    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType metadataType, ExtensionModel extensionModel) {
        return ((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel)).resolve(metadataType);
    }

    public DslElementSyntax resolveDslElementModel(ParameterModel parameterModel, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(parameterModel);
    }

    public Map<ObjectType, Optional<DslElementSyntax>> resolveSubTypes(ObjectType type) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (ObjectType subType : this.dslResolvingContext.getTypeCatalog().getSubTypes(type)) {
            Optional declaringExtension;
            Optional<String> typeId = subType.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue);
            if (!typeId.isPresent() || !(declaringExtension = this.dslResolvingContext.getTypeCatalog().getDeclaringExtension(typeId.get())).isPresent()) continue;
            this.dslResolvingContext.getExtension((String)declaringExtension.get()).ifPresent(extensionModel -> mapBuilder.put((Object)subType, (Object)((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get(extensionModel)).resolve((MetadataType)subType)));
        }
        return mapBuilder.build();
    }

    public Collection<ObjectType> getAllSubTypes() {
        return this.dslResolvingContext.getTypeCatalog().getAllSubTypes();
    }

    public Collection<ObjectType> getSubTypes(ObjectType objectType) {
        return this.dslResolvingContext.getTypeCatalog().getSubTypes(objectType);
    }

    public Set<ExtensionModel> getExtensionsModels() {
        return this.extensionsModels;
    }

    static class NestedComponentVisitor
    implements NestableElementModelVisitor {
        private final Reference<TypedComponentIdentifier.ComponentType> reference;

        public NestedComponentVisitor(Reference<TypedComponentIdentifier.ComponentType> reference) {
            this.reference = reference;
        }

        public void visit(NestedComponentModel component) {
        }

        public void visit(NestedChainModel component) {
            this.reference.set((Object)TypedComponentIdentifier.ComponentType.SCOPE);
        }

        public void visit(NestedRouteModel component) {
            this.reference.set((Object)TypedComponentIdentifier.ComponentType.ROUTER);
        }
    }

    static class IsRouteVisitor
    implements NestableElementModelVisitor {
        private final Reference<TypedComponentIdentifier.ComponentType> reference;

        public IsRouteVisitor(Reference<TypedComponentIdentifier.ComponentType> reference) {
            this.reference = reference;
        }

        public void visit(NestedComponentModel component) {
        }

        public void visit(NestedChainModel component) {
        }

        public void visit(NestedRouteModel component) {
            this.reference.set((Object)TypedComponentIdentifier.ComponentType.ROUTE);
        }
    }

    public static interface ExtensionWalkerModelDelegate {
        public void onConfiguration(ConfigurationModel var1);

        public void onConnectionProvider(ConnectionProviderModel var1);

        public void onOperation(OperationModel var1);

        public void onSource(SourceModel var1);

        public void onConstruct(ConstructModel var1);

        public void onNestableElement(NestableElementModel var1);
    }
}

