/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.collection.SmallMap;

public class CaseInsensitiveMapWrapper<T>
extends AbstractMap<String, T>
implements Serializable {
    private static final long serialVersionUID = 8534959274607933747L;
    protected final Map<CaseInsensitiveMapKey, T> baseMap;

    public CaseInsensitiveMapWrapper(Map map) {
        this(map, true);
    }

    private CaseInsensitiveMapWrapper(Map map, boolean requireEmpty) {
        if (requireEmpty) {
            Preconditions.checkArgument(map.isEmpty(), "Cannot create case insensitive map from a non empty one.");
        }
        this.baseMap = map;
    }

    public CaseInsensitiveMapWrapper() {
        this(new HashMap());
    }

    public CaseInsensitiveMapWrapper<T> copy() {
        return new CaseInsensitiveMapWrapper<T>(SmallMap.copy(this.baseMap), false);
    }

    @Override
    public int size() {
        return this.baseMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.baseMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.baseMap.containsKey(CaseInsensitiveMapKey.keyFor(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.baseMap.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return this.baseMap.get(CaseInsensitiveMapKey.keyFor(key));
    }

    @Override
    public T put(String key, T value) {
        return this.baseMap.put(CaseInsensitiveMapKey.keyFor(key), value);
    }

    @Override
    public T remove(Object key) {
        return this.baseMap.remove(CaseInsensitiveMapKey.keyFor(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> other) {
        if (other instanceof CaseInsensitiveMapWrapper) {
            this.baseMap.putAll(((CaseInsensitiveMapWrapper)other).baseMap);
        } else {
            for (Map.Entry<String, T> otherEntry : other.entrySet()) {
                this.put(otherEntry.getKey(), otherEntry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.baseMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.baseMap.keySet());
    }

    @Override
    public Collection<T> values() {
        return this.baseMap.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new EntrySet<T>(this.baseMap.entrySet());
    }

    public Map<String, T> asCaseSensitiveMap() {
        return this.baseMap.entrySet().stream().collect(Collectors.toMap(entry -> ((CaseInsensitiveMapKey)entry.getKey()).getKey(), entry -> entry.getValue()));
    }

    private static abstract class AbstractConverterIterator<A, B>
    implements Iterator<B> {
        private final Iterator<A> aIterator;

        public AbstractConverterIterator(Set<A> set) {
            this.aIterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.aIterator.hasNext();
        }

        @Override
        public final void remove() {
            this.aIterator.remove();
        }

        @Override
        public final B next() {
            return this.convert(this.aIterator.next());
        }

        protected abstract B convert(A var1);
    }

    private static class EntryIterator<T>
    extends AbstractConverterIterator<Map.Entry<CaseInsensitiveMapKey, T>, Map.Entry<String, T>> {
        public EntryIterator(Set<Map.Entry<CaseInsensitiveMapKey, T>> entries) {
            super(entries);
        }

        @Override
        protected Map.Entry<String, T> convert(Map.Entry<CaseInsensitiveMapKey, T> next) {
            return new AbstractMap.SimpleEntry<String, T>(next.getKey().getKey(), next.getValue());
        }
    }

    private static class KeyIterator
    extends AbstractConverterIterator<CaseInsensitiveMapKey, String> {
        public KeyIterator(Set<CaseInsensitiveMapKey> keys) {
            super(keys);
        }

        @Override
        protected String convert(CaseInsensitiveMapKey next) {
            return next.getKey();
        }
    }

    protected static abstract class AbstractConverterSet<A, B>
    extends AbstractSet<B> {
        private final Set<A> aSet;

        public AbstractConverterSet(Set<A> set) {
            this.aSet = set;
        }

        @Override
        public int size() {
            return this.aSet.size();
        }

        @Override
        public Iterator<B> iterator() {
            return this.createIterator(this.aSet);
        }

        @Override
        public boolean contains(Object o) {
            return o != null && this.aSet.contains(this.keyFor(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.stream().map(o -> this.keyFor(o)).allMatch(o -> o != null && this.aSet.contains(o));
        }

        @Override
        public boolean remove(Object o) {
            return o != null && this.aSet.contains(this.keyFor(o));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return c.stream().map(o -> this.keyFor(o)).allMatch(o -> o != null && this.aSet.remove(o));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.aSet.retainAll(c.stream().map(o -> this.keyFor(o)).collect(Collectors.toSet()));
        }

        @Override
        public void clear() {
            this.aSet.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.aSet.isEmpty();
        }

        protected A keyFor(Object o) {
            return (A)o;
        }

        protected abstract Iterator<B> createIterator(Set<A> var1);
    }

    private static class EntrySet<T>
    extends AbstractConverterSet<Map.Entry<CaseInsensitiveMapKey, T>, Map.Entry<String, T>> {
        public EntrySet(Set<Map.Entry<CaseInsensitiveMapKey, T>> entries) {
            super(entries);
        }

        @Override
        protected Iterator<Map.Entry<String, T>> createIterator(Set<Map.Entry<CaseInsensitiveMapKey, T>> entries) {
            return new EntryIterator<T>(entries);
        }

        @Override
        protected Map.Entry<CaseInsensitiveMapKey, T> keyFor(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry o2 = (Map.Entry)o;
                return new AbstractMap.SimpleImmutableEntry(CaseInsensitiveMapKey.keyFor(o2.getKey()), o2.getValue());
            }
            return null;
        }
    }

    private static class KeySet
    extends AbstractConverterSet<CaseInsensitiveMapKey, String> {
        public KeySet(Set<CaseInsensitiveMapKey> keys) {
            super(keys);
        }

        @Override
        protected Iterator<String> createIterator(Set<CaseInsensitiveMapKey> keys) {
            return new KeyIterator(keys);
        }

        @Override
        protected CaseInsensitiveMapKey keyFor(Object o) {
            return CaseInsensitiveMapKey.keyFor(o);
        }
    }

    protected static class CaseInsensitiveMapKey
    implements Serializable {
        private static final long serialVersionUID = -4964071931663826261L;
        private static final ConcurrentMap<Object, CaseInsensitiveMapKey> cache = new ConcurrentHashMap<Object, CaseInsensitiveMapKey>();
        private final String key;
        private final String keyLowerCase;
        private final int keyHash;

        public static CaseInsensitiveMapKey keyFor(Object key) {
            CaseInsensitiveMapKey value = (CaseInsensitiveMapKey)cache.get(key);
            if (value == null) {
                value = cache.computeIfAbsent(key, k -> new CaseInsensitiveMapKey(k));
            }
            return value;
        }

        private CaseInsensitiveMapKey(Object key) {
            this.key = key.toString();
            this.keyLowerCase = this.key.toLowerCase();
            this.keyHash = this.keyLowerCase.hashCode();
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyLowerCase() {
            return this.keyLowerCase;
        }

        public int hashCode() {
            return this.keyHash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof CaseInsensitiveMapKey && this.keyLowerCase.equals(((CaseInsensitiveMapKey)obj).keyLowerCase);
        }
    }
}

