/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.construct.BackPressureStrategySelector;
import org.mule.runtime.core.internal.construct.FlowBackPressureEventsAccumulatedException;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.construct.FlowBackPressureMaxConcurrencyExceededException;
import org.mule.runtime.core.internal.construct.FlowBackPressureRequiredSchedulerBusyException;
import org.mule.runtime.core.internal.construct.FlowBackPressureRequiredSchedulerBusyWithFullBufferException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public abstract class AbstractPipeline
extends AbstractFlowConstruct
implements Pipeline {
    private final NotificationDispatcher notificationFirer;
    private final SchedulerService schedulerService;
    private final MessageSource source;
    private final List<Processor> processors;
    private MessageProcessorChain pipeline;
    private final ProcessingStrategyFactory processingStrategyFactory;
    private final ProcessingStrategy processingStrategy;
    private volatile boolean canProcessMessage = false;
    private Sink sink;
    private Scheduler completionCallbackScheduler;
    private Map<BackPressureReason, FlowBackPressureException> backPressureExceptions;
    private final int maxConcurrency;
    private final ComponentInitialStateManager componentInitialStateManager;
    private final BackPressureStrategySelector backpressureStrategySelector;
    private final ErrorType FLOW_BACKPRESSURE_ERROR_TYPE;

    public AbstractPipeline(String name, MuleContext muleContext, MessageSource source, List<Processor> processors, Optional<FlowExceptionHandler> exceptionListener, Optional<ProcessingStrategyFactory> processingStrategyFactory, String initialState, Integer maxConcurrency, FlowConstructStatistics flowConstructStatistics, ComponentInitialStateManager componentInitialStateManager) {
        super(name, muleContext, exceptionListener, initialState, flowConstructStatistics);
        try {
            this.notificationFirer = ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(NotificationDispatcher.class);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
        this.schedulerService = muleContext.getSchedulerService();
        this.source = source;
        this.componentInitialStateManager = componentInitialStateManager;
        this.processors = Collections.unmodifiableList(processors);
        this.maxConcurrency = maxConcurrency != null ? maxConcurrency : AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY;
        this.processingStrategyFactory = processingStrategyFactory.orElseGet(() -> this.defaultProcessingStrategy());
        if (this.processingStrategyFactory instanceof AsyncProcessingStrategyFactory) {
            ((AsyncProcessingStrategyFactory)this.processingStrategyFactory).setMaxConcurrency(this.maxConcurrency);
        } else if (maxConcurrency != null) {
            LOGGER.warn("{} does not support 'maxConcurrency'. Ignoring the value.", (Object)this.processingStrategyFactory.getClass().getSimpleName());
        }
        this.processingStrategy = this.processingStrategyFactory.create(muleContext, this.getName());
        this.backpressureStrategySelector = new BackPressureStrategySelector(this);
        this.FLOW_BACKPRESSURE_ERROR_TYPE = (ErrorType)muleContext.getErrorTypeRepository().getErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).get();
    }

    protected MessageProcessorChain createPipeline() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("'" + this.getName() + "' processor chain");
        if (this.processingStrategy != null) {
            builder.setProcessingStrategy(this.processingStrategy);
        }
        this.configureMessageProcessors(builder);
        builder.setMessagingExceptionHandler(this.getExceptionListener());
        return builder.build();
    }

    protected ProcessingStrategyFactory createDefaultProcessingStrategyFactory() {
        return new DirectProcessingStrategyFactory();
    }

    private ProcessingStrategyFactory defaultProcessingStrategy() {
        return MessageProcessors.getDefaultProcessingStrategyFactory(this.muleContext, this::createDefaultProcessingStrategyFactory);
    }

    @Override
    public List<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public MessageSource getSource() {
        return this.source;
    }

    protected MessageProcessorChain getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean isSynchronous() {
        return this.processingStrategy.isSynchronous();
    }

    @Override
    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    @Override
    protected void doInitialise() throws MuleException {
        HashMap<BackPressureReason, FlowBackPressureException> backPressureExceptions = new HashMap<BackPressureReason, FlowBackPressureException>();
        backPressureExceptions.put(BackPressureReason.EVENTS_ACCUMULATED, new FlowBackPressureEventsAccumulatedException(this.getName(), BackPressureReason.EVENTS_ACCUMULATED));
        backPressureExceptions.put(BackPressureReason.MAX_CONCURRENCY_EXCEEDED, new FlowBackPressureMaxConcurrencyExceededException(this.getName(), BackPressureReason.EVENTS_ACCUMULATED));
        backPressureExceptions.put(BackPressureReason.REQUIRED_SCHEDULER_BUSY, new FlowBackPressureRequiredSchedulerBusyException(this.getName(), BackPressureReason.EVENTS_ACCUMULATED));
        backPressureExceptions.put(BackPressureReason.REQUIRED_SCHEDULER_BUSY_WITH_FULL_BUFFER, new FlowBackPressureRequiredSchedulerBusyWithFullBufferException(this.getName(), BackPressureReason.EVENTS_ACCUMULATED));
        this.backPressureExceptions = Collections.unmodifiableMap(backPressureExceptions);
        super.doInitialise();
        this.pipeline = this.createPipeline();
        if (this.source != null) {
            this.source.setListener(new Processor(){

                @Override
                public CoreEvent process(CoreEvent event) throws MuleException {
                    return MessageProcessors.processToApply(event, this);
                }

                @Override
                public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                    return Flux.from(publisher).transform((Function)AbstractPipeline.this.dispatchToFlow());
                }
            });
        }
        LifecycleUtils.initialiseIfNeeded(this.source, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.pipeline, this.muleContext);
        this.completionCallbackScheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(this.getName() + ".flux.completionCallback"));
    }

    protected final ReactiveProcessor dispatchToFlow() {
        return publisher -> Flux.from((Publisher)publisher).doOnNext(this.assertStarted()).transform(this.routeThroughProcessingStrategyTransformer()).compose(this.clearSubscribersErrorStrategy());
    }

    private Function<Flux<CoreEvent>, Publisher<CoreEvent>> clearSubscribersErrorStrategy() {
        return pub -> pub.subscriberContext(context -> {
            Optional onErrorStrategy = context.getOrEmpty((Object)"reactor.onNextError.localStrategy");
            if (onErrorStrategy.isPresent() && onErrorStrategy.get().toString().contains("reactor.core.publisher.OnNextFailureStrategy$ResumeStrategy")) {
                BiFunction<Throwable, Object, Throwable> onErrorContinue = (e, o) -> null;
                return context.put((Object)"reactor.onNextError.localStrategy", onErrorContinue);
            }
            return context;
        });
    }

    protected Function<Publisher<CoreEvent>, Publisher<CoreEvent>> routeThroughProcessingStrategyTransformer() {
        FluxSinkRecorder sinkRecorder = new FluxSinkRecorder();
        return pub -> Flux.from(RxUtils.propagateCompletion(pub, sinkRecorder.flux(), innerEventPub -> Flux.from((Publisher)innerEventPub).doOnNext(event -> ((BaseEventContext)event.getContext()).onResponse((e, t) -> {
            if (t != null) {
                sinkRecorder.next(Either.left((Object)t, CoreEvent.class));
            } else if (e != null) {
                sinkRecorder.next(Either.right(Throwable.class, (Object)e));
            }
        })).doOnNext(this.getSource() == null || this.getSource().getBackPressureStrategy() == MessageSource.BackPressureStrategy.WAIT ? event -> this.sink.accept((CoreEvent)event) : event -> this.sinkEmit((CoreEvent)event)).map(e -> Either.empty()), () -> sinkRecorder.complete(), t -> sinkRecorder.error((Throwable)t), this.muleContext.getConfiguration().getShutdownTimeout(), (ScheduledExecutorService)this.completionCallbackScheduler)).map(result -> {
            result.applyLeft(t -> {
                throw Exceptions.propagate((Throwable)t);
            });
            return (CoreEvent)result.getRight();
        });
    }

    private void sinkEmit(CoreEvent event) {
        BackPressureReason emitFailReason = this.sink.emit(event);
        if (emitFailReason != null) {
            this.notifyBackpressureException(event, this.backPressureExceptions.get((Object)emitFailReason));
        }
    }

    private void notifyBackpressureException(CoreEvent event, FlowBackPressureException wrappedException) {
        CoreEvent errorEvent = CoreEvent.builder(event).error(ErrorBuilder.builder((Throwable)((Object)wrappedException)).errorType(this.FLOW_BACKPRESSURE_ERROR_TYPE).build()).build();
        ((BaseEventContext)event.getContext()).error((Throwable)((Object)new MessagingException(errorEvent, (Throwable)((Object)wrappedException))));
    }

    protected ReactiveProcessor processFlowFunction() {
        return stream -> Flux.from((Publisher)stream).doOnNext(this.beforeProcessors()).transform((Function)this.processingStrategy.onPipeline(this.pipeline)).doOnNext(this.afterProcessors()).onErrorContinue(MessagingException.class, (me, e) -> ((BaseEventContext)((MessagingException)((Object)((Object)((Object)me)))).getEvent().getContext()).error((Throwable)me));
    }

    private Consumer<CoreEvent> beforeProcessors() {
        return event -> {
            FlowCallStack flowCallStack;
            if (this.getStatistics().isEnabled()) {
                this.getStatistics().incReceivedEvents();
            }
            if ((flowCallStack = event.getFlowCallStack()) instanceof DefaultFlowCallStack) {
                ((DefaultFlowCallStack)flowCallStack).push(new FlowStackElement(this.getName(), null));
            }
            this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)this), this.getName(), 1801));
            long startTime = System.currentTimeMillis();
            BaseEventContext baseEventContext = (BaseEventContext)event.getContext();
            baseEventContext.onComplete((response, throwable) -> {
                MessagingException messagingException = null;
                if (throwable != null) {
                    messagingException = throwable instanceof MessagingException ? (MessagingException)((Object)((Object)((Object)throwable))) : new MessagingException((CoreEvent)event, (Throwable)throwable, (Component)this);
                    response = messagingException.getEvent();
                }
                this.fireCompleteNotification((CoreEvent)response, messagingException);
                baseEventContext.getProcessingTime().ifPresent(time -> time.addFlowExecutionBranchTime(startTime));
            });
        };
    }

    private void fireCompleteNotification(CoreEvent event, MessagingException messagingException) {
        FlowCallStack flowCallStack = event.getFlowCallStack();
        if (flowCallStack instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)flowCallStack).pop();
        }
        this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)((Object)messagingException), (Component)this), this.getName(), 1804));
    }

    private Consumer<CoreEvent> afterProcessors() {
        return response -> {
            this.notificationFirer.dispatch((Notification)new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)response, null, (Component)this), this.getName(), 1802));
            ((BaseEventContext)response.getContext()).success((CoreEvent)response);
        };
    }

    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        for (Processor processor : this.getProcessors()) {
            if (processor instanceof Processor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
    }

    @Override
    protected void doStartProcessingStrategy() throws MuleException {
        super.doStartProcessingStrategy();
        this.startIfStartable(this.processingStrategy);
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        try {
            this.startIfStartable(this.pipeline);
            this.sink = this.processingStrategy.createSink(this, this.processFlowFunction());
        }
        catch (Exception e) {
            this.stopOnFailure(e);
            return;
        }
        this.canProcessMessage = true;
        if (this.getMuleContext().isStarted()) {
            try {
                if (this.componentInitialStateManager.mustStartMessageSource((Component)this.source)) {
                    this.startIfStartable(this.source);
                } else {
                    LOGGER.info("Not starting source for '{}' because of {}", (Object)this.getName(), (Object)this.componentInitialStateManager);
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (Exception e) {
                this.stopOnFailure(e);
            }
        }
    }

    private void stopOnFailure(Exception e) throws MuleException {
        this.stopSafely(this::doStop);
        this.stopSafely(this::doStopProcessingStrategy);
        if (e instanceof MuleException) {
            throw (MuleException)((Object)e);
        }
        throw new DefaultMuleException((Throwable)e);
    }

    private void stopSafely(CheckedRunnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw e;
            }
            LOGGER.warn(String.format("Stopping pipeline '%s' due to error on starting, but another exception was also found while shutting down: %s", this.getName(), e.getMessage()), (Throwable)e);
        }
    }

    public Consumer<CoreEvent> assertStarted() {
        return event -> {
            if (!this.canProcessMessage) {
                MessagingException exception = new MessagingException((CoreEvent)event, new LifecycleException(CoreMessages.isStopped(this.getName()), (Object)this));
                ((BaseEventContext)event.getContext()).error((Throwable)((Object)exception));
                throw Exceptions.propagate((Throwable)((Object)exception));
            }
        };
    }

    @Override
    protected void doStop() throws MuleException {
        this.stopSafely(() -> {
            if (this.componentInitialStateManager.mustStartMessageSource((Component)this.source)) {
                this.stopIfStoppable(this.source);
            } else {
                LOGGER.info("Not stopping source for '{}', it was not started because of {}", (Object)this.getName(), (Object)this.componentInitialStateManager);
            }
        });
        this.canProcessMessage = false;
        this.stopSafely(() -> this.disposeIfDisposable(this.sink));
        this.sink = null;
        this.stopIfStoppable(this.pipeline);
        super.doStop();
    }

    @Override
    protected void doStopProcessingStrategy() throws MuleException {
        this.stopIfStoppable(this.processingStrategy);
        super.doStopProcessingStrategy();
    }

    @Override
    protected void doDispose() {
        if (this.completionCallbackScheduler != null) {
            this.completionCallbackScheduler.stop();
        }
        this.disposeIfDisposable(this.pipeline);
        this.disposeIfDisposable(this.source);
        this.disposeIfDisposable(this.processingStrategy);
        super.doDispose();
    }

    protected Sink getSink() {
        return this.sink;
    }

    @Override
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    @Override
    public ProcessingStrategyFactory getProcessingStrategyFactory() {
        return this.processingStrategyFactory;
    }

    @Override
    public void checkBackpressure(CoreEvent event) throws RuntimeException {
        try {
            this.backpressureStrategySelector.check(event);
        }
        catch (FlowBackPressureException e) {
            throw Exceptions.propagate((Throwable)((Object)e));
        }
    }

    public Map<BackPressureReason, FlowBackPressureException> getBackPressureExceptions() {
        return this.backPressureExceptions;
    }
}

