/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleExceptionInfo;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.context.notification.FlowNotificationTextDebugger;
import org.mule.runtime.core.internal.context.notification.MessageProcessorTextDebugger;
import org.mule.runtime.core.internal.logging.LogConfigChangeSubject;
import org.mule.runtime.core.privileged.execution.LocationExecutionContextProvider;

public class MessageProcessingFlowTraceManager
extends LocationExecutionContextProvider
implements FlowTraceManager,
Initialisable,
Disposable {
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    private final FlowNotificationTextDebugger pipelineProcessorDebugger;
    private final MessageProcessorTextDebugger messageProcessorTextDebugger;
    private ServerNotificationManager notificationManager;
    private volatile boolean listenersAdded = false;
    private final PropertyChangeListener logConfigChangeListener = evt -> this.handleNotificationListeners();

    public MessageProcessingFlowTraceManager() {
        this.messageProcessorTextDebugger = new MessageProcessorTextDebugger(this);
        this.pipelineProcessorDebugger = new FlowNotificationTextDebugger(this);
    }

    public void initialise() throws InitialisationException {
        this.withLoggerContext(context -> ((LogConfigChangeSubject)context).registerLogConfigChangeListener(this.logConfigChangeListener));
        this.handleNotificationListeners();
    }

    public void dispose() {
        this.withLoggerContext(context -> ((LogConfigChangeSubject)context).unregisterLogConfigChangeListener(this.logConfigChangeListener));
        this.removeNotificationListeners();
    }

    protected void withLoggerContext(Consumer<LoggerContext> action) {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            action.accept(context);
        }
    }

    protected synchronized void handleNotificationListeners() {
        if (!this.notificationManager.isDisposed() && !this.listenersAdded) {
            this.notificationManager.addListener((NotificationListener<?>)this.messageProcessorTextDebugger);
            this.notificationManager.addListener((NotificationListener<?>)this.pipelineProcessorDebugger);
            this.listenersAdded = true;
        }
    }

    protected synchronized void removeNotificationListeners() {
        if (this.listenersAdded && !this.notificationManager.isDisposed()) {
            this.notificationManager.removeListener((NotificationListener<?>)this.messageProcessorTextDebugger);
            this.notificationManager.removeListener((NotificationListener<?>)this.pipelineProcessorDebugger);
            this.listenersAdded = false;
        }
    }

    public void onMessageProcessorNotificationPreInvoke(MessageProcessorNotification notification) {
        FlowCallStack flowCallStack = ((CoreEvent)notification.getEvent()).getFlowCallStack();
        if (flowCallStack != null) {
            ((DefaultFlowCallStack)flowCallStack).setCurrentProcessorPath(notification.getComponent().getRepresentation());
        }
    }

    public void onPipelineNotificationComplete(PipelineMessageNotification notification) {
        this.onFlowComplete(notification.getInfo());
    }

    public void onPipelineNotificationStart(PipelineMessageNotification notification) {
        this.onFlowStart(notification.getInfo(), notification.getResourceIdentifier());
    }

    @Override
    public void onFlowStart(EnrichedNotificationInfo notificationInfo, String flowName) {
    }

    @Override
    public void onFlowComplete(EnrichedNotificationInfo notificationInfo) {
    }

    @Override
    public Map<String, Object> getContextInfo(EnrichedNotificationInfo notificationInfo, Component lastProcessed) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.putIfAbsent(FLOW_STACK_INFO_KEY, ((CoreEvent)notificationInfo.getEvent()).getFlowCallStack().clone());
        return info;
    }

    @Override
    public void putContextInfo(MuleExceptionInfo info, EnrichedNotificationInfo notificationInfo, Component lastProcessed) {
        if (info.getFlowStack() == null) {
            info.setFlowStack((Serializable)((CoreEvent)notificationInfo.getEvent()).getFlowCallStack().clone());
        }
    }

    @Inject
    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }
}

