/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.compiler.ExpressionCompiler;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.CachedMapVariableResolverFactory;
import org.mule.mvel2.util.CompilerTools;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ModuleElementName;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.el.ExpressionLanguageSessionAdaptor;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.mvel.DelegateVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.EventVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.GlobalVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionExecutor;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguageContext;
import org.mule.runtime.core.internal.el.mvel.MVELSplitDataIterator;
import org.mule.runtime.core.internal.el.mvel.NullVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.StaticVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.VariableVariableResolverFactory;
import org.mule.runtime.core.internal.el.mvel.datatype.MvelDataTypeResolver;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class MVELExpressionLanguage
extends AbstractComponent
implements ExtendedExpressionLanguageAdaptor,
Initialisable {
    private static final String OBJECT_FOR_ENRICHMENT = "__object_for_enrichment";
    protected ParserConfiguration parserConfiguration;
    protected MuleContext muleContext;
    private MVELExpressionExecutor expressionExecutor;
    private VariableResolverFactory staticContext;
    private VariableResolverFactory globalContext;
    private String globalFunctionsString;
    private String globalFunctionsFile;
    private final Map<String, Function> globalFunctions = new HashMap<String, Function>();
    protected Map<String, String> aliases = new HashMap<String, String>();
    protected Map<String, Class<?>> imports = new HashMap();
    private boolean autoResolveVariables = true;
    private MvelDataTypeResolver dataTypeResolver = new MvelDataTypeResolver();

    @Inject
    public MVELExpressionLanguage(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.parserConfiguration = MVELExpressionLanguage.createParserConfiguration(this.imports);
        this.expressionExecutor = new MVELExpressionExecutor(this.parserConfiguration);
    }

    public void initialise() throws InitialisationException {
        this.parserConfiguration = MVELExpressionLanguage.createParserConfiguration(this.imports);
        this.expressionExecutor = new MVELExpressionExecutor(this.parserConfiguration);
        this.loadGlobalFunctions();
        this.createStaticContext();
    }

    private void createStaticContext() {
        this.staticContext = new StaticVariableResolverFactory(this.parserConfiguration, this.muleContext);
        this.globalContext = new GlobalVariableResolverFactory(this.getAliases(), this.getGlobalFunctions(), this.parserConfiguration, this.muleContext);
    }

    private void loadGlobalFunctions() throws InitialisationException {
        if (this.globalFunctionsFile != null) {
            try {
                this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions((org.mule.mvel2.compiler.CompiledExpression)new ExpressionCompiler(IOUtils.getResourceAsString(this.globalFunctionsFile, this.getClass())).compile()));
            }
            catch (IOException e) {
                throw new InitialisationException(CoreMessages.failedToLoad(this.globalFunctionsFile), (Throwable)e, (Initialisable)this);
            }
        }
        this.globalFunctions.putAll(CompilerTools.extractAllDeclaredFunctions((org.mule.mvel2.compiler.CompiledExpression)new ExpressionCompiler(this.globalFunctionsString).compile()));
    }

    public <T> T evaluateUntyped(String expression, Map<String, Object> vars) {
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        if (vars != null) {
            context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars, (VariableResolverFactory)new DelegateVariableResolverFactory(this.staticContext, this.globalContext)));
        } else {
            context.setNextFactory(new DelegateVariableResolverFactory(this.staticContext, this.globalContext));
        }
        return this.evaluateInternal(expression, context);
    }

    public <T> T evaluateUntyped(String expression, PrivilegedEvent event, PrivilegedEvent.Builder eventBuilder, ComponentLocation componentLocation, Map<String, Object> vars) {
        if (event == null) {
            return this.evaluateUntyped(expression, vars);
        }
        MVELExpressionLanguageContext context = this.createExpressionLanguageContext();
        DelegateVariableResolverFactory innerDelegate = new DelegateVariableResolverFactory(this.globalContext, this.createVariableVariableResolverFactory(event, eventBuilder));
        DelegateVariableResolverFactory delegate = new DelegateVariableResolverFactory(this.staticContext, (VariableResolverFactory)new EventVariableResolverFactory(this.parserConfiguration, this.muleContext, event, eventBuilder, componentLocation, innerDelegate));
        if (vars != null) {
            context.setNextFactory((VariableResolverFactory)new CachedMapVariableResolverFactory(vars, (VariableResolverFactory)delegate));
        } else {
            context.setNextFactory(delegate);
        }
        return this.evaluateInternal(expression, context);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        TypedValue evaluate = this.evaluate(expression, event, componentLocation, bindingContext);
        return MVELSplitDataIterator.createFrom(evaluate.getValue());
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        TypedValue evaluate = this.evaluate(expression, event, bindingContext);
        return MVELSplitDataIterator.createFrom(evaluate.getValue());
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, BindingContext context) {
        return this.evaluate(expression, event, CoreEvent.builder(event), null, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        return this.evaluate(expression, expectedOutputType, event, null, context, false);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        return this.evaluate(expression, event, componentLocation, context);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) {
        CoreEvent.Builder builder = event != null ? CoreEvent.builder(event) : null;
        return this.evaluate(expression, event, builder, componentLocation, bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext bindingContext) {
        expression = MVELExpressionLanguage.removeExpressionMarker(expression);
        HashMap<String, Object> bindingMap = new HashMap<String, Object>();
        bindingContext.identifiers().forEach(id -> bindingMap.put((String)id, ((TypedValue)bindingContext.lookup(id).get()).getValue()));
        Object value = this.evaluateUntyped(expression, (PrivilegedEvent)event, (PrivilegedEvent.Builder)eventBuilder, componentLocation, bindingMap);
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        Serializable compiledExpression = this.expressionExecutor.getCompiledExpression(expression);
        DataType dataType = event != null ? this.dataTypeResolver.resolve(value, (PrivilegedEvent)event, compiledExpression) : DataType.OBJECT;
        return new TypedValue(value, dataType);
    }

    @Override
    public CompiledExpression compile(final String expression, BindingContext bindingContext) {
        return new CompiledExpression(){

            public String expression() {
                return expression;
            }

            public Optional<MediaType> outputType() {
                return Optional.empty();
            }

            public List<ModuleElementName> externalDependencies() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public TypedValue<?> evaluateLogExpression(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.evaluate(expression, event, componentLocation, bindingContext);
    }

    protected <T> T evaluateInternal(String expression, MVELExpressionLanguageContext variableResolverFactory) {
        this.validate(expression);
        expression = MVELExpressionLanguage.removeExpressionMarker(expression);
        try {
            return (T)this.expressionExecutor.execute(expression, variableResolverFactory);
        }
        catch (Exception e) {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), e);
        }
    }

    @Override
    public ValidationResult validate(String expression) {
        if (expression.startsWith("#[")) {
            if (!expression.endsWith("]")) {
                return ValidationResult.failure((String)"Expression string is not an expression", (String)expression);
            }
            expression = expression.substring(2, expression.length() - 1);
        }
        try {
            this.expressionExecutor.validate(expression);
        }
        catch (CompileException e) {
            return ValidationResult.failure((String)e.getMessage(), (String)expression);
        }
        return ValidationResult.success();
    }

    private MVELExpressionLanguageContext createExpressionLanguageContext() {
        return new MVELExpressionLanguageContext(this.parserConfiguration, this.muleContext);
    }

    public static ParserConfiguration createParserConfiguration(Map<String, Class<?>> imports) {
        ParserConfiguration ParserConfiguration2 = new ParserConfiguration();
        MVELExpressionLanguage.configureParserConfiguration(ParserConfiguration2, imports);
        return ParserConfiguration2;
    }

    private static void configureParserConfiguration(ParserConfiguration parserConfiguration, Map<String, Class<?>> imports) {
        parserConfiguration.addPackageImport("java.io");
        parserConfiguration.addPackageImport("java.lang");
        parserConfiguration.addPackageImport("java.net");
        parserConfiguration.addPackageImport("java.util");
        parserConfiguration.addImport(BigDecimal.class);
        parserConfiguration.addImport(BigInteger.class);
        parserConfiguration.addImport(DataHandler.class);
        parserConfiguration.addImport(MimeType.class);
        parserConfiguration.addImport(Pattern.class);
        parserConfiguration.addImport(DataType.class);
        parserConfiguration.addImport(AbstractDataTypeBuilderFactory.class);
        for (Map.Entry<String, Class<?>> importEntry : imports.entrySet()) {
            parserConfiguration.addImport(importEntry.getKey(), importEntry.getValue());
        }
    }

    public void setGlobalFunctionsString(String globalFunctionsString) {
        this.globalFunctionsString = globalFunctionsString;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public void setImports(Map<String, Class<?>> imports) {
        this.imports = imports;
    }

    public void setAutoResolveVariables(boolean autoResolveVariables) {
        this.autoResolveVariables = autoResolveVariables;
    }

    public void setDataTypeResolver(MvelDataTypeResolver dataTypeResolver) {
        this.dataTypeResolver = dataTypeResolver;
    }

    public void addGlobalFunction(String name, Function function) {
        this.globalFunctions.put(name, function);
    }

    public void addImport(String name, Class<?> clazz) {
        this.imports.put(name, clazz);
    }

    public void addAlias(String name, String expression) {
        this.aliases.put(name, expression);
    }

    public void setGlobalFunctionsFile(String globalFunctionsFile) {
        this.globalFunctionsFile = globalFunctionsFile;
    }

    protected VariableResolverFactory createVariableVariableResolverFactory(PrivilegedEvent event, PrivilegedEvent.Builder eventBuilder) {
        if (this.autoResolveVariables) {
            return new VariableVariableResolverFactory(this.parserConfiguration, this.muleContext, event, eventBuilder);
        }
        return new NullVariableResolverFactory();
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public Map<String, Function> getGlobalFunctions() {
        return this.globalFunctions;
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    private static String removeExpressionMarker(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if (expression.startsWith("mel:")) {
            expression = expression.substring("mel:".length());
        }
        return expression;
    }

    private String createEnrichmentExpression(String expression) {
        expression = expression.contains("$") ? StringUtils.replace((String)expression, (String)"$", (String)OBJECT_FOR_ENRICHMENT) : expression + "=" + OBJECT_FOR_ENRICHMENT;
        return expression;
    }

    @Override
    public ExpressionLanguageSessionAdaptor openSession(final ComponentLocation componentLocation, final CoreEvent event, final BindingContext context) {
        Objects.requireNonNull(event);
        final MVELExpressionLanguage mvel = this;
        return new ExpressionLanguageSessionAdaptor(){

            @Override
            public TypedValue<?> evaluate(String expression, DataType expectedOutputType) throws ExpressionRuntimeException {
                try {
                    return mvel.evaluate(MVELExpressionLanguage.removeExpressionMarker(expression), expectedOutputType, event, componentLocation, context, false);
                }
                catch (Exception e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), e);
                }
            }

            @Override
            public TypedValue<?> evaluate(String expression) throws ExpressionRuntimeException {
                try {
                    return mvel.evaluate(MVELExpressionLanguage.removeExpressionMarker(expression), event, componentLocation, context);
                }
                catch (Exception e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), e);
                }
            }

            @Override
            public TypedValue<?> evaluate(String expression, long timeout) throws ExpressionRuntimeException {
                try {
                    return mvel.evaluate(MVELExpressionLanguage.removeExpressionMarker(expression), event, componentLocation, context);
                }
                catch (Exception e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), e);
                }
            }

            @Override
            public TypedValue<?> evaluateLogExpression(String expression) throws ExpressionRuntimeException {
                try {
                    return mvel.evaluateLogExpression(expression, event, componentLocation, context);
                }
                catch (Exception e) {
                    throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(e.getMessage(), expression), e);
                }
            }

            @Override
            public Iterator<TypedValue<?>> split(String expression) {
                return mvel.split(MVELExpressionLanguage.removeExpressionMarker(expression), event, componentLocation, context);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression) throws ExpressionExecutionException {
                return this.evaluate(expression.expression());
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, DataType expectedOutputType) throws ExpressionExecutionException {
                return this.evaluate(expression.expression(), expectedOutputType);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, long timeout) throws ExpressionExecutionException {
                return this.evaluate(expression.expression(), timeout);
            }

            @Override
            public TypedValue<?> evaluateLogExpression(CompiledExpression expression) throws ExpressionExecutionException {
                return this.evaluateLogExpression(expression.expression());
            }

            @Override
            public Iterator<TypedValue<?>> split(CompiledExpression expression) {
                return this.split(expression.expression());
            }

            @Override
            public void close() {
            }
        };
    }
}

