/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.util.Objects;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.exception.Errors;

public final class ErrorTypeBuilder {
    private String identifier;
    private String namespace;
    private ErrorType parentErrorType;

    public static ErrorTypeBuilder builder() {
        return new ErrorTypeBuilder();
    }

    private ErrorTypeBuilder() {
    }

    public ErrorTypeBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ErrorTypeBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ErrorTypeBuilder parentErrorType(ErrorType parentErrorType) {
        this.parentErrorType = parentErrorType;
        return this;
    }

    public ErrorType build() {
        Preconditions.checkState((this.identifier != null ? 1 : 0) != 0, (String)"string representation cannot be null");
        Preconditions.checkState((this.namespace != null ? 1 : 0) != 0, (String)"namespace representation cannot be null");
        if (!this.isOrphan()) {
            Preconditions.checkState((this.parentErrorType != null ? 1 : 0) != 0, (String)"parent error type cannot be null");
        }
        return new ErrorTypeImplementation(this.identifier, this.namespace, this.parentErrorType);
    }

    private boolean isOrphan() {
        return (this.identifier.equals("ANY") || this.identifier.equals("CRITICAL")) && this.namespace.equals(Errors.CORE_NAMESPACE_NAME);
    }

    private static final class ErrorTypeImplementation
    implements ErrorType {
        private static final long serialVersionUID = -3716206147606234572L;
        private final String identifier;
        private final String namespace;
        private final ErrorType parentErrorType;
        private final String asString;

        private ErrorTypeImplementation(String identifier, String namespace, ErrorType parentErrorType) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.parentErrorType = parentErrorType;
            this.asString = String.format("%s:%s", namespace, identifier);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ErrorType getParentErrorType() {
            return this.parentErrorType;
        }

        public String toString() {
            return this.asString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorTypeImplementation that = (ErrorTypeImplementation)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.parentErrorType, that.parentErrorType);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.namespace, this.parentErrorType);
        }
    }
}

