/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.AbstractCompositePolicy;
import org.mule.runtime.core.internal.policy.CommonSourcePolicy;
import org.mule.runtime.core.internal.policy.DeferredDisposable;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.PolicyEventMapper;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class CompositeSourcePolicy
extends AbstractCompositePolicy<SourcePolicyParametersTransformer>
implements SourcePolicy,
Disposable,
DeferredDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeSourcePolicy.class);
    private final CommonSourcePolicy commonPolicy;
    private final SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private final ReactiveProcessor flowExecutionProcessor;
    private final Optional<Function<MessagingException, MessagingException>> resolver;

    public CompositeSourcePolicy(List<Policy> parameterizedPolicies, ReactiveProcessor flowExecutionProcessor, Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer, SourcePolicyProcessorFactory sourcePolicyProcessorFactory, Function<MessagingException, MessagingException> resolver) {
        super(parameterizedPolicies, sourcePolicyParametersTransformer);
        this.flowExecutionProcessor = flowExecutionProcessor;
        this.sourcePolicyProcessorFactory = sourcePolicyProcessorFactory;
        this.resolver = Optional.ofNullable(resolver);
        this.initProcessor();
        this.commonPolicy = new CommonSourcePolicy(new SourceWithPoliciesFluxObjectFactory(this));
    }

    @Override
    protected ReactiveProcessor getPolicyProcessor() {
        return this.getLastPolicy().getPolicyChain().getProcessingStrategy().onPipeline(super.getPolicyProcessor());
    }

    @Override
    protected Publisher<CoreEvent> applyNextOperation(Publisher<CoreEvent> eventPub, Policy lastPolicy) {
        Optional parametersTransformer = this.getParametersTransformer();
        Function errorResolver = this.resolver.orElse(Function.identity());
        return Flux.from(eventPub).doOnNext(e -> SourcePolicyContext.from(e).setParametersTransformer(parametersTransformer)).transform((Function)this.flowExecutionProcessor).map(flowExecutionResponse -> {
            try {
                return new PolicyEventMapper().onFlowFinish((CoreEvent)flowExecutionResponse, parametersTransformer);
            }
            catch (MessagingException e) {
                throw Exceptions.propagateWrappingFatal((Throwable)errorResolver.apply(e));
            }
        });
    }

    @Override
    protected Publisher<CoreEvent> applyPolicy(Policy policy, ReactiveProcessor nextProcessor, Publisher<CoreEvent> eventPub) {
        ReactiveProcessor createSourcePolicy = this.sourcePolicyProcessorFactory.createSourcePolicy(policy, nextProcessor);
        return Flux.from(eventPub).doOnNext(s -> CompositeSourcePolicy.logEvent(CompositeSourcePolicy.getCoreEventId(s), CompositeSourcePolicy.getPolicyName(policy), () -> CompositeSourcePolicy.getCoreEventAttributesAsString(s), "Starting Policy ")).transform((Function)createSourcePolicy).doOnNext(responseEvent -> CompositeSourcePolicy.logEvent(CompositeSourcePolicy.getCoreEventId(responseEvent), CompositeSourcePolicy.getPolicyName(policy), () -> CompositeSourcePolicy.getCoreEventAttributesAsString(responseEvent), "At the end of the Policy "));
    }

    @Override
    public void process(CoreEvent sourceEvent, MessageSourceResponseParametersProcessor respParamProcessor, CompletableCallback<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> callback) {
        this.commonPolicy.process(sourceEvent, respParamProcessor, callback);
    }

    private static Map<String, Object> concatMaps(Map<String, Object> originalResponseParameters, Map<String, Object> policyResponseParameters) {
        if (originalResponseParameters == null) {
            return policyResponseParameters;
        }
        Map concatMap = SmallMap.copy(originalResponseParameters);
        policyResponseParameters.forEach((k, v) -> concatMap.merge(k, v, (v1, v2) -> v2));
        return concatMap;
    }

    private static void logEvent(String eventId, String policyName, Supplier<String> message, String startingMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event Id: " + eventId + ".\n" + startingMessage + policyName + "\n" + message.get());
        }
    }

    private static String getCoreEventId(CoreEvent event) {
        return event.getContext().getId();
    }

    private static String getCoreEventAttributesAsString(CoreEvent event) {
        if (event.getMessage() == null || event.getMessage().getAttributes() == null || event.getMessage().getAttributes().getValue() == null) {
            return "";
        }
        return event.getMessage().getAttributes().getValue().toString();
    }

    private static String getPolicyName(Policy policy) {
        return policy.getPolicyId();
    }

    private static void logSourcePolicySuccessfullResult(SourcePolicySuccessResult result) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event id: " + result.getResult().getContext().getId() + "\nFinished processing. \n" + CompositeSourcePolicy.getCoreEventAttributesAsString(result.getResult()));
        }
    }

    private static void logSourcePolicyFailureResult(SourcePolicyFailureResult result) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event id: " + result.getMessagingException().getEvent().getContext().getId() + "\nFinished processing with failure. \nError message: " + result.getMessagingException().getMessage());
        }
    }

    public void dispose() {
        this.commonPolicy.dispose();
    }

    @Override
    public Disposable deferredDispose() {
        return this.commonPolicy.deferredDispose();
    }

    private static final class SourceWithPoliciesFluxObjectFactory
    implements Supplier<FluxSink<CoreEvent>> {
        private final Reference<CompositeSourcePolicy> compositeSourcePolicy;

        public SourceWithPoliciesFluxObjectFactory(CompositeSourcePolicy compositeSourcePolicy) {
            this.compositeSourcePolicy = new WeakReference<CompositeSourcePolicy>(compositeSourcePolicy);
        }

        @Override
        public FluxSink<CoreEvent> get() {
            FluxSinkRecorder sinkRef = new FluxSinkRecorder();
            Flux policyFlux = sinkRef.flux().transform((Function)this.compositeSourcePolicy.get().getExecutionProcessor()).map(policiesResultEvent -> {
                SourcePolicyContext ctx = SourcePolicyContext.from(policiesResultEvent);
                return Either.right(SourcePolicyFailureResult.class, (Object)new SourcePolicySuccessResult((CoreEvent)policiesResultEvent, this.resolveSuccessResponseParameters((CoreEvent)policiesResultEvent, ctx), ctx.getResponseParametersProcessor()));
            }).doOnNext(result -> {
                CompositeSourcePolicy.logSourcePolicySuccessfullResult((SourcePolicySuccessResult)result.getRight());
                this.compositeSourcePolicy.get().commonPolicy.finishFlowProcessing(((SourcePolicySuccessResult)result.getRight()).getResult(), (Either<SourcePolicyFailureResult, SourcePolicySuccessResult>)result);
            }).doOnError(e -> !(e instanceof MessagingException), e -> LOGGER.error(e.getMessage(), e)).onErrorContinue(MessagingException.class, (t, e) -> {
                MessagingException me = (MessagingException)((Object)((Object)t));
                SourcePolicyContext ctx = SourcePolicyContext.from(me.getEvent());
                Either result = Either.left((Object)new SourcePolicyFailureResult(me, this.resolveErrorResponseParameters(me, ctx)), SourcePolicySuccessResult.class);
                CompositeSourcePolicy.logSourcePolicyFailureResult((SourcePolicyFailureResult)result.getLeft());
                this.compositeSourcePolicy.get().commonPolicy.finishFlowProcessing(me.getEvent(), (Either<SourcePolicyFailureResult, SourcePolicySuccessResult>)result, (Throwable)((Object)me), ctx);
            });
            policyFlux.subscribe(null, e -> LOGGER.error("Exception reached subscriber for " + this.toString(), e));
            return sinkRef.getFluxSink();
        }

        private Supplier<Map<String, Object>> resolveSuccessResponseParameters(CoreEvent policiesResultEvent, SourcePolicyContext ctx) {
            Map<String, Object> originalResponseParameters = ctx.getOriginalResponseParameters();
            return () -> this.compositeSourcePolicy.get().getParametersTransformer().map(parametersTransformer -> CompositeSourcePolicy.concatMaps(originalResponseParameters, parametersTransformer.fromMessageToSuccessResponseParameters(policiesResultEvent.getMessage()))).orElse(originalResponseParameters);
        }

        private Supplier<Map<String, Object>> resolveErrorResponseParameters(MessagingException e, SourcePolicyContext ctx) {
            Map<String, Object> originalFailureResponseParameters = ctx.getOriginalFailureResponseParameters();
            return () -> this.compositeSourcePolicy.get().getParametersTransformer().map(parametersTransformer -> CompositeSourcePolicy.concatMaps(originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(e.getEvent().getMessage()))).orElse(originalFailureResponseParameters);
        }
    }
}

