/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.FlowConstructNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.CompositePolicyFactory;
import org.mule.runtime.core.internal.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DeferredDisposable;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NoSourcePolicy;
import org.mule.runtime.core.internal.policy.NullPolicyProvider;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.PolicyPointcutParametersManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyManager
implements PolicyManager,
Lifecycle {
    private static final long POLL_INTERVAL = TimeUnit.SECONDS.toMillis(5L);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyManager.class);
    private static final OperationPolicy NO_POLICY_OPERATION = (operationEvent, operationExecutionFunction, opParamProcessor, componentLocation, callback) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent, callback);
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private ServerNotificationManager notificationManager;
    private MuleContext muleContext;
    private Registry registry;
    private CompositePolicyFactory compositePolicyFactory = new CompositePolicyFactory();
    private final AtomicBoolean isSourcePoliciesAvailable = new AtomicBoolean(false);
    private final AtomicBoolean isOperationPoliciesAvailable = new AtomicBoolean(false);
    private final ReferenceQueue<DeferredDisposable> stalePoliciesQueue = new ReferenceQueue();
    private final Set<DeferredDisposableWeakReference> activePolicies = new HashSet<DeferredDisposableWeakReference>();
    private volatile boolean stopped = true;
    private Future<?> taskHandle;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    private final Cache<String, SourcePolicy> noPolicySourceInstances = Caffeine.newBuilder().build();
    private final Cache<Pair<String, List<Policy>>, SourcePolicy> sourcePolicyInnerCache = Caffeine.newBuilder().build();
    private final Cache<List<Policy>, OperationPolicy> operationPolicyInnerCache = Caffeine.newBuilder().build();
    private final Cache<Pair<String, PolicyPointcutParameters>, SourcePolicy> sourcePolicyOuterCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private final Cache<Pair<ComponentIdentifier, PolicyPointcutParameters>, OperationPolicy> operationPolicyOuterCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private PolicyProvider policyProvider;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private PolicyPointcutParametersManager policyPointcutParametersManager;

    public static OperationPolicy noPolicyOperation() {
        return NO_POLICY_OPERATION;
    }

    public static boolean isNoPolicyOperation(OperationPolicy policy) {
        return NO_POLICY_OPERATION.equals(policy);
    }

    @Override
    public SourcePolicy createSourcePolicyInstance(Component source, CoreEvent sourceEvent, ReactiveProcessor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        ComponentIdentifier sourceIdentifier = source.getLocation().getComponentIdentifier().getIdentifier();
        if (!this.isSourcePoliciesAvailable.get()) {
            SourcePolicy policy = (SourcePolicy)this.noPolicySourceInstances.getIfPresent((Object)source.getRootContainerLocation().getGlobalName());
            if (policy != null) {
                return policy;
            }
            return (SourcePolicy)this.noPolicySourceInstances.get((Object)source.getLocation().getRootContainerName(), k -> new NoSourcePolicy(flowExecutionProcessor));
        }
        SourcePolicyContext ctx = SourcePolicyContext.from(sourceEvent);
        PolicyPointcutParameters sourcePointcutParameters = ctx.getPointcutParameters();
        Pair policyKey = new Pair((Object)source.getLocation().getRootContainerName(), (Object)sourcePointcutParameters);
        SourcePolicy policy = (SourcePolicy)this.sourcePolicyOuterCache.getIfPresent((Object)policyKey);
        if (policy != null) {
            return policy;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Source policy - populating outer cache for {}", (Object)policyKey);
        }
        SourcePolicy sourcePolicy = (SourcePolicy)this.sourcePolicyOuterCache.get((Object)policyKey, outerKey -> (SourcePolicy)this.sourcePolicyInnerCache.get((Object)new Pair((Object)source.getLocation().getRootContainerName(), this.policyProvider.findSourceParameterizedPolicies(sourcePointcutParameters)), innerKey -> ((List)innerKey.getSecond()).isEmpty() ? new NoSourcePolicy(flowExecutionProcessor) : this.compositePolicyFactory.createSourcePolicy((List)innerKey.getSecond(), flowExecutionProcessor, this.lookupSourceParametersTransformer(sourceIdentifier), this.sourcePolicyProcessorFactory, exception -> new MessagingExceptionResolver(source).resolve((MessagingException)((Object)((Object)((Object)exception))), this.errorTypeLocator, this.exceptionContextProviders))));
        this.activePolicies.add(new DeferredDisposableWeakReference((DeferredDisposable)((Object)sourcePolicy), this.stalePoliciesQueue));
        return sourcePolicy;
    }

    @Override
    public PolicyPointcutParameters addSourcePointcutParametersIntoEvent(Component source, TypedValue<?> attributes, InternalEvent event) {
        PolicyPointcutParameters sourcePolicyParams = this.policyPointcutParametersManager.createSourcePointcutParameters(source, attributes);
        event.setSourcePolicyContext(new SourcePolicyContext(sourcePolicyParams));
        return sourcePolicyParams;
    }

    @Override
    public OperationPolicy createOperationPolicy(Component operation, CoreEvent event, OperationParametersProcessor operationParameters) {
        OperationPolicy operationPolicy;
        if (!this.isOperationPoliciesAvailable.get()) {
            return NO_POLICY_OPERATION;
        }
        PolicyPointcutParameters operationPointcutParameters = this.policyPointcutParametersManager.createOperationPointcutParameters(operation, event, operationParameters.getOperationParameters());
        ComponentIdentifier operationIdentifier = operation.getLocation().getComponentIdentifier().getIdentifier();
        Pair policyKey = new Pair((Object)operationIdentifier, (Object)operationPointcutParameters);
        OperationPolicy policy = (OperationPolicy)this.operationPolicyOuterCache.getIfPresent((Object)policyKey);
        if (policy != null) {
            return policy;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Operation policy - populating outer cache for {}", (Object)policyKey);
        }
        if ((operationPolicy = (OperationPolicy)this.operationPolicyOuterCache.get((Object)policyKey, outerKey -> (OperationPolicy)this.operationPolicyInnerCache.get(this.policyProvider.findOperationParameterizedPolicies((PolicyPointcutParameters)outerKey.getSecond()), innerKey -> innerKey.isEmpty() ? NO_POLICY_OPERATION : this.compositePolicyFactory.createOperationPolicy(operation, (List<Policy>)innerKey, this.lookupOperationParametersTransformer((ComponentIdentifier)outerKey.getFirst()), this.operationPolicyProcessorFactory, this.muleContext.getConfiguration().getShutdownTimeout(), this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(operation.getLocation().getLocation() + ".policy.flux.")))))) instanceof DeferredDisposable) {
            this.activePolicies.add(new DeferredDisposableWeakReference((DeferredDisposable)((Object)operationPolicy), this.stalePoliciesQueue));
        }
        return operationPolicy;
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.registry.lookupAllByType(OperationPolicyParametersTransformer.class).stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.registry.lookupAllByType(SourcePolicyParametersTransformer.class).stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withName("PolicyManager-StaleCleaner"));
        this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory();
        this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory();
        this.policyProvider = this.registry.lookupByType(PolicyProvider.class).orElse(new NullPolicyProvider());
        if (this.muleContext.getArtifactType().equals((Object)ArtifactType.APP)) {
            this.policyProvider.onPoliciesChanged(() -> {
                this.evictCaches();
                this.isSourcePoliciesAvailable.set(this.policyProvider.isSourcePoliciesAvailable());
                this.isOperationPoliciesAvailable.set(this.policyProvider.isOperationPoliciesAvailable());
            });
            this.isSourcePoliciesAvailable.set(this.policyProvider.isSourcePoliciesAvailable());
            this.isOperationPoliciesAvailable.set(this.policyProvider.isOperationPoliciesAvailable());
        }
        this.policyPointcutParametersManager = new PolicyPointcutParametersManager(this.registry.lookupAllByType(SourcePolicyPointcutParametersFactory.class), this.registry.lookupAllByType(OperationPolicyPointcutParametersFactory.class));
        this.notificationManager.addListener((NotificationListener<?>)new FlowConstructNotificationListener<FlowConstructNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(FlowConstructNotification notification) {
                if (Integer.parseInt(notification.getAction().getIdentifier()) == 1503) {
                    LOGGER.debug("Invalidating flow from caches named {}", (Object)notification.getResourceIdentifier());
                    DefaultPolicyManager.this.invalidateDisposedFlowFromCaches(notification.getResourceIdentifier());
                }
            }
        });
    }

    private void invalidateDisposedFlowFromCaches(String flowName) {
        this.noPolicySourceInstances.invalidate((Object)flowName);
        this.sourcePolicyInnerCache.asMap().keySet().stream().filter(pair -> ((String)pair.getFirst()).equals(flowName)).forEach(matchingPair -> this.sourcePolicyInnerCache.invalidate(matchingPair));
        this.sourcePolicyOuterCache.asMap().keySet().stream().filter(pair -> ((String)pair.getFirst()).equals(flowName)).forEach(matchingPair -> this.sourcePolicyOuterCache.invalidate(matchingPair));
    }

    public void start() throws MuleException {
        try {
            this.taskHandle = this.scheduler.submit(this::disposeStalePolicies);
        }
        catch (RejectedExecutionException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        this.stopped = false;
    }

    public void stop() throws MuleException {
        this.stopped = true;
        this.taskHandle.cancel(true);
        this.taskHandle = null;
    }

    public void dispose() {
        this.disposePolicies();
        try {
            while (this.stalePoliciesQueue.remove(1L) != null) {
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw new MuleRuntimeException((Throwable)e);
            }
            LOGGER.warn("Exception when disposing DefaultPolicyManager", (Throwable)e);
        }
        this.evictCaches();
        this.scheduler.stop();
        this.activePolicies.clear();
    }

    private void disposePolicies() {
        this.noPolicySourceInstances.asMap().values().forEach(policy -> {
            this.clearActive(policy);
            LifecycleUtils.disposeIfNeeded(policy, LOGGER);
        });
        this.sourcePolicyInnerCache.asMap().values().forEach(policy -> {
            this.clearActive(policy);
            LifecycleUtils.disposeIfNeeded(policy, LOGGER);
        });
        this.operationPolicyInnerCache.asMap().values().forEach(policy -> {
            this.clearActive(policy);
            LifecycleUtils.disposeIfNeeded(policy, LOGGER);
        });
    }

    private void clearActive(@NonNull Object policy) {
        Iterator<DeferredDisposableWeakReference> iterator = this.activePolicies.iterator();
        while (iterator.hasNext()) {
            if (policy != iterator.next().get()) continue;
            iterator.remove();
        }
    }

    private void evictCaches() {
        this.noPolicySourceInstances.invalidateAll();
        this.sourcePolicyInnerCache.invalidateAll();
        this.operationPolicyInnerCache.invalidateAll();
        this.sourcePolicyOuterCache.invalidateAll();
        this.operationPolicyOuterCache.invalidateAll();
    }

    @Inject
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setCompositePolicyFactory(CompositePolicyFactory compositePolicyFactory) {
        this.compositePolicyFactory = compositePolicyFactory;
    }

    private void disposeStalePolicies() {
        while (!this.stopped && !Thread.currentThread().isInterrupted()) {
            try {
                DeferredDisposableWeakReference stalePolicy = (DeferredDisposableWeakReference)this.stalePoliciesQueue.remove(POLL_INTERVAL);
                if (stalePolicy == null) continue;
                LifecycleUtils.disposeIfNeeded(stalePolicy, LOGGER);
                this.activePolicies.remove(stalePolicy);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Stale policies cleaner thread was interrupted. Finalizing.");
            }
        }
    }

    private static final class DeferredDisposableWeakReference
    extends WeakReference<DeferredDisposable>
    implements Disposable {
        private final Disposable deferredDispose;

        public DeferredDisposableWeakReference(DeferredDisposable referent, ReferenceQueue<? super DeferredDisposable> q) {
            super(referent, q);
            this.deferredDispose = referent.deferredDispose();
        }

        public void dispose() {
            this.deferredDispose.dispose();
        }
    }
}

