/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.OperationPolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEventMapper {
    private static final String POLICY_VARS_PREFIX = "policy.vars.";
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyEventMapper.class);
    private final String policyVarsInternalParameterName;

    public PolicyEventMapper() {
        this(null);
    }

    public PolicyEventMapper(String policyId) {
        this.policyVarsInternalParameterName = POLICY_VARS_PREFIX + policyId;
    }

    public CoreEvent onSourcePolicyBegin(CoreEvent event) {
        SourcePolicyContext.from(event).setOriginalEvent(event);
        return InternalEvent.builder(event).clearVariables().build();
    }

    public CoreEvent onOperationPolicyBegin(CoreEvent event) {
        Map<String, TypedValue<?>> variables = this.loadVars(event);
        OperationPolicyContext.from(event).setOriginalEvent(event);
        return InternalEvent.builder(event).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
    }

    public CoreEvent onOperationPolicyFinish(CoreEvent result, boolean propagate) {
        OperationPolicyContext ctx = OperationPolicyContext.from(result);
        InternalEvent operationResult = ctx.getNextOperationResponse();
        if (operationResult == null) {
            return InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).variablesTyped(ctx.getOriginalEvent().getVariables()).build();
        }
        Message message = propagate ? result.getMessage() : operationResult.getMessage();
        InternalEvent next = InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).message(message).variables(operationResult.getVariables()).build();
        ctx.setNextOperationResponse(next);
        return next;
    }

    public CoreEvent onOperationPolicyError(CoreEvent result) {
        OperationPolicyContext ctx = OperationPolicyContext.from(result);
        InternalEvent nextOperationResponse = ctx.getNextOperationResponse();
        if (nextOperationResponse == null) {
            return InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).variablesTyped(ctx.getOriginalEvent().getVariables()).build();
        }
        ctx.setNextOperationResponse(nextOperationResponse);
        return InternalEvent.builder(result).addInternalParameter(this.policyVarsInternalParameterName(), result.getVariables()).variablesTyped(nextOperationResponse.getVariables()).build();
    }

    public CoreEvent onSourcePolicyNext(CoreEvent event, boolean propagate) {
        return this.onPolicyNext(event, propagate);
    }

    public CoreEvent onOperationPolicyNext(CoreEvent event) {
        return this.onPolicyNext(event, true);
    }

    public CoreEvent fromPolicyNext(CoreEvent event) {
        Map<String, TypedValue<?>> variables = this.loadVars(event);
        return InternalEvent.builder(event).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
    }

    public CoreEvent onFlowFinish(CoreEvent flowResult, Optional<SourcePolicyParametersTransformer> parametersTransformer) throws MessagingException {
        try {
            SourcePolicyContext ctx = SourcePolicyContext.from(flowResult);
            Map<String, Object> originalResponseParameters = ctx.getResponseParametersProcessor().getSuccessfulExecutionResponseParametersFunction().apply(flowResult);
            ctx.setOriginalResponseParameters(originalResponseParameters);
            Message message = parametersTransformer.map(t -> t.fromSuccessResponseParametersToMessage(originalResponseParameters)).orElseGet(() -> ((CoreEvent)flowResult).getMessage());
            return InternalEvent.builder(flowResult).message(message).build();
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error after Flow finished execution", (Throwable)e);
            }
            throw new MessagingException(flowResult, e);
        }
    }

    public CoreEvent onFlowError(CoreEvent event, String policyId, Optional<SourcePolicyParametersTransformer> parametersTransformer) {
        try {
            SourcePolicyContext ctx = SourcePolicyContext.from(event);
            if (ctx.getOriginalFailureResponseParameters() != null) {
                return event;
            }
            Map<String, Object> originalFailureResponseParameters = ctx.getResponseParametersProcessor().getFailedExecutionResponseParametersFunction().apply(event);
            ctx.setOriginalFailureResponseParameters(originalFailureResponseParameters);
            Message message = parametersTransformer.map(t -> t.fromFailureResponseParametersToMessage(originalFailureResponseParameters)).orElse(event.getMessage());
            Map<String, TypedValue<?>> variables = this.loadVars(event, policyId);
            return InternalEvent.builder(event).message(message).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Error after Flow finished execution", (Throwable)e);
            }
            Map<String, TypedValue<?>> variables = this.loadVars(event, policyId);
            return InternalEvent.builder(event).variablesTyped(variables != null ? variables : Collections.emptyMap()).build();
        }
    }

    private CoreEvent onPolicyNext(CoreEvent event, boolean propagate) {
        PrivilegedEvent originalEvent = this.getOriginalEvent(event);
        return InternalEvent.builder(event).message(propagate ? event.getMessage() : originalEvent.getMessage()).variables(originalEvent.getVariables()).addInternalParameter(this.policyVarsInternalParameterName(), event.getVariables()).build();
    }

    private String policyVarsInternalParameterName() {
        return this.policyVarsInternalParameterName;
    }

    private String policyVarsInternalParameterName(String policyId) {
        return POLICY_VARS_PREFIX + policyId;
    }

    private PrivilegedEvent getOriginalEvent(CoreEvent event) {
        PrivilegedEvent operationOriginalEvent = this.getOperationOriginalEvent(event);
        return operationOriginalEvent != null ? operationOriginalEvent : this.getSourceOriginalEvent(event);
    }

    private PrivilegedEvent getOperationOriginalEvent(CoreEvent event) {
        OperationPolicyContext ctx = OperationPolicyContext.from(event);
        return ctx != null ? (PrivilegedEvent)ctx.getOriginalEvent() : null;
    }

    private PrivilegedEvent getSourceOriginalEvent(CoreEvent event) {
        SourcePolicyContext ctx = SourcePolicyContext.from(event);
        return ctx != null ? (PrivilegedEvent)ctx.getOriginalEvent() : null;
    }

    private Map<String, TypedValue<?>> loadVars(CoreEvent event) {
        return (Map)((InternalEvent)event).getInternalParameter(this.policyVarsInternalParameterName());
    }

    private Map<String, TypedValue<?>> loadVars(CoreEvent event, String policyId) {
        return (Map)((InternalEvent)event).getInternalParameter(this.policyVarsInternalParameterName(policyId));
    }
}

