/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.BackPressureReason;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractReactorStreamProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.rx.RejectionCallbackExecutorServiceDecorator;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class StreamEmitterProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new StreamEmitterProcessingStrategy(this.getBufferSize(), this.getSubscriberCount(), this.getFlowDispatchSchedulerSupplier(muleContext, schedulersNamePrefix), this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix), this.resolveParallelism(), this.getMaxConcurrency(), this.isMaxConcurrencyEagerCheck());
    }

    @Override
    protected Supplier<org.mule.runtime.api.scheduler.Scheduler> getCpuLightSchedulerSupplier(MuleContext muleContext, String schedulersNamePrefix) {
        return () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name()));
    }

    private Supplier<org.mule.runtime.api.scheduler.Scheduler> getFlowDispatchSchedulerSupplier(MuleContext muleContext, String schedulersNamePrefix) {
        return () -> {
            SchedulerConfig config = muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + ".dispatch");
            if (FLOW_DISPATCH_WORKERS > 0) {
                config = config.withMaxConcurrentTasks(FLOW_DISPATCH_WORKERS);
            }
            return muleContext.getSchedulerService().cpuLightScheduler(config);
        };
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return StreamEmitterProcessingStrategy.class;
    }

    static class StreamEmitterProcessingStrategy
    extends AbstractReactorStreamProcessingStrategy {
        private static final Logger LOGGER = LoggerFactory.getLogger(StreamEmitterProcessingStrategy.class);
        private static final String NO_SUBSCRIPTIONS_ACTIVE_FOR_PROCESSOR = "No subscriptions active for processor.";
        private static final long SCHEDULER_BUSY_RETRY_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(2L);
        private final int bufferSize;
        private final LazyValue<org.mule.runtime.api.scheduler.Scheduler> flowDispatchSchedulerLazy;
        private final AtomicLong lastRetryTimestamp = new AtomicLong(Long.MIN_VALUE);
        private final AtomicInteger queuedEvents = new AtomicInteger();
        private final BiConsumer<CoreEvent, Throwable> queuedDecrementCallback = (e, t) -> this.queuedEvents.decrementAndGet();
        private final LongUnaryOperator lastRetryTimestampCheckOperator = v -> System.nanoTime() - v < SCHEDULER_BUSY_RETRY_INTERVAL_NS * 2L ? v : Long.MIN_VALUE;
        private final int sinksCount;
        private final AtomicInteger activeSinksCount = new AtomicInteger(0);

        public StreamEmitterProcessingStrategy(int bufferSize, int subscribers, Supplier<org.mule.runtime.api.scheduler.Scheduler> flowDispatchSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency, boolean maxConcurrencyEagerCheck) {
            super(subscribers, cpuLightSchedulerSupplier, parallelism, maxConcurrency, maxConcurrencyEagerCheck);
            this.bufferSize = bufferSize;
            this.flowDispatchSchedulerLazy = new LazyValue(flowDispatchSchedulerSupplier);
            this.sinksCount = this.getSinksCount();
        }

        @Override
        public void dispose() {
            this.stopSchedulersIfNeeded();
        }

        @Override
        protected boolean stopSchedulersIfNeeded() {
            boolean shouldStop;
            boolean bl = shouldStop = this.activeSinksCount.updateAndGet(operand -> operand == 0 ? 0 : operand - 1) == 0;
            if (shouldStop) {
                try {
                    super.stopSchedulersIfNeeded();
                }
                finally {
                    this.flowDispatchSchedulerLazy.ifComputed(org.mule.runtime.api.scheduler.Scheduler::stop);
                }
            }
            return shouldStop;
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor function) {
            long shutdownTimeout = flowConstruct.getMuleContext().getConfiguration().getShutdownTimeout();
            ArrayList sinks = new ArrayList();
            int bufferQueueSize = this.getBufferQueueSize();
            for (int i = 0; i < this.sinksCount; ++i) {
                Latch completionLatch = new Latch();
                EmitterProcessor processor = EmitterProcessor.create((int)bufferQueueSize);
                AtomicReference<Throwable> failedSubscriptionCause = new AtomicReference<Throwable>();
                processor.transform((Function)function).subscribe(null, this.getThrowableConsumer(flowConstruct, completionLatch, failedSubscriptionCause), () -> completionLatch.release());
                if (!processor.hasDownstreams()) {
                    throw this.resolveSubscriptionErrorCause(failedSubscriptionCause);
                }
                AbstractProcessingStrategy.DefaultReactorSink sink = new AbstractProcessingStrategy.DefaultReactorSink(processor.sink(FluxSink.OverflowStrategy.BUFFER), prepareDisposeTimestamp -> {
                    this.awaitSubscribersCompletion(flowConstruct, shutdownTimeout, (CountDownLatch)completionLatch, (long)prepareDisposeTimestamp);
                    this.stopSchedulersIfNeeded();
                }, this.onEventConsumer, bufferQueueSize);
                sinks.add(sink);
            }
            this.activeSinksCount.addAndGet(this.sinksCount);
            return new RoundRobinReactorSink(sinks);
        }

        @Override
        public void registerInternalSink(Publisher<CoreEvent> flux, String sinkRepresentation) {
            Latch completionLatch = new Latch();
            Flux.from(flux).subscribe(null, e -> {
                LOGGER.error("Exception reached PS subscriber for " + sinkRepresentation, e);
                completionLatch.release();
                this.stopSchedulersIfNeeded();
            }, () -> {
                completionLatch.release();
                this.stopSchedulersIfNeeded();
            });
            this.activeSinksCount.incrementAndGet();
        }

        @Override
        public Publisher<CoreEvent> configureInternalPublisher(Publisher<CoreEvent> flux) {
            return Flux.from(flux).doAfterTerminate(() -> this.stopSchedulersIfNeeded()).doOnSubscribe(s -> this.activeSinksCount.incrementAndGet());
        }

        @Override
        protected ScheduledExecutorService getNonBlockingTaskScheduler() {
            ScheduledExecutorService scheduler = super.getNonBlockingTaskScheduler();
            return this.getRetryScheduler(scheduler);
        }

        protected ScheduledExecutorService getRetryScheduler(ScheduledExecutorService scheduler) {
            return new RejectionCallbackExecutorServiceDecorator(scheduler, scheduler, () -> this.onRejected(scheduler), () -> this.lastRetryTimestamp.set(Long.MIN_VALUE), Duration.ofMillis(2L));
        }

        protected void onRejected(ScheduledExecutorService scheduler) {
            LOGGER.trace("Shared scheduler {} is busy. Scheduling of the current event will be retried after {}ms.", (Object)(scheduler instanceof org.mule.runtime.api.scheduler.Scheduler ? ((org.mule.runtime.api.scheduler.Scheduler)scheduler).getName() : scheduler.toString()), (Object)2L);
            this.lastRetryTimestamp.set(System.nanoTime());
        }

        protected int getSinksCount() {
            int coresLoad = AbstractStreamProcessingStrategyFactory.CORES * 2;
            return this.maxConcurrency < coresLoad ? this.maxConcurrency : coresLoad;
        }

        protected MuleRuntimeException resolveSubscriptionErrorCause(AtomicReference<Throwable> failedSubscriptionCause) {
            MuleRuntimeException exceptionToThrow = failedSubscriptionCause.get() != null ? new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)NO_SUBSCRIPTIONS_ACTIVE_FOR_PROCESSOR), failedSubscriptionCause.get()) : new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)NO_SUBSCRIPTIONS_ACTIVE_FOR_PROCESSOR));
            return exceptionToThrow;
        }

        protected Consumer<Throwable> getThrowableConsumer(FlowConstruct flowConstruct, Latch completionLatch, AtomicReference<Throwable> failedSubscriptionCause) {
            return e -> {
                LOGGER.error("Exception reached PS subscriber for flow '" + flowConstruct.getName() + "'", e);
                failedSubscriptionCause.set((Throwable)e);
                completionLatch.release();
            };
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            Scheduler scheduler = Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler((ScheduledExecutorService)this.getFlowDispatcherScheduler()));
            return publisher -> Flux.from((Publisher)publisher).publishOn(scheduler).doOnSubscribe(subscription -> Thread.currentThread().setContextClassLoader(this.executionClassloader)).transform((Function)pipeline);
        }

        @Override
        protected BackPressureReason checkCapacity(CoreEvent event) {
            if (this.lastRetryTimestamp.get() != Long.MIN_VALUE && this.lastRetryTimestamp.updateAndGet(this.lastRetryTimestampCheckOperator) != Long.MIN_VALUE) {
                if (!this.maxConcurrencyEagerCheck) {
                    if (this.queuedEvents.incrementAndGet() > this.getBufferQueueSize()) {
                        this.queuedEvents.decrementAndGet();
                        return BackPressureReason.REQUIRED_SCHEDULER_BUSY_WITH_FULL_BUFFER;
                    }
                    ((BaseEventContext)event.getContext()).onResponse(this.queuedDecrementCallback);
                } else {
                    return BackPressureReason.REQUIRED_SCHEDULER_BUSY;
                }
            }
            return super.checkCapacity(event);
        }

        protected org.mule.runtime.api.scheduler.Scheduler getFlowDispatcherScheduler() {
            return (org.mule.runtime.api.scheduler.Scheduler)this.flowDispatchSchedulerLazy.get();
        }

        @Override
        protected int getBufferQueueSize() {
            return this.bufferSize / this.sinksCount;
        }

        static class RoundRobinReactorSink<E>
        implements AbstractProcessingStrategy.ReactorSink<E> {
            private final List<AbstractProcessingStrategy.ReactorSink<E>> fluxSinks;
            private final AtomicInteger index = new AtomicInteger(0);
            private final IntUnaryOperator update;

            public RoundRobinReactorSink(List<AbstractProcessingStrategy.ReactorSink<E>> sinks) {
                this.fluxSinks = sinks;
                this.update = value -> (value + 1) % this.fluxSinks.size();
            }

            @Override
            public void prepareDispose() {
                this.fluxSinks.stream().forEach(sink -> sink.prepareDispose());
            }

            public void dispose() {
                this.fluxSinks.stream().forEach(sink -> sink.prepareDispose());
                this.fluxSinks.stream().forEach(sink -> sink.dispose());
            }

            @Override
            public void accept(CoreEvent event) {
                this.fluxSinks.get(this.nextIndex()).accept(event);
            }

            private int nextIndex() {
                return this.index.getAndUpdate(this.update);
            }

            @Override
            public BackPressureReason emit(CoreEvent event) {
                return this.fluxSinks.get(this.nextIndex()).emit(event);
            }

            @Override
            public E intoSink(CoreEvent event) {
                return (E)event;
            }
        }
    }
}

