/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProcessingStrategyAdapter;
import org.mule.runtime.core.internal.processor.strategy.ProcessingStrategyDecorator;
import org.mule.runtime.core.internal.processor.strategy.StreamPerThreadSink;
import org.mule.runtime.core.internal.processor.strategy.TransactionalDelegateSink;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;

public class TransactionAwareStreamEmitterProcessingStrategyDecorator
extends ProcessingStrategyDecorator {
    private static final Consumer<CoreEvent> NULL_EVENT_CONSUMER = event -> {};

    public TransactionAwareStreamEmitterProcessingStrategyDecorator(ProcessingStrategy delegate) {
        super(delegate);
        if (delegate instanceof ProcessingStrategyAdapter) {
            ProcessingStrategyAdapter adapter = (ProcessingStrategyAdapter)delegate;
            adapter.setOnEventConsumer(NULL_EVENT_CONSUMER);
            Function<ScheduledExecutorService, ScheduledExecutorService> delegateDecorator = adapter.getSchedulerDecorator();
            adapter.setSchedulerDecorator(scheduler -> new ConditionalExecutorServiceDecorator((ScheduledExecutorService)delegateDecorator.apply((ScheduledExecutorService)scheduler), currentScheduler -> TransactionCoordination.isTransactionActive()));
        }
    }

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        Sink delegateSink = this.delegate.createSink(flowConstruct, pipeline);
        StreamPerThreadSink syncSink = new StreamPerThreadSink(pipeline, NULL_EVENT_CONSUMER, flowConstruct);
        return new TransactionalDelegateSink(syncSink, delegateSink);
    }

    @Override
    public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
        return TransactionCoordination.isTransactionActive() ? BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onPipeline(pipeline) : this.delegate.onPipeline(pipeline);
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        if (TransactionCoordination.isTransactionActive()) {
            return BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onProcessor(processor);
        }
        return this.delegate.onProcessor(processor);
    }
}

