/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.rx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.util.context.Context;

public class FluxSinkRecorder<T>
implements Consumer<FluxSink<T>> {
    private volatile FluxSinkRecorderDelegate<T> delegate = new NotYetAcceptedDelegate();

    public Flux<T> flux() {
        return Flux.create((Consumer)this).subscriberContext(ctx -> Context.empty());
    }

    @Override
    public void accept(FluxSink<T> fluxSink) {
        FluxSinkRecorderDelegate<FluxSink<T>> previousDelegate = this.delegate;
        this.delegate = new DirectDelegate<T>(fluxSink);
        previousDelegate.accept(fluxSink);
    }

    public FluxSink<T> getFluxSink() {
        return this.delegate.getFluxSink();
    }

    public void next(T response) {
        this.delegate.next(response);
    }

    public void error(Throwable error) {
        this.delegate.error(error);
    }

    public void complete() {
        this.delegate.complete();
    }

    private static class DirectDelegate<T>
    implements FluxSinkRecorderDelegate<T> {
        private final FluxSink<T> fluxSink;

        public DirectDelegate(FluxSink<T> fluxSink) {
            this.fluxSink = fluxSink;
        }

        @Override
        public void accept(FluxSink<T> t) {
        }

        @Override
        public FluxSink<T> getFluxSink() {
            return this.fluxSink;
        }

        @Override
        public void next(T response) {
            this.fluxSink.next(response);
        }

        @Override
        public void error(Throwable error) {
            this.fluxSink.error(error);
        }

        @Override
        public void complete() {
            this.fluxSink.complete();
        }
    }

    private static class NotYetAcceptedDelegate<T>
    implements FluxSinkRecorderDelegate<T> {
        private volatile FluxSink<T> fluxSink;
        private final List<Runnable> bufferedEvents = new ArrayList<Runnable>();

        private NotYetAcceptedDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(FluxSink<T> fluxSink) {
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                this.fluxSink = fluxSink;
            }
            this.bufferedEvents.forEach(e -> e.run());
        }

        @Override
        public synchronized FluxSink<T> getFluxSink() {
            return this.fluxSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void next(T response) {
            boolean present = true;
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                if (this.fluxSink == null) {
                    present = false;
                    this.bufferedEvents.add(() -> this.fluxSink.next(response));
                }
            }
            if (present) {
                this.fluxSink.next(response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(Throwable error) {
            boolean present = true;
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                if (this.fluxSink == null) {
                    present = false;
                    this.bufferedEvents.add(() -> this.fluxSink.error(error));
                }
            }
            if (present) {
                this.fluxSink.error(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            boolean present = true;
            NotYetAcceptedDelegate notYetAcceptedDelegate = this;
            synchronized (notYetAcceptedDelegate) {
                if (this.fluxSink == null) {
                    present = false;
                    this.bufferedEvents.add(() -> this.fluxSink.complete());
                }
            }
            if (present) {
                this.fluxSink.complete();
            }
        }
    }

    private static interface FluxSinkRecorderDelegate<T>
    extends Consumer<FluxSink<T>> {
        public FluxSink<T> getFluxSink();

        public void next(T var1);

        public void error(Throwable var1);

        public void complete();
    }
}

