/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.NullStreamingStatistics;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider;

public class CursorManager {
    private final MutableStreamingStatistics statistics;
    private final StreamingGhostBuster ghostBuster;

    public CursorManager(MutableStreamingStatistics statistics, StreamingGhostBuster ghostBuster) {
        this.statistics = statistics instanceof NullStreamingStatistics ? null : statistics;
        this.ghostBuster = ghostBuster;
    }

    public CursorProvider manage(CursorProvider provider, DefaultEventContext ownerContext) {
        ManagedCursorProvider managedProvider;
        if (provider instanceof CursorStreamProvider) {
            managedProvider = new ManagedCursorStreamProvider((CursorProvider<CursorStream>)provider, this.statistics);
        } else if (provider instanceof CursorIteratorProvider) {
            managedProvider = new ManagedCursorIteratorProvider((CursorProvider<CursorIterator>)provider, this.statistics);
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unknown cursor provider type: " + provider.getClass().getName())));
        }
        return ownerContext.track(managedProvider, this.ghostBuster);
    }
}

