/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.exception.ErrorMapping;
import org.mule.runtime.core.internal.exception.ErrorMappingsAware;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.policy.FlowExecutionException;
import org.mule.runtime.core.internal.util.InternalExceptionUtils;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;

public class MessagingExceptionResolver {
    private final Component component;

    public MessagingExceptionResolver(Component component) {
        this.component = component;
    }

    public MessagingException resolve(MessagingException me, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders) {
        Optional<Pair<Throwable, ErrorType>> rootCause = this.findRoot(this.component, me, locator);
        if (!rootCause.isPresent()) {
            return this.updateCurrent(me, this.component, locator, exceptionContextProviders);
        }
        Throwable root = (Throwable)rootCause.get().getFirst();
        Component failingComponent = this.getFailingProcessor(me, root);
        CoreEvent event = this.resolveEvent(me, root, this.resolveErrorType((ErrorType)rootCause.get().getSecond()));
        MessagingException result = this.resolveResultException(me, root, failingComponent, event);
        this.propagateAlreadyLogged(me, result);
        return this.enrich(result, failingComponent, this.component, event, exceptionContextProviders);
    }

    private MessagingException resolveResultException(MessagingException me, Throwable root, Component failingComponent, CoreEvent event) {
        MessagingException result;
        if (root instanceof MessagingException) {
            ((MessagingException)((Object)root)).setProcessedEvent(event);
            result = (MessagingException)((Object)root);
        } else {
            result = me instanceof FlowExecutionException ? new FlowExecutionException(event, root, failingComponent) : new MessagingException(event, root, failingComponent);
        }
        return result;
    }

    private CoreEvent resolveEvent(MessagingException me, Throwable root, ErrorType errorType) {
        return EventQuickCopy.quickCopy(ErrorBuilder.builder(ExceptionUtils.getMessagingExceptionCause(root)).errorType(errorType).build(), me.getEvent());
    }

    private ErrorType resolveErrorType(ErrorType rootErrorType) {
        ErrorType errorType = rootErrorType;
        if (this.component instanceof ErrorMappingsAware) {
            errorType = ((ErrorMappingsAware)this.component).getErrorMappings().isEmpty() ? rootErrorType : ((ErrorMappingsAware)this.component).getErrorMappings().stream().filter(m -> m.match(rootErrorType)).findFirst().map(ErrorMapping::getTarget).orElse(rootErrorType);
        }
        return errorType;
    }

    private void propagateAlreadyLogged(MessagingException origin, MuleException result) {
        result.getExceptionInfo().setAlreadyLogged(origin.getExceptionInfo().isAlreadyLogged());
    }

    private Optional<Pair<Throwable, ErrorType>> findRoot(Component obj, MessagingException me, ErrorTypeLocator locator) {
        List<Pair<Throwable, ErrorType>> errors = this.collectUnsuppressedErrors(obj, me, locator);
        if (errors.isEmpty()) {
            return this.collectCritical(obj, me, locator).stream().findFirst();
        }
        if (errors.size() == 1) {
            return Optional.of(errors.get(0));
        }
        SingleErrorTypeMatcher matcher = new SingleErrorTypeMatcher((ErrorType)errors.get(errors.size() - 1).getSecond());
        return errors.stream().filter(p -> matcher.match((ErrorType)p.getSecond())).findFirst();
    }

    private List<Pair<Throwable, ErrorType>> collectUnsuppressedErrors(Component obj, MessagingException me, ErrorTypeLocator locator) {
        ArrayList<Pair<Throwable, ErrorType>> errors = new ArrayList<Pair<Throwable, ErrorType>>(4);
        List exceptionsAsList = ExceptionHelper.getExceptionsAsList((Throwable)((Object)me));
        for (Throwable e : exceptionsAsList) {
            ErrorType type = this.errorTypeFromException(obj, locator, e);
            if (ExceptionUtils.isUnknownMuleError(type) || this.isCriticalMuleError(type)) continue;
            errors.add((Pair<Throwable, ErrorType>)new Pair((Object)e, (Object)type));
        }
        return errors;
    }

    private List<Pair<Throwable, ErrorType>> collectCritical(Component obj, MessagingException me, ErrorTypeLocator locator) {
        LinkedList<Pair<Throwable, ErrorType>> errors = new LinkedList<Pair<Throwable, ErrorType>>();
        List exceptionsAsList = ExceptionHelper.getExceptionsAsList((Throwable)((Object)me));
        for (Throwable e : exceptionsAsList) {
            ErrorType type = this.errorTypeFromException(obj, locator, e);
            if (!this.isCriticalMuleError(type)) continue;
            errors.add(0, (Pair<Throwable, ErrorType>)new Pair((Object)e, (Object)type));
        }
        return errors;
    }

    private MessagingException updateCurrent(MessagingException me, Component processor, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders) {
        Component failingProcessor;
        CoreEvent errorEvent = InternalExceptionUtils.createErrorEvent(me.getEvent(), processor, me, locator);
        Component component = failingProcessor = me.getFailingComponent() != null ? me.getFailingComponent() : processor;
        MessagingException updated = errorEvent == me.getEvent() && failingProcessor == me.getFailingComponent() ? me : (me instanceof FlowExecutionException ? new FlowExecutionException(errorEvent, me.getCause(), failingProcessor) : new MessagingException(me.getI18nMessage(), errorEvent, me.getCause(), failingProcessor));
        return this.enrich(updated, failingProcessor, processor, errorEvent, exceptionContextProviders);
    }

    private Component getFailingProcessor(MessagingException me, Throwable root) {
        Component failing = me.getFailingComponent();
        if (failing == null && root instanceof MessagingException) {
            failing = ((MessagingException)((Object)root)).getFailingComponent();
        }
        return failing != null ? failing : this.component;
    }

    private ErrorType errorTypeFromException(Component failing, ErrorTypeLocator locator, Throwable e) {
        Optional eventError;
        ErrorType mapped = e instanceof MessagingException ? ((eventError = ((MessagingException)((Object)e)).getEvent().getError()).isPresent() ? ((Error)eventError.get()).getErrorType() : ((MessagingException)((Object)e)).getExceptionInfo().getErrorType()) : this.errorTypeFromNotMessagingException(failing, locator, e);
        return mapped != null ? mapped : locator.lookupErrorType(e);
    }

    private ErrorType errorTypeFromNotMessagingException(Component failing, ErrorTypeLocator locator, Throwable e) {
        ComponentIdentifier identifier = ExceptionUtils.getComponentIdentifierOf(failing);
        if (identifier != null) {
            return locator.lookupComponentErrorType(identifier, e);
        }
        return null;
    }

    private <T extends MuleException> T enrich(T me, Component failing, Component handling, CoreEvent event, Collection<ExceptionContextProvider> exceptionContextProviders) {
        EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo((Event)event, me, null);
        for (ExceptionContextProvider exceptionContextProvider : exceptionContextProviders) {
            exceptionContextProvider.putContextInfo(me.getExceptionInfo(), notificationInfo, failing);
        }
        return me;
    }

    private boolean isCriticalMuleError(ErrorType type) {
        return type.getNamespace().equals(Errors.CORE_NAMESPACE_NAME) && type.getIdentifier().equals("CRITICAL");
    }
}

