/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.RoundRobinFluxSinkSupplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RxUtils {
    public static final String KEY_ON_NEXT_ERROR_STRATEGY = "reactor.onNextError.localStrategy";
    public static final String ON_NEXT_FAILURE_STRATEGY = "reactor.core.publisher.OnNextFailureStrategy$ResumeStrategy";

    public static <T, U> Flux<T> subscribeFluxOnPublisherSubscription(Flux<T> triggeringSubscriber, Flux<U> deferredSubscriber) {
        return triggeringSubscriber.compose(eventPub -> Mono.subscriberContext().flatMapMany(ctx -> eventPub.doOnSubscribe(s -> deferredSubscriber.subscriberContext(ctx).subscribe())));
    }

    public static <T, U> Publisher<T> propagateCompletion(Publisher<U> upstream, Publisher<T> downstream, Function<Publisher<U>, Publisher<T>> transformer, CheckedRunnable completionCallback, CheckedConsumer<Throwable> errorCallback) {
        Objects.requireNonNull(upstream, "'upstream' must not be null");
        Objects.requireNonNull(downstream, "'downstream' must not be null");
        Objects.requireNonNull(transformer, "'transformer' must not be null");
        Objects.requireNonNull(completionCallback, "'completionCallback' must not be null");
        Objects.requireNonNull(errorCallback, "'errorCallback' must not be null");
        return RxUtils.doPropagateCompletion(upstream, downstream, transformer, Once.of(completionCallback), Once.of(errorCallback), () -> null, t -> null);
    }

    public static <T, U> Publisher<T> propagateCompletion(Publisher<U> upstream, Publisher<T> downstream, Function<Publisher<U>, Publisher<T>> transformer, CheckedRunnable completionCallback, CheckedConsumer<Throwable> errorCallback, long completionTimeoutMillis, ScheduledExecutorService delayedExecutor) {
        Objects.requireNonNull(upstream, "'upstream' must not be null");
        Objects.requireNonNull(downstream, "'downstream' must not be null");
        Objects.requireNonNull(transformer, "'transformer' must not be null");
        Objects.requireNonNull(completionCallback, "'completionCallback' must not be null");
        Objects.requireNonNull(errorCallback, "'errorCallback' must not be null");
        Objects.requireNonNull(delayedExecutor, "'delayedExecutor' must not be null");
        Once.RunOnce completer = Once.of(completionCallback);
        Once.ConsumeOnce<Throwable> errorForwarder = Once.of(errorCallback);
        return RxUtils.doPropagateCompletion(upstream, downstream, transformer, completer, errorForwarder, () -> delayedExecutor.schedule(() -> completer.runOnce(), completionTimeoutMillis, TimeUnit.MILLISECONDS), t -> delayedExecutor.schedule(() -> errorForwarder.consumeOnce((Throwable)t), completionTimeoutMillis, TimeUnit.MILLISECONDS));
    }

    private static <T, U> Publisher<T> doPropagateCompletion(Publisher<U> upstream, Publisher<T> downstream, Function<Publisher<U>, Publisher<T>> transformer, Once.RunOnce completer, Once.ConsumeOnce<Throwable> errorForwarder, Supplier<ScheduledFuture<?>> scheduleCompletion, Function<Throwable, ScheduledFuture<?>> scheduleErrorCompletion) {
        AtomicInteger inflightCounter = new AtomicInteger(0);
        AtomicBoolean upstreamComplete = new AtomicBoolean(false);
        AtomicReference upstreamError = new AtomicReference();
        AtomicReference scheduledCompletion = new AtomicReference();
        Flux enrichedUpstream = Flux.from(upstream).doOnNext(s -> inflightCounter.incrementAndGet()).transform(transformer).doOnComplete(() -> {
            upstreamComplete.set(true);
            if (inflightCounter.get() == 0) {
                completer.runOnce();
            } else {
                scheduledCompletion.set(scheduleCompletion.get());
            }
        }).doOnError(t -> {
            upstreamError.set(t);
            if (inflightCounter.get() == 0) {
                errorForwarder.consumeOnce((Throwable)t);
            } else {
                scheduledCompletion.set(scheduleErrorCompletion.apply((Throwable)t));
            }
        });
        return RxUtils.subscribeFluxOnPublisherSubscription(Flux.from(downstream).doOnNext(s -> {
            if (inflightCounter.decrementAndGet() == 0) {
                Throwable t;
                if (upstreamComplete.get()) {
                    completer.runOnce();
                    ScheduledFuture scheduledFuture = (ScheduledFuture)scheduledCompletion.get();
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(true);
                    }
                }
                if ((t = (Throwable)upstreamError.get()) != null) {
                    errorForwarder.consumeOnce(t);
                    ScheduledFuture scheduledFuture = (ScheduledFuture)scheduledCompletion.get();
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(true);
                    }
                }
            }
        }), enrichedUpstream);
    }

    public static Publisher<CoreEvent> transform(Publisher<CoreEvent> publisher, ReactiveProcessor processor) {
        return Flux.from(publisher).transform((Function)processor);
    }

    public static Publisher<CoreEvent> map(Publisher<CoreEvent> publisher, Function<CoreEvent, CoreEvent> mapper) {
        return Flux.from(publisher).map(mapper);
    }

    public static Publisher<CoreEvent> flatMap(Publisher<CoreEvent> publisher, Function<CoreEvent, Publisher<CoreEvent>> function, Component component) {
        return Flux.from(publisher).flatMap(event -> Mono.from((Publisher)((Publisher)function.apply((CoreEvent)event))).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException((CoreEvent)event, (Throwable)e, component)));
    }

    public static Publisher<CoreEvent> justPublishOn(CoreEvent event, ExecutorService executor) {
        return Flux.just((Object)event).publishOn(Schedulers.fromExecutorService((ExecutorService)executor));
    }

    public static <T> Supplier<FluxSink<T>> createFluxSupplier(Function<Flux<T>, Flux<?>> configurer) {
        return () -> {
            FluxSinkRecorder sinkRef = new FluxSinkRecorder();
            Flux flux = (Flux)configurer.apply(sinkRef.flux());
            flux.subscribe();
            return sinkRef.getFluxSink();
        };
    }

    public static <T> FluxSinkSupplier<T> createRoundRobinFluxSupplier(Function<Flux<T>, Flux<?>> configurer, int size) {
        return new RoundRobinFluxSinkSupplier<T>(size, RxUtils.createFluxSupplier(configurer));
    }
}

