/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Supplier;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import reactor.core.publisher.FluxSink;

public class TransactionAwareFluxSinkSupplier<T>
implements FluxSinkSupplier<T> {
    private final Supplier<FluxSink<T>> newSinkFactory;
    private final FluxSinkSupplier<T> delegate;
    private final Cache<Thread, FluxSink<T>> sinks = Caffeine.newBuilder().weakKeys().removalListener((key, value, cause) -> value.complete()).build();

    public TransactionAwareFluxSinkSupplier(Supplier<FluxSink<T>> sinkFactory, FluxSinkSupplier<T> delegate) {
        this.newSinkFactory = sinkFactory;
        this.delegate = delegate;
    }

    @Override
    public FluxSink<T> get() {
        if (TransactionCoordination.isTransactionActive()) {
            return (FluxSink)this.sinks.get((Object)Thread.currentThread(), t -> this.newSinkFactory.get());
        }
        return (FluxSink)this.delegate.get();
    }

    public void dispose() {
        this.delegate.dispose();
        this.sinks.invalidateAll();
    }
}

