/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.privileged.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredObjectStoreWrapper<T extends Serializable>
extends TemplateObjectStore<T>
implements Runnable,
MuleContextAware,
Initialisable,
Disposable {
    private static Logger LOGGER = LoggerFactory.getLogger(MonitoredObjectStoreWrapper.class);
    protected MuleContext context;
    private Scheduler scheduler;
    private ScheduledFuture<?> scheduledTask;
    ObjectStore<StoredObject<T>> baseStore;
    private Integer maxEntries = null;
    private Long entryTtl = null;
    private long expirationInterval = 1000L;
    protected String name = null;

    public MonitoredObjectStoreWrapper(ObjectStore<StoredObject<T>> baseStore, ObjectStoreSettings settings) {
        this.baseStore = baseStore;
        this.maxEntries = settings.getMaxEntries().orElse(null);
        this.entryTtl = settings.getEntryTTL().orElse(null);
        this.expirationInterval = settings.getExpirationInterval();
    }

    protected boolean doContains(String key) throws ObjectStoreException {
        return this.getStore().contains(key);
    }

    protected void doStore(String key, T value) throws ObjectStoreException {
        Long time = System.currentTimeMillis();
        this.getStore().store(key, new StoredObject<T>(value, time, key));
    }

    protected T doRetrieve(String key) throws ObjectStoreException {
        return (T)((Serializable)((StoredObject)this.getStore().retrieve(key)).getItem());
    }

    public Map<String, T> retrieveAll() throws ObjectStoreException {
        return this.getStore().retrieveAll().values().stream().collect(Collectors.toMap(StoredObject::getKey, StoredObject::getItem));
    }

    public void clear() throws ObjectStoreException {
        this.getStore().clear();
    }

    protected T doRemove(String key) throws ObjectStoreException {
        StoredObject object = (StoredObject)this.getStore().remove(key);
        if (object == null) {
            return null;
        }
        return (T)((Serializable)object.getItem());
    }

    public boolean isPersistent() {
        return this.getStore().isPersistent();
    }

    public void open() throws ObjectStoreException {
        this.getStore().open();
    }

    public void close() throws ObjectStoreException {
        this.getStore().close();
    }

    public List<String> allKeys() throws ObjectStoreException {
        return this.getStore().allKeys();
    }

    private ObjectStore<StoredObject<T>> getStore() {
        return this.baseStore;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    @Override
    public void run() {
        if (this.context.isPrimaryPollingInstance()) {
            this.expire();
        }
    }

    public void expire() {
        try {
            LOGGER.debug("Starting expiry on {}...", (Object)this.getStore().toString());
            long now = System.currentTimeMillis();
            List<String> keys = this.allKeys();
            int excess = this.maxEntries != null ? keys.size() - this.maxEntries : 0;
            PriorityQueue<StoredObject> sortedMaxEntries = null;
            if (excess > 0) {
                LOGGER.trace("Will expire {} entries from {}", (Object)excess, (Object)this.getStore().toString());
                sortedMaxEntries = new PriorityQueue<StoredObject>(excess, Comparator.comparing(paramT -> ((StoredObject)paramT).timestamp));
            }
            for (String key : keys) {
                StoredObject<T> obj = this.expiryRetrieve(key);
                if (obj == null) {
                    --excess;
                    continue;
                }
                if (this.entryTtl != null && now - obj.getTimestamp() >= this.entryTtl) {
                    LOGGER.trace("Expiring entry '{}' from {} due to TTL...", (Object)key, (Object)this.getStore().toString());
                    this.expiryRemove(key);
                    continue;
                }
                if (this.maxEntries == null || excess <= 0) continue;
                sortedMaxEntries.offer(obj);
            }
            if (sortedMaxEntries != null) {
                StoredObject obj = (StoredObject)sortedMaxEntries.poll();
                while (obj != null && excess > 0) {
                    LOGGER.trace("Expiring entry '{}' from {} due to size excess...", (Object)obj.getKey(), (Object)this.getStore().toString());
                    --excess;
                    this.expiryRemove(obj.getKey());
                    obj = sortedMaxEntries.poll();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Running expiry on " + this.getStore() + " threw " + e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
    }

    private StoredObject<T> expiryRetrieve(String key) throws ObjectStoreException {
        try {
            return (StoredObject)this.getStore().retrieve(key);
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.trace("Entry '{}' from {} already removed", (Object)key, (Object)this.getStore().toString());
            return null;
        }
    }

    private void expiryRemove(String key) throws ObjectStoreException {
        try {
            this.remove(key);
        }
        catch (ObjectDoesNotExistException e) {
            LOGGER.trace("Entry '{}' from {} already removed", (Object)key, (Object)this.getStore().toString());
        }
    }

    public void dispose() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduler.stop();
        }
    }

    public void initialise() throws InitialisationException {
        if (this.name == null) {
            this.name = UUID.getUUID();
        }
        if (this.baseStore == null) {
            this.baseStore = (ObjectStore)((MuleContextWithRegistry)this.context).getRegistry().lookupObject("_defaultPersistentObjectStore");
        }
        if (this.expirationInterval <= 0L) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Long(this.expirationInterval)).toString());
        }
        if (this.scheduler == null) {
            this.scheduler = this.context.getSchedulerService().customScheduler(this.context.getSchedulerBaseConfig().withName(this.name + "-Monitor").withMaxConcurrentTasks(1));
            this.scheduledTask = this.scheduler.scheduleWithFixedDelay((Runnable)this, 0L, this.expirationInterval, TimeUnit.MILLISECONDS);
        }
    }

    public static class StoredObject<T>
    implements Serializable,
    DeserializationPostInitialisable {
        private static final long serialVersionUID = 8656763235928199259L;
        private final T item;
        private final Long timestamp;
        private final String key;

        public StoredObject(T item, Long timestamp, String key) {
            this.item = item;
            this.timestamp = timestamp;
            this.key = key;
        }

        public T getItem() {
            return this.item;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public String getKey() {
            return this.key;
        }

        private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
            if (this.item instanceof DeserializationPostInitialisable) {
                try {
                    DeserializationPostInitialisable.Implementation.init(this.item, muleContext);
                }
                catch (Exception e) {
                    throw new DefaultMuleException((Throwable)e);
                }
            }
        }
    }
}

