/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.exception.ExceptionMapper;

public class ErrorTypeLocator {
    private final ExceptionMapper defaultExceptionMapper;
    private final Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers;
    private final ErrorType defaultError;
    private final LoadingCache<Pair<ComponentIdentifier, Class<? extends Throwable>>, ErrorType> componentErrorTypeCache;

    private ErrorTypeLocator(ExceptionMapper defaultExceptionMapper, Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers, ErrorType defaultError) {
        this.defaultExceptionMapper = defaultExceptionMapper;
        this.componentExceptionMappers = componentExceptionMappers;
        this.defaultError = defaultError;
        this.componentErrorTypeCache = Caffeine.newBuilder().build(params -> {
            ExceptionMapper exceptionMapper = (ExceptionMapper)componentExceptionMappers.get(params.getFirst());
            Optional<ErrorType> errorType = Optional.empty();
            if (exceptionMapper != null) {
                errorType = exceptionMapper.resolveErrorType((Class)params.getSecond());
            }
            return errorType.orElseGet(() -> this.lookupErrorType((Class)params.getSecond()));
        });
    }

    public ErrorType lookupErrorType(Throwable exception) {
        return this.lookupErrorType(exception.getClass());
    }

    public ErrorType lookupErrorType(Class<? extends Throwable> type) {
        return this.defaultExceptionMapper.resolveErrorType(type).orElse(this.defaultError);
    }

    public ErrorType lookupComponentErrorType(ComponentIdentifier componentIdentifier, Class<? extends Throwable> exception) {
        return (ErrorType)this.componentErrorTypeCache.get((Object)new Pair((Object)componentIdentifier, exception));
    }

    public ErrorType lookupComponentErrorType(ComponentIdentifier componentIdentifier, Throwable exception) {
        ErrorType errorTypeFromException = this.getErrorTypeFromException(exception);
        if (errorTypeFromException == null) {
            errorTypeFromException = this.lookupComponentErrorType(componentIdentifier, exception.getClass());
        }
        return errorTypeFromException;
    }

    private ErrorType getErrorTypeFromException(Throwable exception) {
        if (exception instanceof ConnectionException) {
            return ((ConnectionException)exception).getErrorType().orElse(null);
        }
        return null;
    }

    public void addComponentExceptionMapper(ComponentIdentifier componentIdentifier, ExceptionMapper exceptionMapper) {
        this.componentExceptionMappers.put(componentIdentifier, exceptionMapper);
    }

    public static Builder builder(ErrorTypeRepository errorTypeRepository) {
        return new Builder(errorTypeRepository);
    }

    public static class Builder {
        private ErrorType defaultError;
        private ExceptionMapper defaultExceptionMapper;
        private final Map<ComponentIdentifier, ExceptionMapper> componentExceptionMappers = new HashMap<ComponentIdentifier, ExceptionMapper>();

        public Builder(ErrorTypeRepository errorTypeRepository) {
            Preconditions.checkArgument((errorTypeRepository != null ? 1 : 0) != 0, (String)"error type repository cannot be null");
        }

        public Builder defaultExceptionMapper(ExceptionMapper exceptionMapper) {
            this.defaultExceptionMapper = exceptionMapper;
            return this;
        }

        public Builder addComponentExceptionMapper(ComponentIdentifier componentIdentifier, ExceptionMapper exceptionMapper) {
            this.componentExceptionMappers.put(componentIdentifier, exceptionMapper);
            return this;
        }

        public ErrorTypeLocator build() {
            Preconditions.checkState((this.defaultExceptionMapper != null ? 1 : 0) != 0, (String)"default exception mapper cannot not be null");
            Preconditions.checkState((this.componentExceptionMappers != null ? 1 : 0) != 0, (String)"component exception mappers cannot not be null");
            Preconditions.checkState((this.defaultError != null ? 1 : 0) != 0, (String)"default error cannot not be null");
            return new ErrorTypeLocator(this.defaultExceptionMapper, this.componentExceptionMappers, this.defaultError);
        }

        public Builder defaultError(ErrorType defaultError) {
            this.defaultError = defaultError;
            return this;
        }
    }
}

