/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.logging.LogUtil;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.DeploymentStopException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeployableArtifact<D extends DeployableArtifactDescriptor>
implements DeployableArtifact<D> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDeployableArtifact.class);
    protected final String shortArtifactType;
    protected final String artifactType;
    protected ArtifactContext artifactContext;
    protected ArtifactClassLoader deploymentClassLoader;

    public AbstractDeployableArtifact(String shortArtifactType, String artifactType, ArtifactClassLoader deploymentClassLoader) {
        this.artifactType = artifactType;
        this.shortArtifactType = shortArtifactType;
        this.deploymentClassLoader = deploymentClassLoader;
    }

    public final void stop() {
        if (this.artifactContext == null || !this.artifactContext.getMuleContext().getLifecycleManager().isDirectTransition("stop")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Stopping %s '%s' with no mule context", this.shortArtifactType, this.getArtifactName()));
            }
            return;
        }
        this.artifactContext.getMuleContext().getLifecycleManager().checkPhase("stop");
        ClassUtils.withContextClassLoader(null, () -> {
            if (LOGGER.isInfoEnabled()) {
                LogUtil.log((String)SplashScreen.miniSplash((String)String.format("Stopping %s '%s'", this.artifactType, this.getArtifactName())));
            }
        });
        ClassUtils.withContextClassLoader((ClassLoader)this.deploymentClassLoader.getClassLoader(), () -> {
            this.artifactContext.getMuleContext().stop();
            return null;
        });
    }

    public final void dispose() {
        ClassUtils.withContextClassLoader(null, () -> LogUtil.log((String)SplashScreen.miniSplash((String)String.format("Disposing %s '%s'", this.artifactType, this.getArtifactName()))));
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader artifactCL = null;
            if (this.getArtifactClassLoader() != null) {
                artifactCL = this.getArtifactClassLoader().getClassLoader();
            }
            if (artifactCL != null) {
                Thread.currentThread().setContextClassLoader(artifactCL);
            }
            this.doDispose();
            if (artifactCL != null) {
                if (AbstractDeployableArtifact.isRegionClassLoaderMember(artifactCL)) {
                    ((DisposableClassLoader)artifactCL.getParent()).dispose();
                } else if (artifactCL instanceof DisposableClassLoader) {
                    ((DisposableClassLoader)artifactCL).dispose();
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this.deploymentClassLoader = null;
        }
    }

    private static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !(classLoader instanceof RegionClassLoader) && classLoader.getParent() instanceof RegionClassLoader;
    }

    private void doDispose() {
        if (this.artifactContext == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("%s '%s' never started, nothing to dispose of", StringUtils.capitalize((String)this.artifactType), this.getArtifactName()));
            }
            return;
        }
        try {
            this.stop();
        }
        catch (DeploymentStopException e) {
            LOGGER.error(String.format("Error stopping %s '%s'", this.artifactType, this.getArtifactName()), (Throwable)e);
        }
        this.artifactContext.getMuleContext().dispose();
        this.artifactContext = null;
    }
}

