/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.exception.IndexOutOfBoundsException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001\u0002\f\u0018\u0001!B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005_!IQ\u0007\u0001B\u0001B\u0003%a'\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0006y!)!\t\u0001C\u0001\u0007\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\t\u0007I\u0011\u0001)\t\ra\u0003\u0001\u0015!\u0003R\u0011\u001dI\u0006\u00011A\u0005\u0002iCq!\u0019\u0001A\u0002\u0013\u0005!\r\u0003\u0004i\u0001\u0001\u0006Ka\u0017\u0005\u0006S\u0002!\tA\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006q\u0002!I!\u001f\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!\u000b\u0001\t\u0003\t\t\u0003C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005-\u0002\u0001\"\u0001\u00028\t\u0001\u0012J\u001c3fq\u0016$7i\u0015,QCJ\u001cXM\u001d\u0006\u00031e\ta\u0001]1sg\u0016\u0014(B\u0001\u000e\u001c\u0003\u0019\u0011X-\u00193fe*\u0011A$H\u0001\u0004GN4(B\u0001\u0010 \u0003\u0019iw\u000eZ;mK*\u0011\u0001%I\u0001\u0003mJR!AI\u0012\u0002\u000b],\u0017M^3\u000b\u0005\u0011*\u0013\u0001B7vY\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0003\u0001%\u0002\"AK\u0016\u000e\u0003]I!\u0001L\f\u0003\u0013\r\u001bf\u000bU1sg\u0016\u0014\u0018\u0001D:pkJ\u001cWMU3bI\u0016\u0014X#A\u0018\u0011\u0005A\u0012T\"A\u0019\u000b\u0005ii\u0012BA\u001a2\u00051\u0019v.\u001e:dKJ+\u0017\rZ3s\u00035\u0019x.\u001e:dKJ+\u0017\rZ3sA\u0005Y1m\u0015,TKR$\u0018N\\4t!\tQs'\u0003\u00029/\tY1i\u0015,TKR$\u0018N\\4t\u0013\tQ4&A\u0006dgZ\u001cV\r\u001e;j]\u001e\u001c\u0018aA2uqB\u0011Q\bQ\u0007\u0002})\u0011qhH\u0001\u0006[>$W\r\\\u0005\u0003\u0003z\u0012\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019Ai\u0012%\u0015\u0005\u00153\u0005C\u0001\u0016\u0001\u0011\u0015YT\u0001q\u0001=\u0011\u0015iS\u00011\u00010\u0011\u0015)T\u00011\u00017\u00031\u0011XmY8sIR{7.\u001a8t+\u0005Y\u0005C\u0001\u0019M\u0013\ti\u0015G\u0001\tEK\u001a\fW\u000f\u001c;M_:<\u0017I\u001d:bs\u0006i!/Z2pe\u0012$vn[3og\u0002\n!bY:w\u000b:$(/[3t+\u0005\t\u0006C\u0001*W\u001b\u0005\u0019&B\u0001\u000eU\u0015\t)V$A\u0002y[2L!aV*\u0003\u0015Q{7.\u001a8BeJ\f\u00170A\u0006dgZ,e\u000e\u001e:jKN\u0004\u0013\u0001\u00037pG\u0006$\u0018n\u001c8\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Av\u0013A\u0001T8oO\u0006aAn\\2bi&|gn\u0018\u0013fcR\u00111M\u001a\t\u00039\u0012L!!Z/\u0003\tUs\u0017\u000e\u001e\u0005\bO.\t\t\u00111\u0001\\\u0003\rAH%M\u0001\nY>\u001c\u0017\r^5p]\u0002\n\u0001bY8oi\u0006Lgn\u001d\u000b\u0003W:\u0004\"\u0001\u00187\n\u00055l&a\u0002\"p_2,\u0017M\u001c\u0005\u0006_6\u0001\raW\u0001\u0006S:$W\r_\u0001\u0004O\u0016$HC\u0001:v!\tQ3/\u0003\u0002u/\tI1i\u0015,SK\u000e|'\u000f\u001a\u0005\u0006_:\u0001\raW\u0001\tg.L\u0007\u000fT5oKR\t1-A\u0005fY\u0016lWM\u001c;BiR\u0019!0!\u0007\u0011\u0007q[X0\u0003\u0002};\n1q\n\u001d;j_:\u0004RA`A\u0007\u0003'q1a`A\u0005\u001d\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003O\u00051AH]8pizJ\u0011AX\u0005\u0004\u0003\u0017i\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0002TKFT1!a\u0003^!\rQ\u0013QC\u0005\u0004\u0003/9\"aD%oI\u0016DX\rZ\"T-\u0016sGO]=\t\u000b=\u0004\u0002\u0019A.\u0002\u0013A\f'o]3OKb$H#\u0001>\u0002+A\u0014xnY3tg:{g.U;pi\u0016$WI\u001c;ssR\u0011\u00111\u0005\t\u00079\u0006\u0015\u00121C6\n\u0007\u0005\u001dRL\u0001\u0004UkBdWMM\u0001\u0013aJ|7-Z:t#V|G/\u001a3F]R\u0014\u00180A\u0006de\u0016\fG/Z#oiJLHCBA\n\u0003_\t\u0019\u0004\u0003\u0004\u00022Q\u0001\raW\u0001\u000bm\u0006dW/Z%oI\u0016D\bBBA\u001b)\u0001\u00071.\u0001\u0005jgF+x\u000e^3e)!\t\u0019\"!\u000f\u0002<\u0005}\u0002BBA\u0019+\u0001\u00071\f\u0003\u0004\u0002>U\u0001\raW\u0001\u0005g&TX\r\u0003\u0004\u00026U\u0001\ra\u001b")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader sourceReader;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;

    @Override
    public SourceReader sourceReader() {
        return this.sourceReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean contains(long index) {
        return this.recordTokens().size() > index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(long index) {
        Option<Seq<IndexedCSVEntry>> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new IndexOutOfBoundsException((Location)UnknownLocation$.MODULE$, index, this.recordTokens().size());
        }
        return new CSVRecord((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.headers(), this.headersWithIndex(), new IndexedCSVRecordLocation((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.sourceReader()));
    }

    @Override
    public void skipLine() {
        this.sourceReader().seek(this.location());
        char next = this.sourceReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.sourceReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.sourceReader().readAscii();
                next = this.sourceReader().lookAheadAscii();
                this.location_$eq(this.sourceReader().position());
            }
        }
    }

    private Option<Seq<IndexedCSVEntry>> elementAt(long index) {
        None$ none$;
        long size;
        if (this.headers().length == 0) {
            Option<Seq<IndexedCSVEntry>> headerParsing;
            boolean hasHeaderLine;
            int headerLine = super.csvSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.csvSettings().header() && (headerParsing = this.parseNext()).isDefined()) {
                this.processHeaders((Seq<? extends CSVEntry>)((Seq)headerParsing.get()));
            }
            this.skipLines(this.linesToSkipBeforeBody());
        }
        if ((size = this.recordTokens().size()) <= index) {
            for (long remaining = index - size; remaining >= 0L; --remaining) {
                Option<Seq<IndexedCSVEntry>> nextRecordMaybe = this.parseNext();
                if (!nextRecordMaybe.isDefined()) continue;
                Seq nextRecord = (Seq)nextRecordMaybe.get();
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length();
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((Seq<long[]>)((Seq)nextRecord.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Seq$.MODULE$.canBuildFrom())));
                if (remaining != 0L) continue;
                return new Some((Object)nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply(index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.sourceReader(), this.helper());
            none$ = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])record));
        }
        return none$;
    }

    private Option<Seq<IndexedCSVEntry>> parseNext() {
        None$ none$;
        block3: {
            block2: {
                ArrayBuffer recordEntries;
                do {
                    this.sourceReader().seek(this.location());
                    recordEntries = new ArrayBuffer();
                    char value = this.sourceReader().lookAheadAscii();
                    if (value == '\uffff') break block2;
                    boolean recordFinished = false;
                    while (!recordFinished) {
                        Tuple2<IndexedCSVEntry, Object> quotedEntry = this.processNonQuotedEntry();
                        recordEntries.$plus$eq(quotedEntry._1());
                        recordFinished = quotedEntry._2$mcZ$sp();
                    }
                    this.location_$eq(this.sourceReader().position());
                } while (super.csvSettings().ignoreEmptyLine() && recordEntries.length() == 1 && ((IndexedCSVEntry)recordEntries.apply(0)).length() == 0L);
                none$ = new Some((Object)recordEntries);
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processNonQuotedEntry() {
        void var1_1;
        Tuple2 result = null;
        boolean isBlank = true;
        long valueIndex = this.sourceReader().position();
        boolean isQuoted = false;
        while (result == null) {
            Object object;
            char next = this.read();
            if (this.isQuoteChar(next) && isBlank) {
                result = this.processQuotedEntry();
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEscapeChar(next) && this.requiresEscape(this.sourceReader().lookAheadAscii())) {
                char c = this.read();
                if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c))) {
                    isBlank = false;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isColumnSeparator(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEndOfInput(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, this.sourceReader().position() - valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isLineEnding(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                if (next == '\r' && this.sourceReader().lookAheadAscii() == '\n') {
                    object = BoxesRunTime.boxToCharacter((char)this.sourceReader().readAscii());
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(next))) {
                isBlank = false;
            }
            object = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processQuotedEntry() {
        void var3_2;
        long valueIndex = this.sourceReader().position();
        Tuple2 result = null;
        boolean isQuoted = true;
        while (result == null) {
            Character c;
            char next = this.read();
            long size = this.sourceReader().previousPosition() - valueIndex;
            if (this.isEscapeChar(next) && this.requiresEscapeInQuoted(this.sourceReader().lookAheadAscii())) {
                c = BoxesRunTime.boxToCharacter((char)this.read());
                continue;
            }
            if (this.isQuoteChar(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, size, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)this.consumeUntilEndOfEntry()));
            } else if (this.isEndOfInput(next)) {
                this.logInvalidEndOfString();
                long newSize = this.sourceReader().position() - valueIndex;
                result = new Tuple2((Object)this.createEntry(valueIndex, newSize < 0L ? 0L : newSize, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            c = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public IndexedCSVEntry createEntry(long valueIndex, boolean isQuoted) {
        return this.createEntry(valueIndex, this.sourceReader().previousPosition() - valueIndex, isQuoted);
    }

    public IndexedCSVEntry createEntry(long valueIndex, long size, boolean isQuoted) {
        long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size, isQuoted);
        return new IndexedCSVEntry(token, this.sourceReader(), this.helper());
    }

    public IndexedCSVParser(SourceReader sourceReader, CSVSettings cSVSettings, EvaluationContext ctx) {
        this.sourceReader = sourceReader;
        super(cSVSettings, ctx);
        this.recordTokens = (DefaultLongArray)ctx.registerCloseable((AutoCloseable)new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.csvEntries = (TokenArray)ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.location = 0L;
    }
}

