/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.config.internal.error.MuleCoreErrorTypeRepository;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    private final SingleErrorTypeMatcher redeliveryExhaustedMatcher;
    @Inject
    private ProfilingService profilingService;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> continueProducer;
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> rollbackProducer;

    public OnErrorPropagateHandler() {
        ErrorType redeliveryExhaustedErrorType = (ErrorType)MuleCoreErrorTypeRepository.MULE_CORE_ERROR_TYPE_REPOSITORY.getErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).orElseThrow(() -> new IllegalStateException("REDELIVERY_EXHAUSTED error type not found"));
        this.redeliveryExhaustedMatcher = new SingleErrorTypeMatcher(redeliveryExhaustedErrorType);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.continueProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_CONTINUE);
        this.rollbackProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_ROLLBACK);
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && !this.when.isPresent();
    }

    boolean acceptsErrorType(ErrorType errorType) {
        return this.acceptsAll() || this.errorTypeMatcher != null && this.errorTypeMatcher.match(errorType);
    }

    @Override
    protected Function<CoreEvent, CoreEvent> beforeRouting() {
        return event -> {
            Exception exception = this.getException((CoreEvent)event);
            event = super.beforeRouting().apply((CoreEvent)event);
            if (!this.isRedeliveryExhausted(exception) && this.isOwnedTransaction(exception)) {
                TransactionUtils.profileTransactionAction(this.rollbackProducer, (ProfilingEventType<TransactionProfilingEventContext>)RuntimeProfilingEventTypes.TX_ROLLBACK, this.getLocation());
                this.rollback(exception);
            } else {
                TransactionUtils.profileTransactionAction(this.continueProducer, (ProfilingEventType<TransactionProfilingEventContext>)RuntimeProfilingEventTypes.TX_CONTINUE, this.getLocation());
            }
            return event;
        };
    }

    @Override
    public void rollback(Exception ex) {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx == null) {
            return;
        }
        try {
            tx.rollback();
        }
        catch (TransactionException e) {
            ex.addSuppressed(e);
        }
    }

    @Override
    public TemplateOnErrorHandler duplicateFor(ComponentLocation buildFor) {
        OnErrorPropagateHandler cpy = new OnErrorPropagateHandler();
        cpy.setFlowLocation(buildFor);
        this.when.ifPresent(expr -> cpy.setWhen((String)expr));
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setEnableNotifications(this.isEnableNotifications());
        cpy.setLogException(this.logException);
        cpy.setNotificationFirer(this.notificationFirer);
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return new ArrayList<Processor>(super.getOwnedMessageProcessors());
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        if (exception instanceof MessagingException) {
            Optional error = ((MessagingException)((Object)exception)).getEvent().getError();
            return error.map(e -> this.redeliveryExhaustedMatcher.match(e.getErrorType())).orElse(false);
        }
        return false;
    }
}

