/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.routing.AbstractForkJoinRouter;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.ForeachUtils;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.RoutingUtils;
import org.mule.runtime.core.internal.routing.SplittingStrategy;
import org.mule.runtime.core.internal.routing.forkjoin.CollectListForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ParallelForEach
extends AbstractForkJoinRouter {
    @Inject
    protected ExpressionManager expressionManager;
    @Inject
    protected StreamingManager streamingManager;
    @Inject
    protected FeatureFlaggingService featureFlaggingService;
    private String collectionExpression = "#[payload]";
    private SplittingStrategy<CoreEvent, Iterator<TypedValue<?>>> splittingStrategy;
    private List<Processor> messageProcessors;
    private MessageProcessorChain nestedChain;

    @Override
    public void initialise() throws InitialisationException {
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors(Optional.of(this.resolveProcessingStrategy()), this.messageProcessors);
        this.splittingStrategy = new ExpressionSplittingStrategy(this.expressionManager, this.collectionExpression);
        super.initialise();
    }

    @Override
    protected Publisher<ForkJoinStrategy.RoutingPair> getRoutingPairs(CoreEvent event) {
        return Flux.fromIterable(() -> this.splittingStrategy.split(event)).map(partTypedValue -> CoreEvent.builder(event).message(this.createMessage((TypedValue<?>)partTypedValue, event)).build()).cast(InternalEvent.class).doOnNext(evt -> RoutingUtils.setSourcePolicyChildContext(evt, this.featureFlaggingService)).map(partEvent -> ForkJoinStrategy.RoutingPair.of(partEvent, this.nestedChain));
    }

    protected TypedValue manageTypedValuePayload(TypedValue partTypedValue, CoreEvent event) {
        if (this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.PARALLEL_FOREACH_FLATTEN_MESSAGE)) {
            return ForeachUtils.manageTypedValueForStreaming(partTypedValue, event, this.streamingManager);
        }
        return StreamingUtils.updateTypedValueForStreaming(partTypedValue, event, this.streamingManager);
    }

    @Override
    protected List<MessageProcessorChain> getOwnedObjects() {
        return Collections.singletonList(this.nestedChain);
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    @Override
    protected boolean isDelayErrors() {
        return true;
    }

    @Override
    protected int getDefaultMaxConcurrency() {
        return AsyncProcessingStrategyFactory.DEFAULT_MAX_CONCURRENCY;
    }

    @Override
    protected ForkJoinStrategyFactory getDefaultForkJoinStrategyFactory() {
        return new CollectListForkJoinStrategyFactory(false);
    }

    public void setCollectionExpression(String collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    private Message createMessage(TypedValue<?> partTypedValue, CoreEvent event) {
        if (this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.PARALLEL_FOREACH_FLATTEN_MESSAGE) && partTypedValue.getValue() instanceof Message) {
            Message message = (Message)partTypedValue.getValue();
            return Message.builder((Message)message).payload(this.manageTypedValuePayload(partTypedValue, event)).build();
        }
        return Message.builder().payload(this.manageTypedValuePayload(partTypedValue, event)).build();
    }
}

