/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing.outbound;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.RouterStatistics;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.connector.DispatchException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.privileged.routing.OutboundRouter;
import org.mule.runtime.core.privileged.routing.RouterResultsHandler;
import org.mule.runtime.core.privileged.routing.RoutingException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOutboundRouter
extends AbstractMessageProcessorOwner
implements OutboundRouter {
    public static final String DEFAULT_FAILURE_EXPRESSION = "error != null";
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Processor> routes = new CopyOnWriteArrayList<Processor>();
    protected TransactionConfig transactionConfig;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private RouterStatistics routerStatistics;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);
    private Cache<Processor, MessageProcessorChain> processorChainCache = CacheBuilder.newBuilder().build();

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        TransactionalExecutionTemplate<CoreEvent> executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate(this.muleContext, this.getTransactionConfig());
        ExecutionCallback<CoreEvent> processingCallback = () -> {
            try {
                return this.route(event);
            }
            catch (RoutingException e1) {
                throw e1;
            }
            catch (Exception e2) {
                throw new RoutingException(this, e2);
            }
        };
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    protected abstract CoreEvent route(CoreEvent var1) throws MuleException;

    protected final CoreEvent sendRequest(CoreEvent event, Processor route, boolean awaitResponse) throws MuleException {
        CoreEvent result;
        try {
            result = this.sendRequestEvent(event, route, awaitResponse);
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(null, e);
        }
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(route);
        }
        if (result != null) {
            Message resultMessage = result.getMessage();
            if (this.logger.isTraceEnabled() && resultMessage != null) {
                try {
                    this.logger.trace("Response payload: \n" + StringMessageUtils.truncate(((ExtendedTransformationService)this.muleContext.getTransformationService()).getPayloadForLogging(resultMessage), 100, false));
                }
                catch (Exception e) {
                    this.logger.trace("Response payload: \n(unable to retrieve payload: " + e.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public List<Processor> getRoutes() {
        return this.routes;
    }

    @Deprecated
    public void setMessageProcessors(List<Processor> routes) throws MuleException {
        this.setRoutes(routes);
    }

    public void setRoutes(List<Processor> routes) throws MuleException {
        this.routes.clear();
        for (Processor route : routes) {
            this.addRoute(route);
        }
    }

    @Override
    public synchronized void addRoute(Processor route) throws MuleException {
        if (this.initialised.get()) {
            this.initialiseObject(route);
        }
        if (this.started.get() && route instanceof Startable) {
            ((Startable)route).start();
        }
        this.routes.add(route);
    }

    private void initialiseObject(Processor route) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(route, this.muleContext);
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public RouterResultsHandler getResultsHandler() {
        return this.resultsHandler;
    }

    public void setResultsHandler(RouterResultsHandler resultsHandler) {
        this.resultsHandler = resultsHandler;
    }

    protected CoreEvent sendRequestEvent(CoreEvent event, Processor route, boolean awaitResponse) throws MuleException {
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("connector operation"), null);
        }
        return this.doProcessRoute(route, event);
    }

    protected CoreEvent doProcessRoute(Processor route, CoreEvent event) throws MuleException {
        if (route instanceof MessageProcessorChain) {
            return route.process(event);
        }
        MessageProcessorChain chain = (MessageProcessorChain)this.processorChainCache.getIfPresent((Object)route);
        if (chain == null) {
            chain = MessageProcessors.newChain(MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()), route);
            this.initialiseObject(chain);
            this.processorChainCache.put((Object)route, (Object)chain);
        }
        return chain.process(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.initialise();
            this.initialised.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.dispose();
            this.routes = Collections.emptyList();
            this.initialised.set(false);
            this.processorChainCache.asMap().values().forEach(chain -> LifecycleUtils.disposeIfNeeded(chain, this.logger));
            this.processorChainCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.start();
            this.started.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<Processor> list = this.routes;
        synchronized (list) {
            super.stop();
            this.started.set(false);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void setRouterStatistics(RouterStatistics stats) {
        this.routerStatistics = stats;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return this.routes;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }
}

