/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Shape;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class DynamicObject
implements TruffleObject {
    private Shape shape;
    @DynamicField
    private Object[] extRef;
    @DynamicField
    private int[] extVal;
    private static final Unsafe UNSAFE = DynamicObject.getUnsafe();
    private static final long SHAPE_OFFSET;

    @Deprecated
    protected DynamicObject() {
        CompilerAsserts.neverPartOfCompilation();
        throw CompilerDirectives.shouldNotReachHere();
    }

    protected DynamicObject(Shape shape) {
        DynamicObject.verifyShape(shape, this.getClass());
        this.shape = shape;
    }

    @Deprecated
    protected DynamicObject(Shape shape, Layout.Access access) {
        if (access == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalAccessError();
        }
        DynamicObject.verifyShapeLegacy(shape, this.getClass());
        this.shape = shape;
    }

    private static void verifyShape(Shape shape, Class<? extends DynamicObject> subclass) {
        Class<? extends DynamicObject> shapeType = shape.getLayoutClass();
        if (!(shapeType == subclass || shapeType.isAssignableFrom(subclass) && DynamicObject.class.isAssignableFrom(shapeType))) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw DynamicObject.illegalShapeType(shapeType, subclass);
        }
        if (shape.hasInstanceProperties()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw DynamicObject.illegalShapeProperties();
        }
    }

    private static void verifyShapeLegacy(Shape shape, Class<? extends DynamicObject> subclass) {
        Class<? extends DynamicObject> shapeType = shape.getLayoutClass();
        if (!(shapeType == subclass || shapeType.isAssignableFrom(subclass) && DynamicObject.class.isAssignableFrom(shapeType))) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw DynamicObject.illegalShapeType(shapeType, subclass);
        }
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    private static IllegalArgumentException illegalShapeType(Class<? extends DynamicObject> shapeClass, Class<? extends DynamicObject> thisClass) {
        throw new IllegalArgumentException(String.format("Incompatible shape: layout class (%s) not assignable from this class (%s)", shapeClass.getName(), thisClass.getName()));
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    private static IllegalArgumentException illegalShapeProperties() {
        throw new IllegalArgumentException("Shape must not have instance properties");
    }

    public final Shape getShape() {
        return DynamicObject.getShapeHelper(this.shape);
    }

    private static Shape getShapeHelper(Shape shape) {
        return shape;
    }

    final void setShape(Shape shape) {
        assert (this.assertSetShape(shape));
        this.setShapeHelper(shape, SHAPE_OFFSET);
    }

    private boolean assertSetShape(Shape s) {
        Class<? extends DynamicObject> layoutType = s.getLayoutClass();
        assert (layoutType.isInstance(this)) : DynamicObject.illegalShapeType(layoutType, this.getClass());
        return true;
    }

    private void setShapeHelper(Shape shape, long shapeOffset) {
        this.shape = shape;
    }

    @Deprecated
    public Object get(Object key) {
        return DynamicObjectLibrary.getUncached().getOrDefault(this, key, null);
    }

    @Deprecated
    public Object get(Object key, Object defaultValue) {
        return DynamicObjectLibrary.getUncached().getOrDefault(this, key, defaultValue);
    }

    @Deprecated
    public boolean set(Object key, Object value) {
        return DynamicObjectLibrary.getUncached().putIfPresent(this, key, value);
    }

    @Deprecated
    public boolean containsKey(Object key) {
        return DynamicObjectLibrary.getUncached().containsKey(this, key);
    }

    @Deprecated
    public void define(Object key, Object value) {
        this.define(key, value, 0);
    }

    @Deprecated
    public void define(Object key, Object value, int flags) {
        DynamicObjectLibrary.getUncached().putWithFlags(this, key, value, flags);
    }

    @Deprecated
    public void define(Object key, Object value, int flags, LocationFactory locationFactory) {
        DynamicObject.deprecated("putWithFlags");
    }

    @Deprecated
    public boolean delete(Object key) {
        return DynamicObjectLibrary.getUncached().removeKey(this, key);
    }

    @Deprecated
    public int size() {
        return this.getShape().getPropertyCount();
    }

    @Deprecated
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Deprecated
    public void setShapeAndGrow(Shape oldShape, Shape newShape) {
        DynamicObject.deprecated();
    }

    @Deprecated
    public void setShapeAndResize(Shape oldShape, Shape newShape) {
        DynamicObject.deprecated();
    }

    @Deprecated
    public boolean updateShape() {
        return DynamicObjectLibrary.getUncached().updateShape(this);
    }

    @Deprecated
    public DynamicObject copy(Shape currentShape) {
        throw DynamicObject.deprecated();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw DynamicObject.cloneNotSupported();
    }

    @CompilerDirectives.TruffleBoundary
    private static CloneNotSupportedException cloneNotSupported() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    final DynamicObject objectClone() throws CloneNotSupportedException {
        return (DynamicObject)super.clone();
    }

    final Object[] getObjectStore() {
        return this.extRef;
    }

    final void setObjectStore(Object[] newArray) {
        this.extRef = newArray;
    }

    final int[] getPrimitiveStore() {
        return this.extVal;
    }

    final void setPrimitiveStore(int[] newArray) {
        this.extVal = newArray;
    }

    static Class<? extends Annotation> getDynamicFieldAnnotation() {
        return DynamicField.class;
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    static UnsupportedOperationException deprecated() {
        throw new UnsupportedOperationException("Deprecated. Use DynamicObjectLibrary instead.");
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    static UnsupportedOperationException deprecated(String libraryMethod) {
        throw new UnsupportedOperationException("Deprecated. Use DynamicObjectLibrary." + libraryMethod + " instead.");
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    static {
        try {
            SHAPE_OFFSET = UNSAFE.objectFieldOffset(DynamicObject.class.getDeclaredField("shape"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get 'shape' field offset", e);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface DynamicField {
    }
}

