/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.Rig;
import algebra.ring.Ring;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import cats.kernel.Eq;
import java.math.MathContext;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Field;
import spire.algebra.Signed;
import spire.algebra.Trig;
import spire.algebra.Trig$;
import spire.math.Complex;
import spire.math.Complex$mcD$sp;
import spire.math.Complex$mcF$sp;
import spire.math.ComplexAlgebra;
import spire.math.ComplexInstances;
import spire.math.ComplexInstances0;
import spire.math.ComplexInstances1;
import spire.math.Fractional;

public final class Complex$
implements ComplexInstances,
Serializable {
    public static Complex$ MODULE$;

    static {
        new Complex$();
    }

    @Override
    public <A> ComplexAlgebra<A> ComplexAlgebra(Fractional<A> evidence$8, Trig<A> evidence$9, Signed<A> evidence$10) {
        return ComplexInstances.ComplexAlgebra$(this, evidence$8, evidence$9, evidence$10);
    }

    @Override
    public ComplexAlgebra<Object> ComplexAlgebra$mDc$sp(Fractional<Object> evidence$8, Trig<Object> evidence$9, Signed<Object> evidence$10) {
        return ComplexInstances.ComplexAlgebra$mDc$sp$(this, evidence$8, evidence$9, evidence$10);
    }

    @Override
    public ComplexAlgebra<Object> ComplexAlgebra$mFc$sp(Fractional<Object> evidence$8, Trig<Object> evidence$9, Signed<Object> evidence$10) {
        return ComplexInstances.ComplexAlgebra$mFc$sp$(this, evidence$8, evidence$9, evidence$10);
    }

    @Override
    public <A> Eq<Complex<A>> ComplexEq(Eq<A> evidence$11) {
        return ComplexInstances.ComplexEq$(this, evidence$11);
    }

    @Override
    public <A> Field<Complex<A>> ComplexField(Field<A> evidence$6, Signed<A> evidence$7) {
        return ComplexInstances1.ComplexField$(this, evidence$6, evidence$7);
    }

    @Override
    public <A> Ring<Complex<A>> ComplexRing(Ring<A> evidence$4, Signed<A> evidence$5) {
        return ComplexInstances0.ComplexRing$(this, evidence$4, evidence$5);
    }

    public <T> Complex<T> i(Rig<T> T2) {
        return new Complex<Object>(T2.zero(), T2.one());
    }

    public <T> Complex<T> one(Rig<T> T2) {
        return new Complex<Object>(T2.one(), T2.zero());
    }

    public <T> Complex<T> zero(Semiring<T> T2) {
        return new Complex<Object>(T2.zero(), T2.zero());
    }

    public <T> Complex<T> fromInt(int n, Ring<T> f) {
        return new Complex<Object>(f.fromInt(n), f.zero());
    }

    public Complex<Object> intToComplex(int n) {
        return new Complex$mcD$sp(n, 0.0);
    }

    public Complex<Object> longToComplex(long n) {
        return new Complex$mcD$sp(n, 0.0);
    }

    public Complex<Object> floatToComplex(float n) {
        return new Complex$mcF$sp(n, 0.0f);
    }

    public Complex<Object> doubleToComplex(double n) {
        return new Complex$mcD$sp(n, 0.0);
    }

    public Complex<BigDecimal> bigIntToComplex(BigInt n) {
        return this.bigDecimalToComplex(package$.MODULE$.BigDecimal().apply(n));
    }

    public Complex<BigDecimal> bigDecimalToComplex(BigDecimal n) {
        MathContext mc = n.mc();
        return new Complex<BigDecimal>(n, package$.MODULE$.BigDecimal().apply(0));
    }

    public <T> Complex<T> polar(T magnitude, T angle, Field<T> evidence$1, Trig<T> evidence$2) {
        return new Complex<Object>(evidence$1.times(magnitude, Trig$.MODULE$.apply(evidence$2).cos(angle)), evidence$1.times(magnitude, Trig$.MODULE$.apply(evidence$2).sin(angle)));
    }

    public <T> Complex<T> apply(T real, Semiring<T> evidence$3) {
        return new Complex<Object>(real, spire.algebra.package$.MODULE$.Semiring().apply(evidence$3).zero());
    }

    public <T> Complex<T> rootOfUnity(int n, int x, Field<T> f, Trig<T> t) {
        if (x == 0) {
            return this.one((Rig<T>)f);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one((Rig<T>)f).unary_$minus((Rng<T>)f);
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i((Rig<T>)f);
                }
                if (x == n * 3 / 4) {
                    return this.i((Rig<T>)f).unary_$minus((Rng<T>)f);
                }
            }
        }
        return this.polar(f.one(), f.div(f.times(f.times(t.pi(), f.fromInt(2)), f.fromInt(x)), f.fromInt(n)), f, t);
    }

    public <T> Complex<T>[] rootsOfUnity(int n, Field<T> f, Trig<T> t) {
        Complex<T> sum;
        Complex[] roots = new Complex[n];
        roots[0] = sum = this.one((Rig<T>)f);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last = n - 1;
        for (int x = 1; x < last; ++x) {
            Complex<T> c;
            int n2 = x;
            Complex<Object> complex = north == n2 ? this.i((Rig<T>)f) : (west == n2 ? this.one((Rig<T>)f).unary_$minus((Rng<T>)f) : (south == n2 ? this.i((Rig<T>)f).unary_$minus((Rng<T>)f) : this.polar(f.one(), f.div(f.times(f.times(t.pi(), f.fromInt(2)), f.fromInt(x)), f.fromInt(n)), f, t)));
            roots[x] = c = complex;
            sum = sum.$plus(c, (Semiring<T>)f);
        }
        roots[last] = this.zero((Semiring<T>)f).$minus(sum, (Rng<T>)f);
        return roots;
    }

    public <T> Complex<T> apply(T real, T imag) {
        return new Complex<T>(real, imag);
    }

    public <T> Option<Tuple2<T, T>> unapply(Complex<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.real(), x$0.imag()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public Complex<Object> i$mDc$sp(Rig<Object> T2) {
        return new Complex$mcD$sp(T2.zero$mcD$sp(), T2.one$mcD$sp());
    }

    public Complex<Object> i$mFc$sp(Rig<Object> T2) {
        return new Complex$mcF$sp(T2.zero$mcF$sp(), T2.one$mcF$sp());
    }

    public Complex<Object> one$mDc$sp(Rig<Object> T2) {
        return new Complex$mcD$sp(T2.one$mcD$sp(), T2.zero$mcD$sp());
    }

    public Complex<Object> one$mFc$sp(Rig<Object> T2) {
        return new Complex$mcF$sp(T2.one$mcF$sp(), T2.zero$mcF$sp());
    }

    public Complex<Object> zero$mDc$sp(Semiring<Object> T2) {
        return new Complex$mcD$sp(T2.zero$mcD$sp(), T2.zero$mcD$sp());
    }

    public Complex<Object> zero$mFc$sp(Semiring<Object> T2) {
        return new Complex$mcF$sp(T2.zero$mcF$sp(), T2.zero$mcF$sp());
    }

    public Complex<Object> fromInt$mDc$sp(int n, Ring<Object> f) {
        return new Complex$mcD$sp(f.fromInt$mcD$sp(n), f.zero$mcD$sp());
    }

    public Complex<Object> fromInt$mFc$sp(int n, Ring<Object> f) {
        return new Complex$mcF$sp(f.fromInt$mcF$sp(n), f.zero$mcF$sp());
    }

    public Complex<Object> polar$mDc$sp(double magnitude, double angle, Field<Object> evidence$1, Trig<Object> evidence$2) {
        return new Complex$mcD$sp(evidence$1.times$mcD$sp(magnitude, Trig$.MODULE$.apply(evidence$2).cos$mcD$sp(angle)), evidence$1.times$mcD$sp(magnitude, Trig$.MODULE$.apply(evidence$2).sin$mcD$sp(angle)));
    }

    public Complex<Object> polar$mFc$sp(float magnitude, float angle, Field<Object> evidence$1, Trig<Object> evidence$2) {
        return new Complex$mcF$sp(evidence$1.times$mcF$sp(magnitude, Trig$.MODULE$.apply(evidence$2).cos$mcF$sp(angle)), evidence$1.times$mcF$sp(magnitude, Trig$.MODULE$.apply(evidence$2).sin$mcF$sp(angle)));
    }

    public Complex<Object> apply$mDc$sp(double real, Semiring<Object> evidence$3) {
        return new Complex$mcD$sp(real, spire.algebra.package$.MODULE$.Semiring().apply(evidence$3).zero$mcD$sp());
    }

    public Complex<Object> apply$mFc$sp(float real, Semiring<Object> evidence$3) {
        return new Complex$mcF$sp(real, spire.algebra.package$.MODULE$.Semiring().apply(evidence$3).zero$mcF$sp());
    }

    public Complex<Object> rootOfUnity$mDc$sp(int n, int x, Field<Object> f, Trig<Object> t) {
        if (x == 0) {
            return this.one$mDc$sp((Rig<Object>)f);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one$mDc$sp((Rig<Object>)f).unary_$minus$mcD$sp((Rng<Object>)f);
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i$mDc$sp((Rig<Object>)f);
                }
                if (x == n * 3 / 4) {
                    return this.i$mDc$sp((Rig<Object>)f).unary_$minus$mcD$sp((Rng<Object>)f);
                }
            }
        }
        return this.polar$mDc$sp(f.one$mcD$sp(), f.div$mcD$sp(f.times$mcD$sp(f.times$mcD$sp(t.pi$mcD$sp(), f.fromInt$mcD$sp(2)), f.fromInt$mcD$sp(x)), f.fromInt$mcD$sp(n)), f, t);
    }

    public Complex<Object> rootOfUnity$mFc$sp(int n, int x, Field<Object> f, Trig<Object> t) {
        if (x == 0) {
            return this.one$mFc$sp((Rig<Object>)f);
        }
        if (n % 2 == 0) {
            if (x == n / 2) {
                return this.one$mFc$sp((Rig<Object>)f).unary_$minus$mcF$sp((Rng<Object>)f);
            }
            if (n % 4 == 0) {
                if (x == n / 4) {
                    return this.i$mFc$sp((Rig<Object>)f);
                }
                if (x == n * 3 / 4) {
                    return this.i$mFc$sp((Rig<Object>)f).unary_$minus$mcF$sp((Rng<Object>)f);
                }
            }
        }
        return this.polar$mFc$sp(f.one$mcF$sp(), f.div$mcF$sp(f.times$mcF$sp(f.times$mcF$sp(t.pi$mcF$sp(), f.fromInt$mcF$sp(2)), f.fromInt$mcF$sp(x)), f.fromInt$mcF$sp(n)), f, t);
    }

    public Complex<Object>[] rootsOfUnity$mDc$sp(int n, Field<Object> f, Trig<Object> t) {
        Complex<Object> sum;
        Complex[] roots = new Complex[n];
        roots[0] = sum = this.one$mDc$sp((Rig<Object>)f);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last = n - 1;
        for (int x = 1; x < last; ++x) {
            Complex<Object> c;
            int n2 = x;
            Complex<Object> complex = north == n2 ? this.i$mDc$sp((Rig<Object>)f) : (west == n2 ? this.one$mDc$sp((Rig<Object>)f).unary_$minus$mcD$sp((Rng<Object>)f) : (south == n2 ? this.i$mDc$sp((Rig<Object>)f).unary_$minus$mcD$sp((Rng<Object>)f) : this.polar$mDc$sp(f.one$mcD$sp(), f.div$mcD$sp(f.times$mcD$sp(f.times$mcD$sp(t.pi$mcD$sp(), f.fromInt$mcD$sp(2)), f.fromInt$mcD$sp(x)), f.fromInt$mcD$sp(n)), f, t)));
            roots[x] = c = complex;
            sum = sum.$plus$mcD$sp(c, (Semiring<Object>)f);
        }
        roots[last] = this.zero$mDc$sp((Semiring<Object>)f).$minus$mcD$sp(sum, (Rng<Object>)f);
        return roots;
    }

    public Complex<Object>[] rootsOfUnity$mFc$sp(int n, Field<Object> f, Trig<Object> t) {
        Complex<Object> sum;
        Complex[] roots = new Complex[n];
        roots[0] = sum = this.one$mFc$sp((Rig<Object>)f);
        int west = n % 2 == 0 ? n / 2 : -1;
        int north = n % 4 == 0 ? n / 4 : -1;
        int south = n % 4 == 0 ? 3 * n / 4 : -1;
        int last = n - 1;
        for (int x = 1; x < last; ++x) {
            Complex<Object> c;
            int n2 = x;
            Complex<Object> complex = north == n2 ? this.i$mFc$sp((Rig<Object>)f) : (west == n2 ? this.one$mFc$sp((Rig<Object>)f).unary_$minus$mcF$sp((Rng<Object>)f) : (south == n2 ? this.i$mFc$sp((Rig<Object>)f).unary_$minus$mcF$sp((Rng<Object>)f) : this.polar$mFc$sp(f.one$mcF$sp(), f.div$mcF$sp(f.times$mcF$sp(f.times$mcF$sp(t.pi$mcF$sp(), f.fromInt$mcF$sp(2)), f.fromInt$mcF$sp(x)), f.fromInt$mcF$sp(n)), f, t)));
            roots[x] = c = complex;
            sum = sum.$plus$mcF$sp(c, (Semiring<Object>)f);
        }
        roots[last] = this.zero$mFc$sp((Semiring<Object>)f).$minus$mcF$sp(sum, (Rng<Object>)f);
        return roots;
    }

    public Complex<Object> apply$mDc$sp(double real, double imag) {
        return new Complex$mcD$sp(real, imag);
    }

    public Complex<Object> apply$mFc$sp(float real, float imag) {
        return new Complex$mcF$sp(real, imag);
    }

    public Option<Tuple2<Object, Object>> unapply$mDc$sp(Complex<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcDD.sp(x$0.real$mcD$sp(), x$0.imag$mcD$sp()));
    }

    public Option<Tuple2<Object, Object>> unapply$mFc$sp(Complex<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)x$0.real$mcF$sp()), (Object)BoxesRunTime.boxToFloat((float)x$0.imag$mcF$sp())));
    }

    private Complex$() {
        MODULE$ = this;
        ComplexInstances0.$init$(this);
        ComplexInstances1.$init$(this);
        ComplexInstances.$init$(this);
    }
}

