/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXMLSecureFactories {
    public static final String DOCUMENT_BUILDER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    public static final String SAX_PARSER_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl";
    public static final String XML_INPUT_FACTORY = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    public static final String TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    public static final String SCHEMA_FACTORY = "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory";
    public static final String DOCUMENT_BUILDER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    public static final String SAX_PARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    public static final String XML_INPUT_PROPERTY = "javax.xml.stream.XMLInputFactory";
    public static final String TRANSFORMER_PROPERTY = "javax.xml.transform.TransformerFactory";
    public static final String SCHEMA_PROPERTY = "javax.xml.validation.SchemaFactory";
    private Boolean externalEntities;
    private Boolean expandEntities;
    private static final Logger logger = LoggerFactory.getLogger(DefaultXMLSecureFactories.class);

    public DefaultXMLSecureFactories(Boolean externalEntities, Boolean expandEntities) {
        this.externalEntities = externalEntities;
        this.expandEntities = expandEntities;
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory;
        if (System.getProperty(DOCUMENT_BUILDER_PROPERTY) == null) {
            try {
                factory = DocumentBuilderFactory.newInstance(DOCUMENT_BUILDER_FACTORY, DefaultXMLSecureFactories.class.getClassLoader());
            }
            catch (FactoryConfigurationError e) {
                DefaultXMLSecureFactories.logCreationWarning(DocumentBuilderFactory.class.getName(), DOCUMENT_BUILDER_FACTORY, e);
                factory = DocumentBuilderFactory.newInstance();
            }
        } else {
            factory = DocumentBuilderFactory.newInstance();
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", this.externalEntities);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", this.externalEntities);
            factory.setExpandEntityReferences(this.expandEntities);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", this.expandEntities == false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", this.expandEntities);
        }
        catch (Exception e) {
            DefaultXMLSecureFactories.logConfigurationWarning(DocumentBuilderFactory.class.getName(), factory.getClass().getName(), e);
        }
        return factory;
    }

    public SAXParserFactory createSaxParserFactory() {
        SAXParserFactory factory;
        if (System.getProperty(SAX_PARSER_PROPERTY) == null) {
            try {
                factory = SAXParserFactory.newInstance(SAX_PARSER_FACTORY, DefaultXMLSecureFactories.class.getClassLoader());
            }
            catch (FactoryConfigurationError e) {
                DefaultXMLSecureFactories.logCreationWarning(SAXParserFactory.class.getName(), SAX_PARSER_FACTORY, e);
                factory = SAXParserFactory.newInstance();
            }
        } else {
            factory = SAXParserFactory.newInstance();
        }
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", this.externalEntities);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", this.externalEntities);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", this.expandEntities == false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", this.expandEntities);
        }
        catch (Exception e) {
            DefaultXMLSecureFactories.logConfigurationWarning(SAXParserFactory.class.getName(), factory.getClass().getName(), e);
        }
        return factory;
    }

    public XMLInputFactory createXMLInputFactory() {
        XMLInputFactory factory;
        if (System.getProperty(XML_INPUT_PROPERTY) == null) {
            try {
                String propertyName = "_mule.XMLInputFactory";
                System.setProperty("_mule.XMLInputFactory", XML_INPUT_FACTORY);
                factory = XMLInputFactory.newFactory("_mule.XMLInputFactory", DefaultXMLSecureFactories.class.getClassLoader());
            }
            catch (FactoryConfigurationError e) {
                DefaultXMLSecureFactories.logCreationWarning(XMLInputFactory.class.getName(), XML_INPUT_FACTORY, e);
                factory = XMLInputFactory.newInstance();
            }
        } else {
            factory = XMLInputFactory.newInstance();
        }
        this.configureXMLInputFactory(factory);
        return factory;
    }

    public TransformerFactory createTransformerFactory() {
        TransformerFactory factory;
        if (System.getProperty(TRANSFORMER_PROPERTY) == null) {
            try {
                factory = TransformerFactory.newInstance(TRANSFORMER_FACTORY, DefaultXMLSecureFactories.class.getClassLoader());
            }
            catch (FactoryConfigurationError e) {
                DefaultXMLSecureFactories.logCreationWarning(TransformerFactory.class.getName(), TRANSFORMER_FACTORY, e);
                factory = TransformerFactory.newInstance();
            }
        } else {
            factory = TransformerFactory.newInstance();
        }
        this.configureTransformerFactory(factory);
        return factory;
    }

    public SchemaFactory createSchemaFactory(String schemaLanguage) {
        SchemaFactory factory;
        String schemaProperty = "javax.xml.validation.SchemaFactory:" + schemaLanguage;
        if (System.getProperty(schemaProperty) == null) {
            try {
                factory = SchemaFactory.newInstance(schemaLanguage, SCHEMA_FACTORY, DefaultXMLSecureFactories.class.getClassLoader());
            }
            catch (IllegalArgumentException e) {
                DefaultXMLSecureFactories.logCreationWarning(SchemaFactory.class.getName(), SCHEMA_FACTORY, e);
                factory = SchemaFactory.newInstance(schemaLanguage);
            }
        } else {
            factory = SchemaFactory.newInstance(schemaLanguage);
        }
        this.configureSchemaFactory(factory);
        return factory;
    }

    public void configureXMLInputFactory(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", this.externalEntities);
        factory.setProperty("javax.xml.stream.supportDTD", this.expandEntities);
    }

    public void configureTransformerFactory(TransformerFactory factory) {
        if (!this.externalEntities.booleanValue() && !this.expandEntities.booleanValue()) {
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (Exception e) {
                DefaultXMLSecureFactories.logConfigurationWarning(TransformerFactory.class.getName(), factory.getClass().getName(), e);
            }
        }
    }

    public void configureSchemaFactory(SchemaFactory factory) {
        if (!this.externalEntities.booleanValue() && !this.expandEntities.booleanValue()) {
            try {
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (Exception e) {
                DefaultXMLSecureFactories.logConfigurationWarning(SchemaFactory.class.getName(), factory.getClass().getName(), e);
            }
        }
    }

    public void configureValidator(Validator validator) {
        if (!this.externalEntities.booleanValue() && !this.expandEntities.booleanValue()) {
            try {
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (Exception e) {
                DefaultXMLSecureFactories.logConfigurationWarning(Validator.class.getName(), validator.getClass().getName(), e);
            }
        }
    }

    protected static void logConfigurationWarning(String interfaceName, String implementationName, Throwable e) {
        logger.warn(String.format("Can't configure XML entity expansion for %s (%s), this could introduce XXE and BL vulnerabilities", interfaceName, implementationName), e);
    }

    protected static void logCreationWarning(String interfaceName, String desiredImplementation, Throwable e) {
        logger.warn(String.format("Can't create %s (%s), falling back to default implementation", interfaceName, desiredImplementation), e);
    }

    public Boolean getExternalEntities() {
        return this.externalEntities;
    }

    public Boolean getExpandEntities() {
        return this.expandEntities;
    }
}

