/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class ToPropertyDescriptorNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private JSToBooleanNode toBooleanNode;
    @CompilerDirectives.CompilationFinal
    private boolean wasExecuted;
    @Node.Child
    private PropertyGetNode getEnumerableNode;
    @Node.Child
    private PropertyGetNode getConfigurableNode;
    @Node.Child
    private PropertyGetNode getWritableNode;
    @Node.Child
    private PropertyGetNode getValueNode;
    @Node.Child
    private PropertyGetNode getSetNode;
    @Node.Child
    private PropertyGetNode getGetNode;
    @Node.Child
    private HasPropertyCacheNode hasEnumerableNode;
    @Node.Child
    private HasPropertyCacheNode hasConfigurableNode;
    @Node.Child
    private HasPropertyCacheNode hasWritableNode;
    @Node.Child
    private HasPropertyCacheNode hasValueNode;
    @Node.Child
    private HasPropertyCacheNode hasSetNode;
    @Node.Child
    private HasPropertyCacheNode hasGetNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    public abstract Object execute(Object var1);

    public static ToPropertyDescriptorNode create(JSContext context) {
        return ToPropertyDescriptorNodeGen.create(context);
    }

    protected ToPropertyDescriptorNode(JSContext context) {
        this.context = context;
        this.wasExecuted = context.isMultiContext();
    }

    private void initialize() {
        if (this.toBooleanNode == null || this.hasEnumerableNode == null || this.hasConfigurableNode == null || this.hasWritableNode == null || this.hasValueNode == null || this.hasGetNode == null || this.hasSetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toBooleanNode = (JSToBooleanNode)this.insert(JSToBooleanNode.create());
            this.hasEnumerableNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create("enumerable", this.context));
            this.hasConfigurableNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create("configurable", this.context));
            this.hasWritableNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create("writable", this.context));
            this.hasValueNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create("value", this.context));
            this.hasGetNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create("get", this.context));
            this.hasSetNode = (HasPropertyCacheNode)this.insert(HasPropertyCacheNode.create("set", this.context));
        }
    }

    private boolean toBoolean(Object target) {
        return this.toBooleanNode.executeBoolean(target);
    }

    protected boolean wasExecuted(DynamicObject obj) {
        return this.wasExecuted;
    }

    @Specialization(guards={"!wasExecuted(obj)", "isJSObject(obj)"})
    protected Object nonSpecialized(DynamicObject obj) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.wasExecuted = true;
        return JSRuntime.toPropertyDescriptor(obj);
    }

    @Specialization(guards={"wasExecuted(obj)", "isJSObject(obj)"})
    protected Object doDefault(DynamicObject obj, @Cached(value="create()") BranchProfile hasGetBranch, @Cached(value="create()") BranchProfile hasSetBranch, @Cached(value="create()") BranchProfile hasEnumerableBranch, @Cached(value="create()") BranchProfile hasConfigurableBranch, @Cached(value="create()") BranchProfile hasValueBranch, @Cached(value="create()") BranchProfile hasWritableBranch, @Cached(value="create()") IsCallableNode isCallable) {
        boolean hasSet;
        boolean hasGet;
        boolean hasWritable;
        boolean hasValue;
        this.initialize();
        PropertyDescriptor desc = PropertyDescriptor.createEmpty();
        if (this.hasEnumerableNode.hasProperty(obj)) {
            hasEnumerableBranch.enter();
            desc.setEnumerable(this.getEnumerableValue(obj));
        }
        if (this.hasConfigurableNode.hasProperty(obj)) {
            hasConfigurableBranch.enter();
            desc.setConfigurable(this.getConfigurableValue(obj));
        }
        if (hasValue = this.hasValueNode.hasProperty(obj)) {
            hasValueBranch.enter();
            desc.setValue(this.getValue(obj));
        }
        if (hasWritable = this.hasWritableNode.hasProperty(obj)) {
            hasWritableBranch.enter();
            desc.setWritable(this.getWritableValue(obj));
        }
        if (hasGet = this.hasGetNode.hasProperty(obj)) {
            hasGetBranch.enter();
            Object getter = this.getGet(obj);
            if (!isCallable.executeBoolean(getter) && getter != Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Getter must be a function");
            }
            desc.setGet((DynamicObject)getter);
        }
        if (hasSet = this.hasSetNode.hasProperty(obj)) {
            hasSetBranch.enter();
            Object setter = this.getSet(obj);
            if (!isCallable.executeBoolean(setter) && setter != Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Setter must be a function");
            }
            desc.setSet((DynamicObject)setter);
        }
        if ((hasGet || hasSet) && (hasValue || hasWritable)) {
            this.errorBranch.enter();
            throw Errors.createTypeError("Invalid property. A property cannot both have accessors and be writable or have a value");
        }
        return desc;
    }

    private Object getSet(DynamicObject obj) {
        if (this.getSetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getSetNode = (PropertyGetNode)this.insert(PropertyGetNode.create("set", false, this.context));
        }
        return this.getSetNode.getValue(obj);
    }

    private Object getGet(DynamicObject obj) {
        if (this.getGetNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getGetNode = (PropertyGetNode)this.insert(PropertyGetNode.create("get", false, this.context));
        }
        return this.getGetNode.getValue(obj);
    }

    private Object getValue(DynamicObject obj) {
        if (this.getValueNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getValueNode = (PropertyGetNode)this.insert(PropertyGetNode.create("value", false, this.context));
        }
        return this.getValueNode.getValue(obj);
    }

    private boolean getWritableValue(DynamicObject obj) {
        if (this.getWritableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getWritableNode = (PropertyGetNode)this.insert(PropertyGetNode.create("writable", false, this.context));
        }
        return this.toBoolean(this.getWritableNode.getValue(obj));
    }

    private boolean getConfigurableValue(DynamicObject obj) {
        if (this.getConfigurableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getConfigurableNode = (PropertyGetNode)this.insert(PropertyGetNode.create("configurable", false, this.context));
        }
        return this.toBoolean(this.getConfigurableNode.getValue(obj));
    }

    private boolean getEnumerableValue(DynamicObject obj) {
        if (this.getEnumerableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getEnumerableNode = (PropertyGetNode)this.insert(PropertyGetNode.create("enumerable", false, this.context));
        }
        return this.toBoolean(this.getEnumerableNode.getValue(obj));
    }

    @Specialization(guards={"!isJSObject(obj)"})
    protected Object doNonObject(Object obj, @Cached(value="create()") JSToStringNode toStringNode) {
        String message = this.context.isOptionV8CompatibilityMode() ? JSRuntime.stringConcat("Property description must be an object: ", toStringNode.executeString(obj)) : "must be an object";
        throw Errors.createTypeError(message);
    }
}

