/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;

public class FilteredErrorTypeRepository
implements ErrorTypeRepository {
    private final ErrorTypeRepository delegate;
    private final Set<String> filteredNamespaces;

    public FilteredErrorTypeRepository(ErrorTypeRepository delegate, Set<String> filteredNamespaces) {
        this.delegate = delegate;
        this.filteredNamespaces = filteredNamespaces;
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        if (this.filteredNamespaces.contains(errorTypeComponentIdentifier.getNamespace())) {
            return this.delegate.lookupErrorType(errorTypeComponentIdentifier);
        }
        return Optional.empty();
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        if (this.filteredNamespaces.contains(errorTypeIdentifier.getNamespace())) {
            return this.delegate.getErrorType(errorTypeIdentifier);
        }
        return Optional.empty();
    }

    public Collection<String> getErrorNamespaces() {
        return this.delegate.getErrorNamespaces().stream().filter(this.filteredNamespaces::contains).collect(Collectors.toList());
    }

    public ErrorType getAnyErrorType() {
        return this.delegate.getAnyErrorType();
    }

    public ErrorType getSourceErrorType() {
        return this.delegate.getSourceErrorType();
    }

    public ErrorType getSourceResponseErrorType() {
        return this.delegate.getSourceResponseErrorType();
    }

    public ErrorType getCriticalErrorType() {
        return this.delegate.getCriticalErrorType();
    }

    public Set<ErrorType> getErrorTypes() {
        return this.delegate.getErrorTypes().stream().filter(err -> this.filteredNamespaces.contains(err.getNamespace())).collect(Collectors.toSet());
    }

    public Set<ErrorType> getInternalErrorTypes() {
        return this.delegate.getInternalErrorTypes().stream().filter(err -> this.filteredNamespaces.contains(err.getNamespace())).collect(Collectors.toSet());
    }
}

