/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;

public class OnErrorContinueHandler
extends TemplateOnErrorHandler {
    private ErrorTypeMatcher sourceErrorMatcher;

    public OnErrorContinueHandler() {
        this.setHandleException(true);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.sourceErrorMatcher = new SingleErrorTypeMatcher(this.getErrorTypeRepository().getSourceResponseErrorType());
        if (this.errorType != null) {
            String[] errors;
            for (String error : errors = this.errorType.split(",")) {
                String sanitizedError = error.trim();
                ComponentIdentifier errorTypeIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)sanitizedError);
                Optional errorType = this.getErrorTypeRepository().lookupErrorType(errorTypeIdentifier);
                if (!errorType.isPresent() || !this.sourceErrorMatcher.match((ErrorType)errorType.get())) continue;
                throw new InitialisationException(this.getInitialisationError(sanitizedError), (Initialisable)this);
            }
        } else if (!this.when.isPresent()) {
            this.errorTypeMatcher = new SingleErrorTypeMatcher(this.getErrorTypeRepository().getAnyErrorType());
        }
    }

    private I18nMessage getInitialisationError(String type) {
        return I18nMessageFactory.createStaticMessage((String)String.format("Source errors are not allowed in 'on-error-continue' handlers. Offending type is '%s'.", type));
    }

    @Override
    public boolean acceptsAll() {
        return false;
    }

    @Override
    protected CoreEvent nullifyExceptionPayloadIfRequired(CoreEvent event) {
        return CoreEvent.builder(event).error(null).build();
    }

    @Override
    public boolean accept(CoreEvent event) {
        return !this.sourceError(event) && super.accept(event);
    }

    @Override
    public TemplateOnErrorHandler duplicateFor(ComponentLocation buildFor) {
        OnErrorContinueHandler cpy = new OnErrorContinueHandler();
        cpy.setFlowLocation(buildFor);
        this.when.ifPresent(expr -> cpy.setWhen((String)expr));
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setEnableNotifications(this.isEnableNotifications());
        cpy.setLogException(this.logException);
        cpy.setNotificationFirer(this.notificationFirer);
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    private boolean sourceError(CoreEvent event) {
        Optional error = event.getError();
        return error.isPresent() && this.sourceErrorMatcher.match(((Error)error.get()).getErrorType());
    }
}

