/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.mule.runtime.ast.api.ComponentMetadataAst;

public class DefaultComponentMetadataAst
implements ComponentMetadataAst {
    private final Optional<String> fileName;
    private final OptionalInt startLine;
    private final OptionalInt startColumn;
    private final OptionalInt endLine;
    private final OptionalInt endColumn;
    private final Optional<String> sourceCode;
    private final Map<String, String> docAttributes;
    private final Map<String, Object> syntheticAttributes;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultComponentMetadataAst(Optional<String> fileName, OptionalInt startLine, OptionalInt startColumn, OptionalInt endLine, OptionalInt endColumn, Optional<String> sourceCode, Map<String, String> docAttributes, Map<String, Object> syntheticAttributes) {
        this.fileName = fileName;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.sourceCode = sourceCode;
        this.docAttributes = docAttributes;
        this.syntheticAttributes = syntheticAttributes;
    }

    @Override
    public Optional<String> getFileName() {
        return this.fileName;
    }

    @Override
    public OptionalInt getStartLine() {
        return this.startLine;
    }

    @Override
    public OptionalInt getStartColumn() {
        return this.startColumn;
    }

    @Override
    public OptionalInt getEndLine() {
        return this.endLine;
    }

    @Override
    public OptionalInt getEndColumn() {
        return this.endColumn;
    }

    @Override
    public Optional<String> getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public Map<String, String> getDocAttributes() {
        return this.docAttributes;
    }

    @Override
    public Map<String, Object> getParserAttributes() {
        return this.syntheticAttributes;
    }

    public static class Builder {
        private Optional<String> fileName = Optional.empty();
        private OptionalInt startLine = OptionalInt.empty();
        private OptionalInt startColumn = OptionalInt.empty();
        private OptionalInt endLine = OptionalInt.empty();
        private OptionalInt endColumn = OptionalInt.empty();
        private Optional<String> sourceCode = Optional.empty();
        private final Map<String, String> docAttributes = new HashMap<String, String>();
        private final Map<String, Object> parserAttributes = new HashMap<String, Object>();

        public Builder setFileName(String fileName) {
            this.fileName = Optional.of(fileName);
            return this;
        }

        public Builder setStartLine(int startLine) {
            this.startLine = OptionalInt.of(startLine);
            return this;
        }

        public Builder setStartColumn(int startColumn) {
            this.startColumn = OptionalInt.of(startColumn);
            return this;
        }

        public Builder setEndLine(int endLine) {
            this.endLine = OptionalInt.of(endLine);
            return this;
        }

        public Builder setEndColumn(int endColumn) {
            this.endColumn = OptionalInt.of(endColumn);
            return this;
        }

        public Builder setSourceCode(String sourceCode) {
            this.sourceCode = Optional.of(sourceCode);
            return this;
        }

        public Builder putDocAttribute(String key, String value) {
            this.docAttributes.put(key, value);
            return this;
        }

        public Builder putParserAttribute(String key, Object value) {
            this.parserAttributes.put(key, value);
            return this;
        }

        public ComponentMetadataAst build() {
            return new DefaultComponentMetadataAst(this.fileName, this.startLine, this.startColumn, this.endLine, this.endColumn, this.sourceCode, Collections.unmodifiableMap(this.docAttributes), Collections.unmodifiableMap(this.parserAttributes));
        }
    }
}

