/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.functions;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.mule.weave.v2.RuntimeConfigProperties$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.io.SeekableStream$;
import org.mule.weave.v2.model.DefaultEvaluationContext;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.ServiceManager$;
import org.mule.weave.v2.model.WeaveServicesProvider;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.option.Settings;
import org.mule.weave.v2.module.reader.AutoPersistedOutputStream;
import org.mule.weave.v2.module.reader.ResourceManager;
import org.mule.weave.v2.module.writer.ConfigurableEncoding;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.util.BinaryHelper$;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WriteFunctionValue$ {
    public static WriteFunctionValue$ MODULE$;
    private final String DATA_WEAVE_MIMETYPE;
    private final Integer maxValueLength;

    static {
        new WriteFunctionValue$();
    }

    public String DATA_WEAVE_MIMETYPE() {
        return this.DATA_WEAVE_MIMETYPE;
    }

    public Integer maxValueLength() {
        return this.maxValueLength;
    }

    private Either<String, SeekableStream> processResult(InputStream stream, String charset, DataFormat<?, ?> dataFormat, EvaluationContext parentContext) {
        Left left;
        if (dataFormat.binaryFormat()) {
            Right right;
            InputStream inputStream = stream;
            if (inputStream instanceof SeekableStream) {
                SeekableStream seekableStream = (SeekableStream)((Object)inputStream);
                right = package$.MODULE$.Right().apply((Object)seekableStream);
            } else {
                right = package$.MODULE$.Right().apply((Object)SeekableStream$.MODULE$.apply(stream, parentContext));
            }
            left = right;
        } else {
            try (BufferedSource source = Source$.MODULE$.fromInputStream(stream, charset);){
                left = package$.MODULE$.Left().apply((Object)source.mkString());
            }
        }
        return left;
    }

    public Either<String, SeekableStream> write(Value<?> value, Writer writer, DataFormat<?, ?> dataFormat, LocationCapable location, EvaluationContext parentContext) {
        LoggingService x$1 = parentContext.serviceManager().loggingService();
        WeaveServicesProvider x$2 = parentContext.serviceManager().serviceProvider();
        ResourceManager x$3 = ServiceManager$.MODULE$.$lessinit$greater$default$2();
        ServiceManager manager = new ServiceManager(x$1, x$3, x$2);
        int x$4 = parentContext.asyncExecutionCount();
        ServiceManager x$5 = manager;
        DefaultEvaluationContext childExecutionContext = new DefaultEvaluationContext(x$5, x$4);
        return this.org$mule$weave$v2$core$functions$WriteFunctionValue$$writeUsingContext(value, writer, dataFormat, location, childExecutionContext, parentContext);
    }

    public LocationCapable write$default$4() {
        return UnknownLocationCapable$.MODULE$;
    }

    public Either<String, SeekableStream> org$mule$weave$v2$core$functions$WriteFunctionValue$$writeUsingContext(Value<?> value, Writer writer, DataFormat<?, ?> dataFormat, LocationCapable location, DefaultEvaluationContext childExecutionContext, EvaluationContext parentContext) {
        Left left;
        Charset charset;
        try {
            writer.startDocument(location);
            writer.writeValue(value, childExecutionContext);
            writer.endDocument(location);
        }
        finally {
            childExecutionContext.close();
        }
        Settings settings = writer.settings();
        if (settings instanceof ConfigurableEncoding) {
            ConfigurableEncoding configurableEncoding = (ConfigurableEncoding)settings;
            charset = configurableEncoding.charset(childExecutionContext);
        } else {
            charset = (Charset)dataFormat.defaultCharset().getOrElse((Function0 & Serializable & scala.Serializable)() -> childExecutionContext.serviceManager().charsetProviderService().defaultCharset());
        }
        Charset charset2 = charset;
        Object object = writer.result();
        if (object instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object;
            left = package$.MODULE$.Right().apply((Object)SeekableStream$.MODULE$.apply(byteArrayOutputStream.toByteArray(), parentContext));
        } else if (object instanceof AutoPersistedOutputStream) {
            AutoPersistedOutputStream autoPersistedOutputStream = (AutoPersistedOutputStream)object;
            left = this.processResult((InputStream)((Object)autoPersistedOutputStream.toInputStream(parentContext)), charset2.name(), dataFormat, parentContext);
        } else if (object instanceof SeekableStream) {
            SeekableStream seekableStream = (SeekableStream)object;
            left = this.processResult((InputStream)((Object)seekableStream), charset2.name(), dataFormat, parentContext);
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            left = this.processResult(inputStream, charset2.name(), dataFormat, parentContext);
        } else if (object instanceof Object) {
            Object object2 = object;
            left = package$.MODULE$.Left().apply((Object)String.valueOf(object2));
        } else if (object == null) {
            left = package$.MODULE$.Left().apply((Object)"null");
        } else {
            throw new MatchError(object);
        }
        Left result = left;
        return result;
    }

    public String toDwString(Value<?> value, int maxLength, EvaluationContext ctx) {
        return StringHelper$.MODULE$.abbreviate(this.toDwString(value, this.toDwString$default$2(), ctx), maxLength);
    }

    public String toDwString(Value<?> value, boolean ignoreSchema, EvaluationContext ctx) {
        String string;
        try {
            String string2;
            Option<DataFormat<?, ?>> maybeFormat;
            Option<DataFormat<?, ?>> option = maybeFormat = DataFormatManager$.MODULE$.byContentType("application/dw", ctx);
            if (None$.MODULE$.equals(option)) {
                string2 = String.valueOf(value.evaluate(ctx));
            } else if (option instanceof Some) {
                String string3;
                Either<String, SeekableStream> result;
                Some some = (Some)option;
                DataFormat dataFormat = (DataFormat)some.value();
                Writer writer = dataFormat.writer((Option<Object>)None$.MODULE$, dataFormat.writer$default$2(), ctx);
                writer.setOption((Location)UnknownLocation$.MODULE$, "indent", "", ctx);
                writer.setOption((Location)UnknownLocation$.MODULE$, "ignoreSchema", BoxesRunTime.boxToBoolean((boolean)ignoreSchema), ctx);
                Either<String, SeekableStream> either = result = this.write(value, writer, dataFormat, value, ctx);
                if (either instanceof Left) {
                    String str;
                    Left left = (Left)either;
                    string3 = str = (String)left.value();
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    SeekableStream bytes = (SeekableStream)right.value();
                    string3 = BinaryHelper$.MODULE$.toBase64String(bytes, ctx.serviceManager().memoryService());
                } else {
                    throw new MatchError(either);
                }
                string2 = string3;
            } else {
                throw new MatchError(option);
            }
            string = string2;
        }
        catch (Exception e) {
            Type type = value.valueType(ctx);
            String string4 = type.isInstanceOf(ArrayType$.MODULE$, ctx) ? "[...]" : (type.isInstanceOf(ObjectType$.MODULE$, ctx) ? "{...}" : String.valueOf(value));
            String result = string4;
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String className = value != null ? value.getClass().getSimpleName() : "Null";
            String message = new StringBuilder(91).append("Unexpected error while evaluating `WriteFunctionValue.toDwString( ").append(value.valueType(ctx)).append(" {class:'").append(className).append("'} )`. Reason :\n").append(writer.toString()).toString();
            ctx.serviceManager().loggingService().logError(message);
            string = result;
        }
        return string;
    }

    public boolean toDwString$default$2() {
        return false;
    }

    private WriteFunctionValue$() {
        MODULE$ = this;
        this.DATA_WEAVE_MIMETYPE = "application/dw";
        this.maxValueLength = RuntimeConfigProperties$.MODULE$.MAX_STRING_VALUE_MESSAGE_LENGTH();
    }
}

