/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToPrimitiveNode.class)
public final class JSToPrimitiveNodeGen
extends JSToPrimitiveNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
    @Node.Child
    private JSObjectData jSObject_cache;
    @Node.Child
    private TruffleJavaObject0Data truffleJavaObject0_cache;
    @Node.Child
    private ImportValueNode truffleJavaObject1_toJSType_;

    private JSToPrimitiveNodeGen(JSToPrimitiveNode.Hint hint) {
        super(hint);
    }

    @Override
    @ExplodeLoop
    public Object execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.doInt(arg0Value_);
        }
        if ((state_0 & 2) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_ = (SafeInteger)arg0Value;
            return this.doSafeInteger(arg0Value_);
        }
        if ((state_0 & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return this.doLong(arg0Value_);
        }
        if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x3C000) >>> 14, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state_0 & 0x3C000) >>> 14, arg0Value);
            return this.doDouble(arg0Value_);
        }
        if ((state_0 & 0x10) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_);
        }
        if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitCharSequence((state_0 & 0x1C0000) >>> 18, arg0Value)) {
            CharSequence arg0Value_ = JSTypesGen.asImplicitCharSequence((state_0 & 0x1C0000) >>> 18, arg0Value);
            return this.doString(arg0Value_);
        }
        if ((state_0 & 0x40) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol(arg0Value_);
        }
        if ((state_0 & 0x80) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_);
        }
        if ((state_0 & 0x300) != 0) {
            if ((state_0 & 0x100) != 0 && JSGuards.isJSNull(arg0Value)) {
                return this.doNull(arg0Value);
            }
            if ((state_0 & 0x200) != 0 && JSGuards.isUndefined(arg0Value)) {
                return this.doUndefined(arg0Value);
            }
        }
        if ((state_0 & 0x400) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            JSObjectData s11_ = this.jSObject_cache;
            if (s11_ != null && JSGuards.isJSObject(arg0Value_)) {
                return this.doJSObject(arg0Value_, s11_.getToPrimitive_, s11_.isPrimitive_, s11_.ordinaryToPrimitive_, s11_.exoticToPrimProfile_, s11_.callExoticToPrim_);
            }
        }
        if ((state_0 & 0x3800) != 0) {
            if ((state_0 & 0x800) != 0) {
                TruffleJavaObject0Data s12_ = this.truffleJavaObject0_cache;
                while (s12_ != null) {
                    if (s12_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value)) {
                        TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                        TruffleLanguage.ContextReference<JSRealm> contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                        return this.doTruffleJavaObject(arg0Value, s12_.interop_, contextRef__, s12_.toJSType_);
                    }
                    s12_ = s12_.next_;
                }
            }
            if ((state_0 & 0x1000) != 0 && JSGuards.isForeignObject(arg0Value)) {
                return this.truffleJavaObject1Boundary(state_0, arg0Value);
            }
            if ((state_0 & 0x2000) != 0 && JSToPrimitiveNodeGen.fallbackGuard_(state_0, arg0Value)) {
                return this.doFallback(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object truffleJavaObject1Boundary(int state_0, Object arg0Value) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__1;
            InteropLibrary truffleJavaObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
            TruffleLanguage.ContextReference<JSRealm> truffleJavaObject1_contextRef__ = javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
            Object object = this.doTruffleJavaObject(arg0Value, truffleJavaObject1_interop__, truffleJavaObject1_contextRef__, this.truffleJavaObject1_toJSType_);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            DynamicObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.doInt(arg0Value_2);
                return n;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                SafeInteger safeInteger = this.doSafeInteger(arg0Value_3);
                return safeInteger;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_4 = (Long)arg0Value;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                Long l = this.doLong(arg0Value_4);
                return l;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 |= doubleCast0 << 14;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                Double d = this.doDouble(arg0Value_5);
                return d;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_6 = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                Boolean arg0Value_5 = this.doBoolean(arg0Value_6);
                return arg0Value_5;
            }
            int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arg0Value);
            if (charSequenceCast0 != 0) {
                CharSequence arg0Value_7 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arg0Value);
                state_0 |= charSequenceCast0 << 18;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                CharSequence charSequence = this.doString(arg0Value_7);
                return charSequence;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_8 = (Symbol)arg0Value;
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                Symbol arg0Value_7 = this.doSymbol(arg0Value_8);
                return arg0Value_7;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_9 = (BigInt)arg0Value;
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                BigInt arg0Value_7 = this.doBigInt(arg0Value_9);
                return arg0Value_7;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_9 = this.doNull(arg0Value);
                return arg0Value_9;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_9 = this.doUndefined(arg0Value);
                return arg0Value_9;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
                JSObjectData s11_ = (JSObjectData)super.insert((Node)new JSObjectData());
                s11_.getToPrimitive_ = s11_.insertAccessor(JSToPrimitiveNode.createGetToPrimitive(arg0Value_));
                s11_.isPrimitive_ = s11_.insertAccessor(IsPrimitiveNode.create());
                s11_.ordinaryToPrimitive_ = s11_.insertAccessor(this.createOrdinaryToPrimitive(arg0Value_));
                s11_.exoticToPrimProfile_ = ConditionProfile.createBinaryProfile();
                s11_.callExoticToPrim_ = s11_.insertAccessor(JSFunctionCallNode.createCall());
                this.jSObject_cache = s11_;
                this.state_0_ = state_0 |= 0x400;
                lock.unlock();
                hasLock = false;
                Object object = this.doJSObject(arg0Value_, s11_.getToPrimitive_, s11_.isPrimitive_, s11_.ordinaryToPrimitive_, s11_.exoticToPrimProfile_, s11_.callExoticToPrim_);
                return object;
            }
            TruffleLanguage.ContextReference contextRef__ = null;
            if (exclude == 0) {
                TruffleLanguage.ContextReference javaScriptLanguageContextReference__3;
                int count12_ = 0;
                TruffleJavaObject0Data s12_ = this.truffleJavaObject0_cache;
                if ((state_0 & 0x800) != 0) {
                    while (s12_ != null) {
                        if (s12_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value)) {
                            TruffleLanguage.ContextReference javaScriptLanguageContextReference__2 = this.javaScriptLanguageContextReference_;
                            if (javaScriptLanguageContextReference__2 == null) {
                                this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__2 = super.lookupContextReference(JavaScriptLanguage.class);
                            }
                            contextRef__ = javaScriptLanguageContextReference__2;
                            break;
                        }
                        s12_ = s12_.next_;
                        ++count12_;
                    }
                }
                if (s12_ == null && JSGuards.isForeignObject(arg0Value) && count12_ < 5) {
                    s12_ = (TruffleJavaObject0Data)super.insert((Node)new TruffleJavaObject0Data(this.truffleJavaObject0_cache));
                    s12_.interop_ = (InteropLibrary)s12_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    javaScriptLanguageContextReference__3 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__3 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__3 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    contextRef__ = javaScriptLanguageContextReference__3;
                    s12_.toJSType_ = s12_.insertAccessor(ImportValueNode.create());
                    this.truffleJavaObject0_cache = s12_;
                    this.state_0_ = state_0 |= 0x800;
                }
                if (s12_ != null) {
                    lock.unlock();
                    hasLock = false;
                    javaScriptLanguageContextReference__3 = this.doTruffleJavaObject(arg0Value, s12_.interop_, contextRef__, s12_.toJSType_);
                    return javaScriptLanguageContextReference__3;
                }
            }
            TruffleLanguage.ContextReference truffleJavaObject1_contextRef__ = null;
            InteropLibrary truffleJavaObject1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (JSGuards.isForeignObject(arg0Value)) {
                    truffleJavaObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__4 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__4 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__4 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    truffleJavaObject1_contextRef__ = javaScriptLanguageContextReference__4;
                    this.truffleJavaObject1_toJSType_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                    this.exclude_ = exclude |= 1;
                    this.truffleJavaObject0_cache = null;
                    state_0 &= 0xFFFFF7FF;
                    this.state_0_ = state_0 |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doTruffleJavaObject(arg0Value, truffleJavaObject1_interop__, (TruffleLanguage.ContextReference<JSRealm>)truffleJavaObject1_contextRef__, this.truffleJavaObject1_toJSType_);
                    return object;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            this.state_0_ = state_0 |= 0x2000;
            lock.unlock();
            hasLock = false;
            Object object = this.doFallback(arg0Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        TruffleJavaObject0Data s12_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x3FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x3FFF & (state_0 & 0x3FFF) - 1) == 0 && ((s12_ = this.truffleJavaObject0_cache) == null || s12_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[15];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state_0 & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            JSObjectData s11_ = this.jSObject_cache;
            if (s11_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s11_.getToPrimitive_, s11_.isPrimitive_, s11_.ordinaryToPrimitive_, s11_.exoticToPrimProfile_, s11_.callExoticToPrim_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doTruffleJavaObject";
        if ((state_0 & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            TruffleJavaObject0Data s12_ = this.truffleJavaObject0_cache;
            while (s12_ != null) {
                cached.add(Arrays.asList(new Node[]{s12_.interop_, s12_.toJSType_}));
                s12_ = s12_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doTruffleJavaObject";
        if ((state_0 & 0x1000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.truffleJavaObject1_toJSType_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state_0 & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state_0, Object arg0Value) {
        DynamicObject arg0Value_;
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x10) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if (JSTypesGen.isImplicitCharSequence(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x40) == 0 && arg0Value instanceof Symbol) {
            return false;
        }
        if ((state_0 & 0x80) == 0 && arg0Value instanceof BigInt) {
            return false;
        }
        if ((state_0 & 0x100) == 0 && JSGuards.isJSNull(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x200) == 0 && JSGuards.isUndefined(arg0Value)) {
            return false;
        }
        if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return false;
        }
        return (state_0 & 0x1000) != 0 || !JSGuards.isForeignObject(arg0Value);
    }

    public static JSToPrimitiveNode create(JSToPrimitiveNode.Hint hint) {
        return new JSToPrimitiveNodeGen(hint);
    }

    @GeneratedBy(value=JSToPrimitiveNode.class)
    private static final class TruffleJavaObject0Data
    extends Node {
        @Node.Child
        TruffleJavaObject0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ImportValueNode toJSType_;

        TruffleJavaObject0Data(TruffleJavaObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSToPrimitiveNode.class)
    private static final class JSObjectData
    extends Node {
        @Node.Child
        PropertyNode getToPrimitive_;
        @Node.Child
        IsPrimitiveNode isPrimitive_;
        @Node.Child
        OrdinaryToPrimitiveNode ordinaryToPrimitive_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile exoticToPrimProfile_;
        @Node.Child
        JSFunctionCallNode callExoticToPrim_;

        JSObjectData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

