/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSDateObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObjectGen;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSDateObject.class)
final class JSDateObjectGen {
    private JSDateObjectGen() {
    }

    static {
        LibraryExport.register(JSDateObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSDateObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSDateObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSDateObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSDateObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSDateObject.class)
        private static final class Uncached
        extends JSNonProxyObjectGen.InteropLibraryExports.Uncached {
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDateObject)((Object)receiver)).isDate();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDateObject)((Object)receiver)).isDate();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDateObject)((Object)receiver)).isDate();
            }

            @CompilerDirectives.TruffleBoundary
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDateObject)((Object)receiver)).asInstant();
            }

            @CompilerDirectives.TruffleBoundary
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDateObject arg0Value = (JSDateObject)((Object)arg0Value_);
                return arg0Value.asDate(this.javaScriptLanguageContextReference_);
            }

            @CompilerDirectives.TruffleBoundary
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDateObject arg0Value = (JSDateObject)((Object)arg0Value_);
                return arg0Value.asTime(this.javaScriptLanguageContextReference_);
            }

            @CompilerDirectives.TruffleBoundary
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDateObject arg0Value = (JSDateObject)((Object)arg0Value_);
                return arg0Value.asTimeZone(this.javaScriptLanguageContextReference_);
            }
        }

        @GeneratedBy(value=JSDateObject.class)
        private static final class Cached
        extends JSNonProxyObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            public boolean isDate(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSDateObject)((Object)receiver)).isDate();
            }

            public boolean isTime(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSDateObject)((Object)receiver)).isDate();
            }

            public boolean isTimeZone(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSDateObject)((Object)receiver)).isDate();
            }

            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSDateObject)((Object)receiver)).asInstant();
            }

            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSDateObject arg0Value = (JSDateObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                    TruffleLanguage.ContextReference<JSRealm> asDateNode__contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    return arg0Value.asDate(asDateNode__contextRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asDateNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LocalDate asDateNode_AndSpecialize(JSDateObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    TruffleLanguage.ContextReference asDateNode__contextRef__ = null;
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    asDateNode__contextRef__ = javaScriptLanguageContextReference__1;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    LocalDate localDate = arg0Value.asDate((TruffleLanguage.ContextReference<JSRealm>)asDateNode__contextRef__);
                    return localDate;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSDateObject arg0Value = (JSDateObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                    TruffleLanguage.ContextReference<JSRealm> asTimeNode__contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    return arg0Value.asTime(asTimeNode__contextRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private LocalTime asTimeNode_AndSpecialize(JSDateObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    TruffleLanguage.ContextReference asTimeNode__contextRef__ = null;
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    asTimeNode__contextRef__ = javaScriptLanguageContextReference__1;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    LocalTime localTime = arg0Value.asTime((TruffleLanguage.ContextReference<JSRealm>)asTimeNode__contextRef__);
                    return localTime;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSDateObject arg0Value = (JSDateObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__;
                    TruffleLanguage.ContextReference<JSRealm> asTimeZoneNode__contextRef__ = javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    return arg0Value.asTimeZone(asTimeZoneNode__contextRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.asTimeZoneNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ZoneId asTimeZoneNode_AndSpecialize(JSDateObject arg0Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    TruffleLanguage.ContextReference asTimeZoneNode__contextRef__ = null;
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    asTimeZoneNode__contextRef__ = javaScriptLanguageContextReference__1;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    ZoneId zoneId = arg0Value.asTimeZone((TruffleLanguage.ContextReference<JSRealm>)asTimeZoneNode__contextRef__);
                    return zoneId;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }
        }
    }
}

