/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.reactivestreams.Publisher;

public class PipelineProcessingStrategyReactiveProcessorBuilder {
    private final String artifactId;
    private final String artifactType;
    private final ReactiveProcessor pipeline;
    private final ClassLoader executionClassloader;
    private ScheduledExecutorService scheduler;
    private ProfilingService profilingService;

    private PipelineProcessingStrategyReactiveProcessorBuilder(ReactiveProcessor pipeline, ClassLoader executionClassloader, String artifactId, String artifactType) {
        this.pipeline = pipeline;
        this.executionClassloader = executionClassloader;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    public static PipelineProcessingStrategyReactiveProcessorBuilder pipelineProcessingStrategyReactiveProcessorFrom(ReactiveProcessor pipeline, ClassLoader executionClassloader, String artifactId, String artifactType) {
        return new PipelineProcessingStrategyReactiveProcessorBuilder(pipeline, executionClassloader, artifactId, artifactType);
    }

    public PipelineProcessingStrategyReactiveProcessorBuilder withScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public PipelineProcessingStrategyReactiveProcessorBuilder withProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
        return this;
    }

    public ReactiveProcessor build() {
        return publisher -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)publisher)).build();
    }

    private <T extends Publisher> ReactorPublisherBuilder<T> baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder<T> publisher) {
        ComponentLocation location = ProfilingUtils.getLocation(this.pipeline);
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> psSchedulingFlowExecutionDataProducer = this.dataProducerFromProfilingService((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION);
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> startingFlowExecutionDataproducer = this.dataProducerFromProfilingService((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION);
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> flowExecutedDataProducer = this.dataProducerFromProfilingService((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.FLOW_EXECUTED);
        return publisher.profileEvent(location, psSchedulingFlowExecutionDataProducer, this.artifactId, this.artifactType).publishOn(Optional.ofNullable(this.scheduler)).profileEvent(location, startingFlowExecutionDataproducer, this.artifactId, this.artifactType).doOnSubscribe(subscription -> Thread.currentThread().setContextClassLoader(this.executionClassloader)).transform(this.pipeline).profileEvent(location, flowExecutedDataProducer, this.artifactId, this.artifactType);
    }

    private Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> dataProducerFromProfilingService(ProfilingEventType<ProcessingStrategyProfilingEventContext> profilingEventType) {
        if (this.profilingService == null) {
            return Optional.empty();
        }
        return Optional.of(this.profilingService.getProfilingDataProducer(profilingEventType));
    }
}

