/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.profiling.context.ComponentProcessingStrategyProfilingEventContext;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public interface ReactorPublisherBuilder<T extends Publisher> {
    public static ReactorPublisherBuilder<Mono<CoreEvent>> buildMono(CoreEvent event) {
        return new MonoBuilder(Mono.just((Object)event));
    }

    public static ReactorPublisherBuilder<Flux<CoreEvent>> buildFlux(Publisher<CoreEvent> publisher) {
        return new FluxBuilder(Flux.from(publisher));
    }

    public ReactorPublisherBuilder<T> doOnNext(Consumer<CoreEvent> var1);

    public ReactorPublisherBuilder<T> publishOn(Optional<ScheduledExecutorService> var1);

    public ReactorPublisherBuilder<T> transform(ReactiveProcessor var1);

    public ReactorPublisherBuilder<T> subscriberContext(Function<Context, Context> var1);

    public ReactorPublisherBuilder<T> doOnSubscribe(Consumer<? super Subscription> var1);

    public ReactorPublisherBuilder<T> profileEvent(ComponentLocation var1, Optional<? extends ProfilingDataProducer> var2, String var3, String var4);

    public T build();

    public static void doProfileEvent(ComponentLocation location, String artifactId, String artifactType, ProfilingDataProducer dp, CoreEvent e) {
        dp.triggerProfilingEvent((ProfilingEventContext)new ComponentProcessingStrategyProfilingEventContext(e, location, Thread.currentThread().getName(), artifactId, artifactType, System.currentTimeMillis()));
    }

    public static class FluxBuilder
    implements ReactorPublisherBuilder<Flux<CoreEvent>> {
        Flux<CoreEvent> flux;

        private FluxBuilder(Flux<CoreEvent> flux) {
            this.flux = flux;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> doOnNext(Consumer<CoreEvent> onNext) {
            this.flux = this.flux.doOnNext(onNext);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> publishOn(Optional<ScheduledExecutorService> scheduler) {
            this.flux = scheduler.map(sch -> this.flux.publishOn(Schedulers.fromExecutorService((ExecutorService)sch))).orElse(this.flux);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> transform(ReactiveProcessor processor) {
            this.flux = this.flux.transform((Function)processor);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> subscriberContext(Function<Context, Context> function) {
            this.flux = this.flux.subscriberContext(function);
            return this;
        }

        @Override
        public Flux<CoreEvent> build() {
            return this.flux;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
            this.flux = this.flux.doOnSubscribe(onSubscribe);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> profileEvent(ComponentLocation location, Optional<? extends ProfilingDataProducer> dataProducer, String artifactId, String artifactType) {
            this.flux = dataProducer.map(dp -> this.flux.doOnNext(e -> ReactorPublisherBuilder.doProfileEvent(location, artifactId, artifactType, dp, e))).orElse(this.flux);
            return this;
        }
    }

    public static class MonoBuilder
    implements ReactorPublisherBuilder<Mono<CoreEvent>> {
        Mono<CoreEvent> mono;

        private MonoBuilder(Mono<CoreEvent> mono) {
            this.mono = mono;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> doOnNext(Consumer<CoreEvent> onNext) {
            this.mono = this.mono.doOnNext(onNext);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> publishOn(Optional<ScheduledExecutorService> scheduler) {
            this.mono = scheduler.map(sch -> this.mono.publishOn(Schedulers.fromExecutorService((ExecutorService)sch))).orElse(this.mono);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> transform(ReactiveProcessor processor) {
            this.mono = this.mono.transform((Function)processor);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> subscriberContext(Function<Context, Context> function) {
            this.mono = this.mono.subscriberContext(function);
            return this;
        }

        @Override
        public Mono<CoreEvent> build() {
            return this.mono;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
            this.mono = this.mono.doOnSubscribe(onSubscribe);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> profileEvent(ComponentLocation location, Optional<? extends ProfilingDataProducer> dataProducer, String artifactId, String artifactType) {
            this.mono = dataProducer.map(dp -> this.mono.doOnNext(e -> ReactorPublisherBuilder.doProfileEvent(location, artifactId, artifactType, dp, e))).orElse(this.mono);
            return this;
        }
    }
}

