/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ProcessingStrategyProfilingEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerComponentProcessingStrategyDataConsumer
implements ProfilingDataConsumer<ProcessingStrategyProfilingEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerComponentProcessingStrategyDataConsumer.class);
    public static final String PROFILING_EVENT_TIMESTAMP_KEY = "profilingEventTimestamp";
    public static final String PROCESSING_THREAD_KEY = "processingThread";
    public static final String ARTIFACT_ID_KEY = "artifactId";
    public static final String ARTIFACT_TYPE_KEY = "artifactType";
    public static final String RUNTIME_CORE_EVENT_CORRELATION_ID = "runtimeCoreEventCorrelationId";
    public static final String PROFILING_EVENT_TYPE = "profilingEventType";
    public static final String LOCATION = "location";
    private final Gson gson = new Gson();

    public void onProfilingEvent(ProfilingEventType<ProcessingStrategyProfilingEventContext> profilingEventType, ProcessingStrategyProfilingEventContext profilingEventContext) {
        Logger logger = this.getDataConsumerLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.gson.toJson(this.getInfoMap(profilingEventType, profilingEventContext)));
        }
    }

    private Map<String, String> getInfoMap(ProfilingEventType<ProcessingStrategyProfilingEventContext> profilingEventType, ProcessingStrategyProfilingEventContext profilingEventContext) {
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put(PROFILING_EVENT_TYPE, profilingEventType.getProfilingEventTypeNamespace() + ":" + profilingEventType.getProfilingEventTypeIdentifier());
        eventMap.put(PROFILING_EVENT_TIMESTAMP_KEY, Long.toString(profilingEventContext.getTriggerTimestamp()));
        eventMap.put(PROCESSING_THREAD_KEY, profilingEventContext.getThreadName());
        eventMap.put(ARTIFACT_ID_KEY, profilingEventContext.getArtifactId());
        eventMap.put(ARTIFACT_TYPE_KEY, profilingEventContext.getArtifactType());
        eventMap.put(RUNTIME_CORE_EVENT_CORRELATION_ID, profilingEventContext.getCorrelationId());
        profilingEventContext.getLocation().map(loc -> eventMap.put(LOCATION, loc.getLocation()));
        return eventMap;
    }

    public Set<ProfilingEventType<ProcessingStrategyProfilingEventContext>> getProfilingEventTypes() {
        return ImmutableSet.of((Object)RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, (Object)RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION, (Object)RuntimeProfilingEventTypes.OPERATION_EXECUTED, (Object)RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, (Object)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, (Object)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, (Object[])new ProfilingEventType[]{RuntimeProfilingEventTypes.FLOW_EXECUTED});
    }

    public Predicate<ProcessingStrategyProfilingEventContext> getEventContextFilter() {
        return processingStrategyProfilingEventContext -> true;
    }

    protected Logger getDataConsumerLogger() {
        return LOGGER;
    }
}

