/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collection;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.RegistryLifecycleManager;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistry
implements Registry {
    private String id;
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    private final RegistryLifecycleManager lifecycleManager;

    protected AbstractRegistry(String id, MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor) {
        if (id == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("RegistryID"));
        }
        this.id = id;
        this.muleContext = muleContext;
        this.lifecycleManager = (RegistryLifecycleManager)this.createLifecycleManager(lifecycleInterceptor);
    }

    public final synchronized void dispose() {
        if (this.lifecycleManager.getState().isStarted()) {
            try {
                this.getLifecycleManager().fireLifecycle("stop");
            }
            catch (LifecycleException e) {
                this.logger.error("Failed to shut down registry cleanly: " + this.getRegistryId(), (Throwable)e);
            }
        }
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
        }
        catch (LifecycleException e) {
            this.logger.error("Failed to shut down registry cleanly: " + this.getRegistryId(), (Throwable)e);
        }
        try {
            this.doDispose();
        }
        catch (Exception e) {
            this.logger.error("Failed to cleanly dispose: " + e.getMessage(), (Throwable)e);
        }
    }

    protected LifecycleManager createLifecycleManager(LifecycleInterceptor lifecycleInterceptor) {
        return new RegistryLifecycleManager(this.getRegistryId(), this, this.muleContext, lifecycleInterceptor);
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    public final void initialise() throws InitialisationException {
        if (this.id == null) {
            this.logger.warn("No unique id has been set on this registry");
            this.id = UUID.getUUID();
        }
        try {
            this.doInitialise();
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        try {
            this.fireLifecycle("initialise");
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            if (e.getComponent() instanceof Initialisable) {
                throw new InitialisationException((Throwable)e, (Initialisable)e.getComponent());
            }
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public synchronized void fireLifecycle(String phase) throws LifecycleException {
        if ("dispose".equals(phase) && this.lifecycleManager.getState().isStarted()) {
            this.getLifecycleManager().fireLifecycle("stop");
        }
        if ("stop".equals(phase) && !this.lifecycleManager.getState().isStarted() && !this.hasStartFailed()) {
            return;
        }
        this.getLifecycleManager().fireLifecycle(phase);
    }

    private boolean hasStartFailed() {
        return this.lifecycleManager.hasLastExecutedPhaseFailed() && this.lifecycleManager.getLastPhaseExecuted().equals("start");
    }

    @Override
    public <T> T get(String key) {
        return this.lookupObject(key);
    }

    @Override
    public final Object unregisterObject(String key) throws RegistrationException {
        Object object;
        block2: {
            object = this.doUnregisterObject(key);
            try {
                this.getLifecycleManager().applyPhase(object, this.getLifecycleManager().getCurrentPhase(), "dispose");
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn(String.format("Could not apply shutdown lifecycle to object '%s' after being unregistered.", key), (Throwable)e);
            }
        }
        return object;
    }

    @Override
    @Deprecated
    public final Object unregisterObject(String key, Object metadata) throws RegistrationException {
        return this.unregisterObject(key);
    }

    protected abstract Object doUnregisterObject(String var1) throws RegistrationException;

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        Collection<T> objects = this.lookupObjects(type);
        if (objects.size() == 1) {
            return objects.iterator().next();
        }
        if (objects.size() > 1) {
            throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)"More than one object of type %s registered but only one expected. Objects found are: %s", (Object[])new Object[]{type, objects.toString()}));
        }
        return null;
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.lookupObjects(type);
    }

    @Override
    public final String getRegistryId() {
        return this.id;
    }
}

