/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.FeatureContext;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.config.FeatureFlaggingServiceBuilder;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.registry.AbstractRegistry;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.LifecycleStateInjectorProcessor;
import org.mule.runtime.core.internal.registry.MuleContextProcessor;
import org.mule.runtime.core.internal.registry.RegistryProcessor;
import org.mule.runtime.core.internal.registry.map.RegistryMap;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.endpoint.LegacyImmutableEndpoint;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.registry.InjectProcessor;
import org.mule.runtime.core.privileged.registry.ObjectProcessor;
import org.mule.runtime.core.privileged.registry.PreInitProcessor;
import org.mule.runtime.core.privileged.registry.RegistrationException;

@Deprecated
public abstract class TransientRegistry
extends AbstractRegistry {
    private final RegistryMap registryMap;

    public TransientRegistry(String id, MuleContext muleContext, LifecycleInterceptor lifecycleInterceptor) {
        super(id, muleContext, lifecycleInterceptor);
        this.registryMap = new RegistryMap(this.logger);
        this.putDefaultEntriesIntoRegistry();
    }

    private void putDefaultEntriesIntoRegistry() {
        HashMap<String, Object> defaultEntries = new HashMap<String, Object>();
        if (this.muleContext != null) {
            defaultEntries.put("_muleContext", this.muleContext);
            defaultEntries.put("_muleRegistry", new DefaultRegistry(this.muleContext));
            defaultEntries.put("_muleContextProcessor", new MuleContextProcessor(this.muleContext));
            defaultEntries.put("_registryProcessor", new RegistryProcessor(this.muleContext));
            defaultEntries.put(ErrorTypeRepository.class.getName(), this.muleContext.getErrorTypeRepository());
            defaultEntries.put(ErrorTypeLocator.class.getName(), ((PrivilegedMuleContext)this.muleContext).getErrorTypeLocator());
            defaultEntries.put("_muleNotificationHandler", ((PrivilegedMuleContext)this.muleContext).getNotificationManager());
            FeatureFlaggingRegistry ffRegistry = FeatureFlaggingRegistry.getInstance();
            FeatureFlaggingService featureFlaggingService = new FeatureFlaggingServiceBuilder().withContext(this.muleContext).withContext(new FeatureContext(this.muleContext.getConfiguration().getMinMuleVersion().orElse(null), this.muleContext.getId())).withMuleContextFlags(ffRegistry.getFeatureConfigurations()).withFeatureContextFlags(ffRegistry.getFeatureFlagConfigurations()).build();
            defaultEntries.put("core.featureFlaggingService", featureFlaggingService);
        }
        defaultEntries.put("_muleLifecycleStateInjectorProcessor", new LifecycleStateInjectorProcessor(this.getLifecycleManager().getState()));
        defaultEntries.put("_muleLifecycleManager", this.getLifecycleManager());
        this.registryMap.putAll(defaultEntries);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.applyProcessors(this.lookupObjects(Transformer.class), null);
        this.applyProcessors(this.lookupObjects(LegacyImmutableEndpoint.class), null);
        this.applyProcessors(this.lookupObjects(Object.class), null);
    }

    @Override
    protected void doDispose() {
        this.disposeLostObjects();
        this.registryMap.clear();
    }

    private void disposeLostObjects() {
        for (Object obj : this.registryMap.getLostObjects()) {
            try {
                ((Disposable)obj).dispose();
            }
            catch (Exception e) {
                this.logger.warn("Can not dispose object. " + ExceptionUtils.getMessage((Throwable)e));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Can not dispose object. " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    protected Map<String, Object> applyProcessors(Map<String, Object> objects) {
        if (objects == null || !this.isInitialised()) {
            return null;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            Collection<ObjectProcessor> processors = this.lookupObjects(ObjectProcessor.class);
            for (ObjectProcessor processor : processors) {
                Object result = processor.process(entry.getValue());
                if (result == null) continue;
                results.put(entry.getKey(), result);
            }
        }
        return results;
    }

    @Override
    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        if (objects == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            this.registerObject(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            this.registryMap.lockForReading();
            for (Map.Entry<String, Object> entry : this.registryMap.entrySet()) {
                Class<?> clazz = entry.getValue().getClass();
                if (!type.isAssignableFrom(clazz)) continue;
                results.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.registryMap.unlockForReading();
        }
        return results;
    }

    @Override
    public <T> T lookupObject(String key) {
        return this.doGet(key);
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        return super.lookupObject(type);
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> returntype) {
        return this.registryMap.select((Predicate)new InstanceofPredicate(returntype));
    }

    @Override
    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.lookupObjects(type);
    }

    @Override
    public boolean isSingleton(String key) {
        return true;
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        return object;
    }

    protected Object applyProcessors(Object object, Object metadata) {
        Object theObject = object;
        if (!this.hasFlag(metadata, 2)) {
            Collection<InjectProcessor> injectProcessors = this.lookupObjects(InjectProcessor.class);
            for (InjectProcessor injectProcessor : injectProcessors) {
                theObject = injectProcessor.process(theObject);
            }
        }
        if (!this.hasFlag(metadata, 4)) {
            Collection<PreInitProcessor> processors = this.lookupObjects(PreInitProcessor.class);
            for (PreInitProcessor preInitProcessor : processors) {
                theObject = preInitProcessor.process(theObject);
                if (theObject != null) continue;
                return null;
            }
        }
        return theObject;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, Object.class);
    }

    @Override
    public void registerObject(String key, Object object, Object metadata) throws RegistrationException {
        this.checkDisposed();
        if (StringUtils.isBlank(key)) {
            throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)"Attempt to register object with no key"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("registering key/object %s/%s", key, object));
        }
        this.logger.debug("applying processors");
        object = this.applyProcessors(object, metadata);
        if (object == null) {
            return;
        }
        this.doRegisterObject(key, object, metadata);
    }

    protected <T> T doGet(String key) {
        return this.registryMap.get(key);
    }

    protected void doRegisterObject(String key, Object object, Object metadata) throws RegistrationException {
        this.doPut(key, object);
        try {
            if (!this.hasFlag(metadata, 1)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("applying lifecycle to object: " + object);
                }
                this.getLifecycleManager().applyCompletedPhases(object);
            }
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    protected void doPut(String key, Object object) {
        this.registryMap.putAndLogWarningIfDuplicate(key, object);
    }

    protected void checkDisposed() throws RegistrationException {
        if (this.getLifecycleManager().isPhaseComplete("dispose")) {
            throw new RegistrationException(I18nMessageFactory.createStaticMessage((String)"Cannot register objects on the registry as the context is disposed"));
        }
    }

    protected boolean hasFlag(Object metaData, int flag) {
        return metaData != null && metaData instanceof Integer && ((Integer)metaData & flag) != 0;
    }

    @Override
    protected Object doUnregisterObject(String key) throws RegistrationException {
        return this.registryMap.remove(key);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

