/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.writer;

import java.io.OutputStream;
import java.io.Serializable;
import org.mule.weave.v2.exception.WriterExecutionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.BufferedCharSequence;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.ArrayValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.csv.CSVDataFormat;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettingsHelper;
import org.mule.weave.v2.module.csv.reader.parser.CSVWriterSettings;
import org.mule.weave.v2.module.csv.writer.CSVWriter$;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\f\u0019\u0001\u001dB\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ty\u0001\u0011)\u0019!C\u0001{!Aa\t\u0001B\u0001B\u0003%a\b\u0003\u0005H\u0001\t\u0005\t\u0015a\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011!I\u0002\u0001#b\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0011\u000b\u0007I\u0011A.\t\u000b}\u0003A\u0011\t1\t\u000b\u0011\u0004A\u0011K3\t\u000bq\u0004A\u0011A?\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002\u0016\u0002!\t%a%\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\u001e9\u0011q\u0017\r\t\u0002\u0005efAB\f\u0019\u0011\u0003\tY\f\u0003\u0004O)\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u007f#B\u0011AAa\u0005%\u00195KV,sSR,'O\u0003\u0002\u001a5\u00051qO]5uKJT!a\u0007\u000f\u0002\u0007\r\u001chO\u0003\u0002\u001e=\u00051Qn\u001c3vY\u0016T!a\b\u0011\u0002\u0005Y\u0014$BA\u0011#\u0003\u00159X-\u0019<f\u0015\t\u0019C%\u0001\u0003nk2,'\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Ej\u0011\u0001\r\u0006\u00033qI!A\r\u0019\u0003\r]\u0013\u0018\u000e^3s\u0003\ty7\u000f\u0005\u00026u5\taG\u0003\u00028q\u0005\u0011\u0011n\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdG\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0005tKR$\u0018N\\4t+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u0003\u0019\u0001\u0018M]:fe*\u00111IG\u0001\u0007e\u0016\fG-\u001a:\n\u0005\u0015\u0003%!E\"T-^\u0013\u0018\u000e^3s'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0004GRD\bCA%M\u001b\u0005Q%BA&\u001f\u0003\u0015iw\u000eZ3m\u0013\ti%JA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDc\u0001)U+R\u0011\u0011k\u0015\t\u0003%\u0002i\u0011\u0001\u0007\u0005\u0006\u000f\u0016\u0001\u001d\u0001\u0013\u0005\u0006g\u0015\u0001\r\u0001\u000e\u0005\u0006y\u0015\u0001\rAP\u000b\u0002/B\u0011q\u0006W\u0005\u00033B\u0012\u0001CQ;gM\u0016\u0014X\rZ%P/JLG/\u001a:\u0002\u0013\r\u001ch/R:dCB,W#\u0001/\u0011\u0005}j\u0016B\u00010A\u0005E\u00195KV*fiRLgnZ:IK2\u0004XM]\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0003\u0005\u0004\"!\u000b2\n\u0005\rT#aA!os\u0006aAm\\,sSR,g+\u00197vKR\u0011am\u001b\u000b\u0003O*\u0004\"!\u000b5\n\u0005%T#\u0001B+oSRDQaR\u0005A\u0004!CQ\u0001\\\u0005A\u00025\fQA^1mk\u0016\u0004$A\u001c<\u0011\u0007=\u0014H/D\u0001q\u0015\t\t(*\u0001\u0004wC2,Xm]\u0005\u0003gB\u0014QAV1mk\u0016\u0004\"!\u001e<\r\u0001\u0011Iqo[A\u0001\u0002\u0003\u0015\t\u0001\u001f\u0002\u0004?\u0012\n\u0014CA=b!\tI#0\u0003\u0002|U\t9aj\u001c;iS:<\u0017aC<sSR,\u0007*Z1eKJ$2A`A\u0001)\t9w\u0010C\u0003H\u0015\u0001\u000f\u0001\n\u0003\u0004m\u0015\u0001\u0007\u00111\u0001\u0019\u0005\u0003\u000b\tI\u0001\u0005\u0003pe\u0006\u001d\u0001cA;\u0002\n\u0011Y\u00111BA\u0001\u0003\u0003\u0005\tQ!\u0001y\u0005\ryFEM\u0001\toJLG/Z\"T-R!\u0011\u0011CA\u000b)\r9\u00171\u0003\u0005\u0006\u000f.\u0001\u001d\u0001\u0013\u0005\b\u0003/Y\u0001\u0019AA\r\u0003!IG/\u001a:bi>\u0014\bCBA\u000e\u0003W\t\tD\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rb%\u0001\u0004=e>|GOP\u0005\u0002W%\u0019\u0011\u0011\u0006\u0016\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005!IE/\u001a:bi>\u0014(bAA\u0015UA\"\u00111GA\u001c!\u0011y'/!\u000e\u0011\u0007U\f9\u0004B\u0006\u0002:\u0005U\u0011\u0011!A\u0001\u0006\u0003A(aA0%g\u0005QqO]5uK\u0016sGO]=\u0015\t\u0005}\u00121\t\u000b\u0004O\u0006\u0005\u0003\"B$\r\u0001\bA\u0005B\u00027\r\u0001\u0004\t)\u0005\r\u0003\u0002H\u0005-\u0003\u0003B8s\u0003\u0013\u00022!^A&\t-\ti%a\u0011\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#S'\u0001\txe&$Xm\u0015;sS:<g+\u00197vKR)q-a\u0015\u0002f!1A.\u0004a\u0001\u0003+\u0002B!a\u0016\u0002`9!\u0011\u0011LA.!\r\tyBK\u0005\u0004\u0003;R\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0005\r$AB*ue&twMC\u0002\u0002^)Bq!a\u001a\u000e\u0001\u0004\tI'A\u0006rk>$XMV1mk\u0016\u001c\bcA\u0015\u0002l%\u0019\u0011Q\u000e\u0016\u0003\u000f\t{w\u000e\\3b]\u0006YqO]5uKJ+7m\u001c:e)\u0011\t\u0019(a\u001e\u0015\u0007\u001d\f)\bC\u0003H\u001d\u0001\u000f\u0001\nC\u0004\u0002\u00189\u0001\r!!\u001f\u0011\r\u0005m\u00111FA>!\u0011\ti(a!\u000e\u0005\u0005}$bAAA\u0015\u0006I1\u000f\u001e:vGR,(/Z\u0005\u0005\u0003\u000b\u000byH\u0001\u0007LKf4\u0016\r\\;f!\u0006L'/A\u0005tKB\f'/\u0019;peV\u0011\u00111\u0012\t\u0004S\u00055\u0015bAAHU\t!1\t[1s\u0003\u0015\u0019Gn\\:f)\u00059\u0017!\u00024mkND\u0017A\u00033bi\u00064uN]7biV\u0011\u00111\u0014\t\u0006S\u0005u\u0015\u0011U\u0005\u0004\u0003?S#AB(qi&|g\u000e\r\u0004\u0002$\u00065\u00161\u0017\t\t\u0003K\u000b9+a+\u000226\tA$C\u0002\u0002*r\u0011!\u0002R1uC\u001a{'/\\1u!\r)\u0018Q\u0016\u0003\u000b\u0003_\u0013\u0012\u0011!A\u0001\u0006\u0003A(aA0%mA\u0019Q/a-\u0005\u0015\u0005U&#!A\u0001\u0002\u000b\u0005\u0001PA\u0002`I]\n\u0011bQ*W/JLG/\u001a:\u0011\u0005I#2C\u0001\u000b))\t\tI,A\u0003baBd\u0017\u0010\u0006\u0004\u0002D\u0006\u001d\u0017\u0011\u001b\u000b\u0004#\u0006\u0015\u0007\"B$\u0017\u0001\bA\u0005bBAe-\u0001\u0007\u00111Z\u0001\u0003iB\u00042aLAg\u0013\r\ty\r\r\u0002\u000f)\u0006\u0014x-\u001a;Qe>4\u0018\u000eZ3s\u0011\u0015ad\u00031\u0001?\u0001")
public class CSVWriter
implements Writer {
    private BufferedIOWriter writer;
    private CSVSettingsHelper csvEscape;
    private final OutputStream os;
    private final CSVWriterSettings settings;
    private final EvaluationContext ctx;
    private volatile byte bitmap$0;

    public static CSVWriter apply(TargetProvider targetProvider, CSVWriterSettings cSVWriterSettings, EvaluationContext evaluationContext) {
        return CSVWriter$.MODULE$.apply(targetProvider, cSVWriterSettings, evaluationContext);
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value, (EvaluationContext)ctx);
    }

    public CSVWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, this.settings().charset(this.ctx), this.settings().bufferSize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.ctx = null;
        return this.writer;
    }

    public BufferedIOWriter writer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private CSVSettingsHelper csvEscape$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.csvEscape = new CSVSettingsHelper(this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.csvEscape;
    }

    public CSVSettingsHelper csvEscape() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.csvEscape$lzycompute() : this.csvEscape;
    }

    public Object result() {
        return this.os;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Value<?> value2 = value;
        if (value.valueType(ctx).isInstanceOf((Type)ObjectType$.MODULE$, ctx)) {
            this.doWriteValue((Value<?>)ArrayValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Value[]{value2}))), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (value.valueType(ctx).isInstanceOf((Type)ArrayType$.MODULE$, ctx)) {
            this.writeCSV(((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator(), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new WriterExecutionException(value.location(), this.getName(), new StringBuilder(73).append("CSV Structure should be either an `Array<Object>` or an `Object` but got ").append(value.valueType(ctx)).toString());
        }
    }

    public void writeHeader(Value<?> value, EvaluationContext ctx) {
        ObjectSeq evaluate = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        BooleanRef first = BooleanRef.create((boolean)true);
        evaluate.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvv -> {
            CSVWriter.$anonfun$writeHeader$1(this, ctx, first, kvv);
            return BoxedUnit.UNIT;
        });
        this.writer().write(this.settings().lineSeparator());
    }

    public void writeCSV(Iterator<Value<?>> iterator, EvaluationContext ctx) {
        boolean first = true;
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (this.settings().header() && first) {
                value = value.materialize(ctx);
                this.writeHeader(value, ctx);
            }
            this.writeRecord((Iterator<KeyValuePair>)((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx), ctx);
            first = false;
        }
    }

    public void writeEntry(Value<?> value, EvaluationContext ctx) {
        block4: {
            boolean quoteValues;
            Option<Object> quote = this.settings().quote();
            boolean bl = quoteValues = this.settings().quoteValues() && quote.isDefined();
            if (quoteValues) {
                this.writer().write((int)BoxesRunTime.unboxToChar((Object)quote.get()));
            }
            if (!value.valueType(ctx).isInstanceOf((Type)NullType$.MODULE$, ctx)) {
                CharSequence stringValue = (CharSequence)StringType$.MODULE$.withSchema(value.valueType(ctx).schema(ctx), ctx).coerce(value, ctx).evaluate(ctx);
                CharSequence charSequence = stringValue;
                if (charSequence instanceof BufferedCharSequence) {
                    BufferedCharSequence bufferedCharSequence = (BufferedCharSequence)charSequence;
                    bufferedCharSequence.foreach((Function1 & Serializable & scala.Serializable)chars -> {
                        this.writeStringValue(chars, quoteValues);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.writeStringValue(((Object)stringValue).toString(), quoteValues);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (!quoteValues) break block4;
            this.writer().write((int)BoxesRunTime.unboxToChar((Object)quote.get()));
        }
    }

    private void writeStringValue(String value, boolean quoteValues) {
        if (quoteValues) {
            this.writer().write(this.csvEscape().escapeQuotedString(value));
        } else {
            this.writer().write(this.csvEscape().escapeUnquotedString(value));
        }
    }

    public void writeRecord(Iterator<KeyValuePair> iterator, EvaluationContext ctx) {
        int index = 0;
        while (iterator.hasNext()) {
            KeyValuePair kvp = (KeyValuePair)iterator.next();
            if (index > 0) {
                this.writer().write((int)this.separator());
            }
            this.writeEntry(kvp._2(), ctx);
            ++index;
        }
        this.writer().write(this.settings().lineSeparator());
    }

    public char separator() {
        return this.settings().separator();
    }

    public void close() {
        this.writer().close();
    }

    public void flush() {
        this.writer().flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new CSVDataFormat());
    }

    public static final /* synthetic */ void $anonfun$writeHeader$1(CSVWriter $this, EvaluationContext ctx$1, BooleanRef first$1, KeyValuePair kvv) {
        String name = ((QualifiedName)kvv._1().evaluate(ctx$1)).name();
        if (!first$1.elem) {
            $this.writer().write((int)$this.separator());
        }
        if ($this.settings().quoteHeader()) {
            $this.writer().write(new StringBuilder(2).append("\"").append(name).append("\"").toString());
        } else {
            $this.writer().write(name);
        }
        first$1.elem = false;
    }

    public CSVWriter(OutputStream os, CSVWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

