/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataProvider;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.util.TemplateParser;
import org.mule.runtime.extension.api.data.sample.ComponentSampleDataProvider;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.values.ComponentValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.ExtensionResolvingContext;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataProviderMediator;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.module.extension.internal.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtensionComponent<T extends ComponentModel>
extends AbstractComponent
implements MuleContextAware,
MetadataKeyProvider,
MetadataProvider<T>,
ComponentValueProvider,
ComponentSampleDataProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionComponent.class);
    private final TemplateParser expressionParser = TemplateParser.createMuleStyleParser();
    private final ExtensionModel extensionModel;
    private final AtomicReference<ConfigurationProvider> configurationProvider = new AtomicReference();
    private final MetadataMediator<T> metadataMediator;
    private final ClassTypeLoader typeLoader;
    private final LazyValue<Boolean> requiresConfig = new LazyValue(this::computeRequiresConfig);
    protected final ExtensionManager extensionManager;
    protected final ClassLoader classLoader;
    protected final T componentModel;
    protected CursorProviderFactory cursorProviderFactory;
    private ValueProviderMediator<T> valueProviderMediator;
    private SampleDataProviderMediator sampleDataProviderMediator;
    protected MuleContext muleContext;
    @Inject
    protected ExpressionManager expressionManager;
    @Inject
    protected ConnectionManagerAdapter connectionManager;
    @Inject
    protected StreamingManager streamingManager;
    @Inject
    protected TransactionFactoryLocator transactionFactoryLocator;
    @Inject
    protected MuleMetadataService metadataService;
    protected ConfigurationComponentLocator componentLocator;
    @Inject
    protected ReflectionCache reflectionCache;
    @Inject
    protected ErrorTypeRepository errorTypeRepository;
    private MetadataCacheIdGeneratorFactory<ComponentAst> cacheIdGeneratorFactory;
    protected MetadataCacheIdGenerator<ComponentAst> cacheIdGenerator;
    private Function<CoreEvent, Optional<ConfigurationInstance>> configurationResolver;

    protected ExtensionComponent(ExtensionModel extensionModel, T componentModel, ConfigurationProvider configurationProvider, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager) {
        this.extensionModel = extensionModel;
        this.classLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        this.componentModel = componentModel;
        this.configurationProvider.set(configurationProvider);
        this.extensionManager = extensionManager;
        this.cursorProviderFactory = cursorProviderFactory;
        this.metadataMediator = new MetadataMediator<T>(componentModel);
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.classLoader);
    }

    public final void initialise() throws InitialisationException {
        if (this.cursorProviderFactory == null) {
            this.cursorProviderFactory = this.componentModel.getModelProperty(PagedOperationModelProperty.class).map(p -> this.streamingManager.forObjects().getDefaultCursorProviderFactory()).orElseGet(() -> this.streamingManager.forBytes().getDefaultCursorProviderFactory());
        }
        ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            this.validateConfigurationProviderIsNotExpression();
            this.initConfigurationResolver();
            this.findConfigurationProvider().ifPresent(this::validateOperationConfiguration);
            this.doInitialise();
            return null;
        }, InitialisationException.class, e -> {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        });
        this.setCacheIdGenerator();
    }

    private void initConfigurationResolver() {
        if (!((Boolean)this.requiresConfig.get()).booleanValue()) {
            this.configurationResolver = event -> Optional.empty();
            return;
        }
        this.findConfigurationProvider().ifPresent(this.configurationProvider::set);
        Optional<ConfigurationInstance> staticConfiguration = this.getStaticConfiguration();
        if (staticConfiguration.isPresent()) {
            this.configurationResolver = event -> staticConfiguration;
            return;
        }
        this.configurationResolver = this.isConfigurationSpecified() ? event -> {
            ConfigurationInstance instance = this.configurationProvider.get().get((Event)event);
            if (instance == null) {
                throw new IllegalModelDefinitionException(String.format("Root component '%s' contains a reference to config '%s' but it doesn't exists", this.getLocation().getRootContainerName(), this.configurationProvider));
            }
            return Optional.of(instance);
        } : event -> this.extensionManager.getConfiguration(this.extensionModel, this.componentModel, event);
    }

    public final void start() throws MuleException {
        ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            this.doStart();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        });
    }

    public final void stop() throws MuleException {
        ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            this.doStop();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        });
    }

    public final void dispose() {
        try {
            ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
                this.doDispose();
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Exception found trying to dispose component", (Throwable)e);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    protected abstract void doDispose();

    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.metadataMediator.getMetadataKeys((MetadataContext)context, this.getParameterValueResolver(), this.reflectionCache)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKey partialKey) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.metadataMediator.getMetadataKeys((MetadataContext)context, partialKey, this.reflectionCache)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onKeys()});
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.metadataMediator.getMetadata((MetadataContext)context, this.getParameterValueResolver(), this.reflectionCache)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.metadataMediator.getMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    public MetadataResult<InputMetadataDescriptor> getInputMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.metadataMediator.getInputMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    public MetadataResult<OutputMetadataDescriptor> getOutputMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.metadataMediator.getOutputMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Object)e)).onComponent()});
        }
    }

    public Set<Value> getValues(String parameterName) throws ValueResolvingException {
        try {
            return this.runWithResolvingContext(context -> (Set)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.getValueProviderMediator().getValues(parameterName, this.getParameterValueResolver(), (Supplier<Object>)((CheckedSupplier)() -> context.getConnection().orElse(null)), (Supplier<Object>)((CheckedSupplier)() -> context.getConfig().orElse(null)), context.getConnectionProvider().orElse(null))));
        }
        catch (MuleRuntimeException e) {
            Throwable rootException = ExceptionHelper.getRootException((Throwable)e);
            if (rootException instanceof ValueResolvingException) {
                throw (ValueResolvingException)rootException;
            }
            throw new ValueResolvingException("An unknown error occurred trying to resolve values. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
        catch (Exception e) {
            throw new ValueResolvingException("An unknown error occurred trying to resolve values. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
    }

    public Set<Value> getValues(String parameterName, String targetSelector) throws ValueResolvingException {
        try {
            return this.runWithResolvingContext(context -> (Set)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.getValueProviderMediator().getValues(parameterName, this.getParameterValueResolver(), targetSelector, (Supplier<Object>)((CheckedSupplier)() -> context.getConnection().orElse(null)), (Supplier<Object>)((CheckedSupplier)() -> context.getConfig().orElse(null)), context.getConnectionProvider().orElse(null))));
        }
        catch (MuleRuntimeException e) {
            Throwable rootException = ExceptionHelper.getRootException((Throwable)e);
            if (rootException instanceof ValueResolvingException) {
                throw (ValueResolvingException)rootException;
            }
            throw new ValueResolvingException("An unknown error occurred trying to resolve values. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
        catch (Exception e) {
            throw new ValueResolvingException("An unknown error occurred trying to resolve values. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
    }

    public Message getSampleData() throws SampleDataException {
        try {
            return this.runWithResolvingContext(context -> (Message)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.getSampleDataProviderMediator().getSampleData(this.getParameterValueResolver(), (Supplier<Object>)((CheckedSupplier)() -> context.getConnection().orElse(null)), (Supplier<Object>)((CheckedSupplier)() -> context.getConfig().orElse(null)), (Supplier<ConnectionProvider>)((CheckedSupplier)() -> context.getConnectionProvider().orElse(null)))));
        }
        catch (MuleRuntimeException e) {
            Throwable rootException = ExceptionHelper.getRootException((Throwable)e);
            if (rootException instanceof SampleDataException) {
                throw (SampleDataException)rootException;
            }
            throw new SampleDataException("An unknown error occurred trying to obtain Sample Data. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
        catch (Exception e) {
            throw new SampleDataException("An unknown error occurred trying to obtain Sample Data. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
    }

    protected <R> MetadataResult<R> runWithMetadataContext(Function<MetadataContext, MetadataResult<R>> contextConsumer) throws MetadataResolvingException, ConnectionException {
        MetadataContext context = null;
        try {
            MetadataCacheId cacheId = this.getMetadataCacheId();
            MetadataCache metadataCache = this.metadataService.getMetadataCache(cacheId.getValue());
            context = (MetadataContext)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.getMetadataContext(metadataCache));
            MetadataResult<R> result = contextConsumer.apply(context);
            if (result.isSuccess()) {
                this.metadataService.saveCache(cacheId.getValue(), metadataCache);
            }
            MetadataResult<R> metadataResult = result;
            return metadataResult;
        }
        catch (MuleRuntimeException e) {
            try {
                throw e.getCause();
            }
            catch (ConnectionException | MetadataResolvingException cause) {
                throw cause;
            }
            catch (Throwable t) {
                throw e;
            }
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    private MetadataCacheId getMetadataCacheId() {
        return this.cacheIdGenerator.getIdForGlobalMetadata((Object)((ComponentAst)this.getAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG))).map(id -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(id.getParts().toString());
            }
            return id;
        }).orElseThrow(() -> new IllegalStateException(String.format("Missing information to obtain the MetadataCache for the component '%s'. Expected to have the ComponentAst information in the '%s' annotation but none was found.", this.getLocation().toString(), ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runWithResolvingContext(Function<ExtensionResolvingContext, R> function) {
        R result;
        ExtensionResolvingContext context = this.getResolvingContext();
        try {
            result = function.apply(context);
        }
        finally {
            context.dispose();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataContext getMetadataContext(MetadataCache cache) throws MetadataResolvingException {
        CoreEvent fakeEvent = null;
        try {
            ConfigurationProvider configurationProvider;
            fakeEvent = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
            Optional<ConfigurationInstance> configuration = this.getConfiguration(fakeEvent);
            if (configuration.isPresent() && (configurationProvider = this.findConfigurationProvider().orElseThrow(() -> new MetadataResolvingException("Failed to create the required configuration for Metadata retrieval", FailureCode.INVALID_CONFIGURATION))) instanceof DynamicConfigurationProvider) {
                throw new MetadataResolvingException("Configuration used for Metadata fetch cannot be dynamic", FailureCode.INVALID_CONFIGURATION);
            }
            DefaultMetadataContext defaultMetadataContext = new DefaultMetadataContext(() -> configuration, (ConnectionManager)this.connectionManager, cache, this.typeLoader);
            return defaultMetadataContext;
        }
        finally {
            if (fakeEvent != null) {
                ((BaseEventContext)fakeEvent.getContext()).success();
            }
        }
    }

    private ExtensionResolvingContext getResolvingContext() {
        return new ExtensionResolvingContext(() -> {
            CoreEvent fakeEvent = null;
            try {
                fakeEvent = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
                Optional<ConfigurationInstance> optional = this.getConfiguration(fakeEvent);
                return optional;
            }
            finally {
                if (fakeEvent != null) {
                    ((BaseEventContext)fakeEvent.getContext()).success();
                }
            }
        }, (ConnectionManager)this.connectionManager);
    }

    protected Optional<ConfigurationInstance> getConfiguration(CoreEvent event) {
        return this.configurationResolver.apply(event);
    }

    protected boolean requiresConfig() {
        return (Boolean)this.requiresConfig.get();
    }

    protected ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider.get();
    }

    protected boolean usesDynamicConfiguration() {
        return this.isConfigurationSpecified() && this.configurationProvider.get().isDynamic();
    }

    protected Optional<ConfigurationInstance> getStaticConfiguration() {
        if (!this.requiresConfig()) {
            return Optional.empty();
        }
        if (this.configurationResolver == null || this.usesDynamicConfiguration()) {
            return Optional.empty();
        }
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
            Optional<ConfigurationInstance> optional = this.configurationResolver.apply(initialiserEvent);
            return optional;
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    protected CursorProviderFactory getCursorProviderFactory() {
        return this.cursorProviderFactory;
    }

    private Optional<ConfigurationProvider> findConfigurationProvider() {
        if (this.isConfigurationSpecified()) {
            return Optional.of(this.configurationProvider.get());
        }
        return this.extensionManager.getConfigurationProvider(this.extensionModel, this.componentModel);
    }

    private boolean isConfigurationSpecified() {
        return this.configurationProvider.get() != null;
    }

    private boolean computeRequiresConfig() {
        return ExtensionModelUtils.requiresConfig((ExtensionModel)this.extensionModel, this.componentModel);
    }

    private void validateConfigurationProviderIsNotExpression() throws InitialisationException {
        if (this.isConfigurationSpecified() && this.expressionParser.isContainsTemplate(this.configurationProvider.get().getName())) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("Root component '%s' defines component '%s' which specifies the expression '%s' as a config-ref. Expressions are not allowed as config references", this.getLocation().getRootContainerName(), NameUtils.hyphenize((String)this.componentModel.getName()), this.configurationProvider)), (Initialisable)this);
        }
    }

    private void setCacheIdGenerator() {
        DslResolvingContext context = DslResolvingContext.getDefault((Set)this.extensionManager.getExtensions());
        ComponentLocator configLocator = location -> this.componentLocator.find(location).map(component -> (ComponentAst)component.getAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG));
        this.cacheIdGenerator = this.cacheIdGeneratorFactory.create(context, configLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueProviderMediator getValueProviderMediator() {
        if (this.valueProviderMediator == null) {
            ExtensionComponent extensionComponent = this;
            synchronized (extensionComponent) {
                if (this.valueProviderMediator == null) {
                    this.valueProviderMediator = new ValueProviderMediator<T>(this.componentModel, () -> this.muleContext, () -> this.reflectionCache);
                }
            }
        }
        return this.valueProviderMediator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SampleDataProviderMediator getSampleDataProviderMediator() {
        if (this.sampleDataProviderMediator == null) {
            ExtensionComponent extensionComponent = this;
            synchronized (extensionComponent) {
                if (this.sampleDataProviderMediator == null) {
                    this.sampleDataProviderMediator = new SampleDataProviderMediator(this.extensionModel, (ComponentModel)this.componentModel, (Component)this, this.muleContext, this.reflectionCache, this.streamingManager);
                }
            }
        }
        return this.sampleDataProviderMediator;
    }

    protected abstract ParameterValueResolver getParameterValueResolver();

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    public List<ValueProviderModel> getModels(String providerName) {
        return ValueProviderUtils.getValueProviderModels(this.componentModel.getAllParameterModels());
    }

    @Inject
    public void setCacheIdGeneratorFactory(MetadataCacheIdGeneratorFactory<ComponentAst> cacheIdGeneratorFactory) {
        this.cacheIdGeneratorFactory = cacheIdGeneratorFactory;
    }

    @Inject
    public void setComponentLocator(ConfigurationComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }
}

