/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.internal.exception.SuppressedMuleException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ModuleExceptionHandler {
    private final Set<ErrorModel> allowedErrorTypes;
    private final String extensionNamespace;
    private final LoadingCache<ErrorTypeDefinition, Function<Throwable, ErrorType>> errorTypeCache;

    public ModuleExceptionHandler(ComponentModel componentModel, ExtensionModel extensionModel, ErrorTypeRepository typeRepository) {
        this.allowedErrorTypes = componentModel.getErrorModels();
        this.extensionNamespace = MuleExtensionUtils.getExtensionsNamespace(extensionModel);
        this.errorTypeCache = Caffeine.newBuilder().build(errorDefinition -> {
            Optional errorTypeLookedUp = typeRepository.lookupErrorType(ComponentIdentifier.builder().namespace(this.extensionNamespace).name(errorDefinition.getType()).build());
            if (errorTypeLookedUp.isPresent()) {
                ErrorType errorType = (ErrorType)errorTypeLookedUp.get();
                if (this.isAllowedError(errorType)) {
                    return exception -> errorType;
                }
                return exception -> {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The component '%s' from the connector '%s' attempted to throw '%s', but only %s errors are allowed.", (Object[])new Object[]{componentModel.getName(), extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition, this.allowedErrorTypes}), exception.getCause());
                };
            }
            return exception -> {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The component '%s' from the connector '%s' attempted to throw '%s', but it was not registered in the Error Repository", (Object[])new Object[]{componentModel.getName(), extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition}), this.getExceptionCause((Throwable)exception));
            };
        });
    }

    public Throwable processException(Throwable throwable) {
        if (throwable instanceof ModuleException) {
            return this.handleTypedException(throwable, ((ModuleException)throwable).getType());
        }
        return throwable;
    }

    private Throwable handleTypedException(Throwable exception, ErrorTypeDefinition errorDefinition) {
        return new TypedException(this.getExceptionCause(exception), (ErrorType)((Function)this.errorTypeCache.get((Object)errorDefinition)).apply(exception));
    }

    private boolean isAllowedError(ErrorType errorType) {
        return this.allowedErrorTypes.stream().anyMatch(errorModel -> {
            boolean isAllowed = false;
            for (ErrorType currentError = errorType; currentError != null && !isAllowed; currentError = currentError.getParentErrorType()) {
                isAllowed = errorModel.getType().equals(currentError.getIdentifier()) && errorModel.getNamespace().equals(currentError.getNamespace());
            }
            return isAllowed;
        });
    }

    private Throwable getExceptionCause(Throwable throwable) {
        if (throwable.getClass().equals(ModuleException.class)) {
            return throwable.getCause() != null ? SuppressedMuleException.suppressIfPresent((Throwable)throwable.getCause(), MessagingException.class) : new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)throwable.getMessage()));
        }
        return SuppressedMuleException.suppressIfPresent((Throwable)throwable, MessagingException.class);
    }
}

