/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import java.util.Map;
import java.util.ServiceConfigurationError;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionBuilderHelper;
import org.mule.runtime.config.internal.dsl.spring.CommonBeanBaseDefinitionCreator;
import org.mule.runtime.config.internal.dsl.spring.CreateComponentBeanDefinitionRequest;
import org.mule.runtime.config.internal.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.internal.dsl.spring.PropertyComponentUtils;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.privileged.dsl.BeanDefinitionPostProcessor;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.privileged.processor.SecurityFilterMessageProcessor;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;

class CommonComponentBeanDefinitionCreator
extends CommonBeanBaseDefinitionCreator<CreateComponentBeanDefinitionRequest> {
    private final BeanDefinitionPostProcessor beanDefinitionPostProcessor = this.resolvePostProcessor();

    public CommonComponentBeanDefinitionCreator(ObjectFactoryClassRepository objectFactoryClassRepository) {
        super(objectFactoryClassRepository);
    }

    private BeanDefinitionPostProcessor resolvePostProcessor() {
        for (ClassLoader classLoader : MuleApplicationClassLoader.resolveContextArtifactPluginClassLoaders()) {
            try {
                BeanDefinitionPostProcessor foundProvider = (BeanDefinitionPostProcessor)new SpiServiceRegistry().lookupProvider(BeanDefinitionPostProcessor.class, classLoader);
                if (foundProvider == null) continue;
                return foundProvider;
            }
            catch (Exception | ServiceConfigurationError throwable) {
            }
        }
        return (componentModel, helper) -> {};
    }

    @Override
    protected void processComponentDefinitionModel(Map<ComponentAst, SpringComponentModel> springComponentModels, CreateComponentBeanDefinitionRequest request, ComponentBuildingDefinition componentBuildingDefinition, BeanDefinitionBuilder beanDefinitionBuilder) {
        AbstractBeanDefinition wrappedBeanDefinition;
        AbstractBeanDefinition originalBeanDefinition;
        ComponentAst component = request.getComponent();
        this.processObjectConstructionParameters(springComponentModels, component, component, request, new BeanDefinitionBuilderHelper(beanDefinitionBuilder));
        CommonComponentBeanDefinitionCreator.processMuleProperties(component, beanDefinitionBuilder, this.beanDefinitionPostProcessor);
        if (componentBuildingDefinition.isPrototype()) {
            beanDefinitionBuilder.setScope("prototype");
        }
        if ((originalBeanDefinition = beanDefinitionBuilder.getBeanDefinition()) != (wrappedBeanDefinition = this.adaptBeanDefinitionForSecurityFilter(originalBeanDefinition))) {
            request.getSpringComponentModel().setType(wrappedBeanDefinition.getBeanClass());
        }
        request.getSpringComponentModel().setBeanDefinition((BeanDefinition)wrappedBeanDefinition);
    }

    static void processMuleProperties(ComponentAst component, BeanDefinitionBuilder beanDefinitionBuilder, BeanDefinitionPostProcessor beanDefinitionPostProcessor) {
        if (component == null) {
            return;
        }
        if (beanDefinitionPostProcessor != null && beanDefinitionPostProcessor.getGenericPropertiesCustomProcessingIdentifiers().contains(component.getIdentifier())) {
            return;
        }
        component.directChildrenStream().filter(innerComponent -> {
            ComponentIdentifier identifier = innerComponent.getIdentifier();
            return identifier.equals(ApplicationModel.MULE_PROPERTY_IDENTIFIER) || identifier.equals(ApplicationModel.MULE_PROPERTIES_IDENTIFIER);
        }).forEach(propertyComponentModel -> {
            Pair<String, Object> propertyValue = PropertyComponentUtils.getPropertyValueFromPropertyComponent(propertyComponentModel);
            beanDefinitionBuilder.addPropertyValue((String)propertyValue.getFirst(), propertyValue.getSecond());
        });
    }

    private AbstractBeanDefinition adaptBeanDefinitionForSecurityFilter(AbstractBeanDefinition originalBeanDefinition) {
        if (CommonComponentBeanDefinitionCreator.areMatchingTypes(SecurityFilter.class, this.resolveBeanClass(originalBeanDefinition))) {
            return BeanDefinitionBuilder.rootBeanDefinition(SecurityFilterMessageProcessor.class).addConstructorArgValue((Object)originalBeanDefinition).getBeanDefinition();
        }
        return originalBeanDefinition;
    }

    private Class resolveBeanClass(AbstractBeanDefinition originalBeanDefinition) {
        Class beanClass;
        if (originalBeanDefinition instanceof RootBeanDefinition) {
            beanClass = ((RootBeanDefinition)originalBeanDefinition).getBeanClass();
        } else {
            try {
                beanClass = originalBeanDefinition.getBeanClass();
            }
            catch (IllegalStateException e) {
                try {
                    beanClass = ClassUtils.getClass((String)originalBeanDefinition.getBeanClassName());
                }
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return beanClass;
    }

    public static boolean areMatchingTypes(Class<?> superType, Class<?> childType) {
        return superType.isAssignableFrom(childType);
    }
}

