/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingUtils;
import org.mule.runtime.module.extension.internal.config.dsl.construct.RouteComponentParser;
import org.mule.runtime.module.extension.internal.config.dsl.object.DefaultObjectParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.FixedTypeParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.ObjectParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.object.SchedulingStrategyParsingDelegate;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.AnonymousInlineParameterGroupParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.ObjectTypeParameterParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TypedInlineParameterGroupParser;
import org.mule.runtime.module.extension.internal.config.dsl.resolver.ValueResolverFactory;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.NativeQueryParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ProcessorChainValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public abstract class ExtensionDefinitionParser {
    protected static final String CURSOR_PROVIDER_FACTORY_FIELD_NAME = "cursorProviderFactory";
    protected static final String PARAMETERS_FIELD_NAME = "parameters";
    protected final List<ObjectParsingDelegate> objectParsingDelegates = ImmutableList.of((Object)new FixedTypeParsingDelegate(PoolingProfile.class), (Object)new FixedTypeParsingDelegate(RetryPolicyTemplate.class), (Object)new FixedTypeParsingDelegate(TlsContextFactory.class), (Object)new SchedulingStrategyParsingDelegate(), (Object)new DefaultObjectParsingDelegate());
    protected final DslSyntaxResolver dslResolver;
    private final Map<String, AttributeDefinition.Builder> parameters = new HashMap<String, AttributeDefinition.Builder>();
    private final List<ComponentBuildingDefinition> parsedDefinitions = new ArrayList<ComponentBuildingDefinition>();
    protected final Map<String, String> infrastructureParameterMap = InfrastructureTypeMapping.getNameMap();
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected final ComponentBuildingDefinition.Builder definitionBuilder;
    protected final ExtensionParsingContext parsingContext;
    protected final ValueResolverFactory valueResolverFactory;

    protected ExtensionDefinitionParser(ComponentBuildingDefinition.Builder definitionBuilder, DslSyntaxResolver dslResolver, ExtensionParsingContext ctx) {
        this.definitionBuilder = definitionBuilder;
        this.dslResolver = dslResolver;
        this.parsingContext = ctx;
        this.valueResolverFactory = new ValueResolverFactory(dslResolver);
    }

    public final List<ComponentBuildingDefinition> parse() throws ConfigurationException {
        ComponentBuildingDefinition.Builder builder = this.definitionBuilder;
        builder = this.doParse(builder);
        AttributeDefinition parametersDefinition = AttributeDefinition.Builder.fromFixedValue(new HashMap()).build();
        if (!this.parameters.isEmpty()) {
            KeyAttributeDefinitionPair[] attributeDefinitions = (KeyAttributeDefinitionPair[])this.parameters.entrySet().stream().map(entry -> KeyAttributeDefinitionPair.newBuilder().withAttributeDefinition(((AttributeDefinition.Builder)entry.getValue()).build()).withKey((String)entry.getKey()).build()).toArray(KeyAttributeDefinitionPair[]::new);
            parametersDefinition = AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])attributeDefinitions).build();
        }
        builder = builder.withSetterParameterDefinition(PARAMETERS_FIELD_NAME, parametersDefinition);
        this.addDefinition(builder.build());
        return this.parsedDefinitions;
    }

    protected abstract ComponentBuildingDefinition.Builder doParse(ComponentBuildingDefinition.Builder var1) throws ConfigurationException;

    protected void parseNestedComponents(List<? extends NestableElementModel> nestedComponents) {
        nestedComponents.forEach(component -> component.accept(new NestableElementModelVisitor(){

            public void visit(NestedChainModel component) {
                ExtensionDefinitionParser.this.parseProcessorChain(component);
            }

            public void visit(NestedRouteModel component) {
                ExtensionDefinitionParser.this.parseRoute(component);
            }
        }));
    }

    protected void parseParameters(List<ParameterModel> parameters) {
        parameters.forEach(parameter -> {
            DslElementSyntax paramDsl = this.dslResolver.resolve(parameter);
            boolean isContent = ExtensionModelUtils.isContent((ParameterModel)parameter);
            parameter.getType().accept(new MetadataTypeVisitor((ParameterModel)parameter, paramDsl, isContent){
                final /* synthetic */ ParameterModel val$parameter;
                final /* synthetic */ DslElementSyntax val$paramDsl;
                final /* synthetic */ boolean val$isContent;
                {
                    this.val$parameter = parameterModel;
                    this.val$paramDsl = dslElementSyntax;
                    this.val$isContent = bl;
                }

                protected void defaultVisit(MetadataType metadataType) {
                    ExtensionDefinitionParser.this.parseAttributeParameter(this.val$parameter);
                }

                public void visitString(StringType stringType) {
                    if (this.val$paramDsl.supportsChildDeclaration()) {
                        ExtensionDefinitionParser.this.parseFromTextExpression(this.val$parameter, this.val$paramDsl, () -> {
                            Optional query = this.val$parameter.getModelProperty(QueryParameterModelProperty.class);
                            return value -> {
                                ValueResolver resolver = ExtensionDefinitionParser.this.valueResolverFactory.of(this.val$parameter.getName(), (MetadataType)stringType, value, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), this.val$parameter.getModelProperties(), ExtensionParsingUtils.acceptsReferences(this.val$parameter));
                                return query.map(p -> new NativeQueryParameterValueResolver(resolver, p.getQueryTranslator())).orElse(resolver);
                            };
                        });
                    } else {
                        this.defaultVisit((MetadataType)stringType);
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (this.parseAsContent((MetadataType)objectType)) {
                        return;
                    }
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        ExtensionDefinitionParser.this.parseMapParameters(this.val$parameter, objectType, this.val$paramDsl);
                        return;
                    }
                    if (!ExtensionDefinitionParser.this.parsingContext.isRegistered(this.val$paramDsl.getElementName(), this.val$paramDsl.getPrefix())) {
                        if (!this.val$paramDsl.supportsTopLevelDeclaration() && this.val$paramDsl.supportsChildDeclaration()) {
                            ExtensionDefinitionParser.this.parsingContext.registerObjectType(this.val$paramDsl.getElementName(), this.val$paramDsl.getPrefix(), objectType);
                        }
                        ExtensionDefinitionParser.this.parseAstParameter(this.val$parameter, this.val$paramDsl);
                    } else {
                        ExtensionDefinitionParser.this.parseObject(this.val$parameter.getName(), this.val$parameter.getName(), objectType, this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), ExtensionParsingUtils.acceptsReferences(this.val$parameter), this.val$paramDsl, this.val$parameter.getModelProperties(), this.val$parameter.getAllowedStereotypes());
                    }
                }

                public void visitAnyType(AnyType anyType) {
                    if (ExtensionDefinitionParser.this.isInjectableType((MetadataType)anyType)) {
                        if (!this.parseAsContent((MetadataType)anyType)) {
                            ExtensionDefinitionParser.this.parseAttributeParameter(this.val$parameter.getName(), this.val$parameter.getName(), this.val$parameter.getType(), this.val$parameter.getDefaultValue(), this.val$parameter.getExpressionSupport(), this.val$parameter.isRequired(), ExtensionParsingUtils.acceptsReferences(this.val$parameter), this.val$parameter.getModelProperties(), this.val$parameter.getAllowedStereotypes());
                        }
                    } else {
                        this.defaultVisit((MetadataType)anyType);
                    }
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (!this.parseAsContent((MetadataType)arrayType)) {
                        ExtensionDefinitionParser.this.parseCollectionParameter(this.val$parameter, arrayType, this.val$paramDsl);
                    }
                }

                private boolean parseAsContent(MetadataType type) {
                    if (this.val$isContent) {
                        ExtensionDefinitionParser.this.parseAstParameter(this.val$parameter, this.val$paramDsl);
                        return true;
                    }
                    return false;
                }
            });
        });
    }

    private boolean isInjectableType(MetadataType type) {
        return type instanceof ObjectType || ExtensionMetadataTypeUtils.isReferableType((MetadataType)type);
    }

    protected void parseMapParameters(ParameterModel parameter, ObjectType objectType, DslElementSyntax paramDsl) {
        this.parseMapParameters(parameter.getName(), parameter.getName(), objectType, parameter.getDefaultValue(), parameter.getExpressionSupport(), parameter.isRequired(), paramDsl, parameter.getModelProperties(), parameter.getAllowedStereotypes());
    }

    protected void parseMapParameters(String key, String name, ObjectType dictionaryType, Object defaultValue, final ExpressionSupport expressionSupport, boolean required, final DslElementSyntax paramDsl, Set<ModelProperty> modelProperties, List<StereotypeModel> allowedStereotypes) {
        this.parseAttributeParameter(key, name, (MetadataType)dictionaryType, defaultValue, expressionSupport, required, true, modelProperties, allowedStereotypes);
        Class mapType = JavaTypeUtils.getType((MetadataType)dictionaryType);
        if (ConcurrentMap.class.equals((Object)mapType)) {
            mapType = ConcurrentHashMap.class;
        } else if (Map.class.equals(mapType)) {
            mapType = LinkedHashMap.class;
        }
        final MetadataType valueType = dictionaryType.getOpenRestriction().orElse(this.typeLoader.load(Object.class));
        final Class valueClass = JavaTypeUtils.getType((MetadataType)valueType);
        final MetadataType keyType = this.typeLoader.load(String.class);
        final Class<String> keyClass = String.class;
        String mapElementName = paramDsl.getElementName();
        this.addParameter(ExtensionParsingUtils.getChildKey(key), AttributeDefinition.Builder.fromChildMapConfiguration(String.class, (Class)valueClass).withWrapperIdentifier(mapElementName).withDefaultValue(defaultValue));
        this.addDefinition(this.definitionBuilder.withIdentifier(mapElementName).withTypeDefinition(TypeDefinition.fromType(mapType)).build());
        Optional mapValueChildDsl = paramDsl.getGeneric(valueType);
        if (!mapValueChildDsl.isPresent()) {
            return;
        }
        final DslElementSyntax valueDsl = (DslElementSyntax)mapValueChildDsl.get();
        valueType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                String parameterName = paramDsl.getAttributeName();
                ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.definitionBuilder.withIdentifier(valueDsl.getElementName()).withTypeDefinition(TypeDefinition.fromMapEntryType((Class)keyClass, (Class)valueClass)).withKeyTypeConverter(value -> ExtensionDefinitionParser.this.valueResolverFactory.of(parameterName, keyType, value, null, expressionSupport, true, Collections.emptySet(), false)).withTypeConverter(value -> ExtensionDefinitionParser.this.valueResolverFactory.of(parameterName, valueType, value, null, expressionSupport, true, Collections.emptySet(), false)).build());
            }

            public void visitObject(ObjectType objectType) {
                this.defaultVisit((MetadataType)objectType);
                Optional containedElement = valueDsl.getContainedElement("value");
                if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType) || !containedElement.isPresent()) {
                    return;
                }
                DslElementSyntax valueChild = (DslElementSyntax)containedElement.get();
                if ((valueChild.supportsTopLevelDeclaration() || valueChild.supportsChildDeclaration() && !valueChild.isWrapped()) && !ExtensionDefinitionParser.this.parsingContext.isRegistered(valueChild.getElementName(), valueChild.getPrefix())) {
                    try {
                        ExtensionDefinitionParser.this.parsingContext.registerObjectType(valueChild.getElementName(), valueChild.getPrefix(), objectType);
                        new ObjectTypeParameterParser(ExtensionDefinitionParser.this.definitionBuilder, objectType, ExtensionDefinitionParser.this.getContextClassLoader(), ExtensionDefinitionParser.this.dslResolver, ExtensionDefinitionParser.this.parsingContext).parse().forEach(definition -> ExtensionDefinitionParser.this.addDefinition((ComponentBuildingDefinition)definition));
                    }
                    catch (ConfigurationException e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create parser for map complex type"), (Throwable)e);
                    }
                }
            }

            public void visitArrayType(final ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                final Optional valueListGenericDsl = valueDsl.getGeneric(arrayType.getType());
                if (valueDsl.supportsChildDeclaration() && valueListGenericDsl.isPresent()) {
                    arrayType.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                        protected void visitBasicType(MetadataType metadataType) {
                            String parameterName = paramDsl.getAttributeName();
                            ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.definitionBuilder.withIdentifier(((DslElementSyntax)valueListGenericDsl.get()).getElementName()).withTypeDefinition(TypeDefinition.fromType((Class)JavaTypeUtils.getType((MetadataType)metadataType))).withTypeConverter(value -> ExtensionDefinitionParser.this.valueResolverFactory.of(parameterName, metadataType, value, MetadataTypeUtils.getDefaultValue((MetadataType)metadataType), ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)metadataType), false, Collections.emptySet())).build());
                        }

                        protected void defaultVisit(MetadataType metadataType) {
                            ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.definitionBuilder.withIdentifier(((DslElementSyntax)valueListGenericDsl.get()).getElementName()).withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)arrayType.getType()).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)ExtensionDefinitionParser.this.getContextClassLoader()).build()).build());
                        }
                    });
                }
            }
        });
    }

    protected void parseFields(ObjectType type, DslElementSyntax typeDsl, Map<String, ParameterRole> parametersRole) {
        type.getFields().forEach(f -> this.parseField(type, typeDsl, (ObjectFieldType)f, parametersRole));
    }

    protected void parseFields(ObjectType type, DslElementSyntax typeDsl) {
        type.getFields().forEach(f -> this.parseField(type, typeDsl, (ObjectFieldType)f, Collections.emptyMap()));
    }

    private void parseField(final ObjectType type, DslElementSyntax typeDsl, final ObjectFieldType objectField, final Map<String, ParameterRole> parametersRole) {
        MetadataType fieldType = objectField.getValue();
        final String fieldName = objectField.getKey().getName().getLocalPart();
        final boolean acceptsReferences = ExtensionMetadataTypeUtils.acceptsReferences((MetadataType)objectField);
        final Object defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)fieldType).orElse(null);
        final ExpressionSupport expressionSupport = ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)objectField);
        final Optional fieldDsl = typeDsl.getContainedElement(fieldName);
        if (!fieldDsl.isPresent() && !ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)objectField)) {
            return;
        }
        Optional<String> keyName = this.getInfrastructureParameterName(fieldType);
        if (keyName.isPresent()) {
            this.parseObject(fieldName, keyName.get(), (ObjectType)fieldType, defaultValue, expressionSupport, false, acceptsReferences, (DslElementSyntax)fieldDsl.get(), Collections.emptySet(), Collections.emptyList());
            return;
        }
        final boolean isContent = ExtensionModelUtils.isContent((ParameterRole)parametersRole.getOrDefault(fieldName, ParameterRole.BEHAVIOUR));
        fieldType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                ExtensionDefinitionParser.this.parseAttributeParameter(fieldName, fieldName, metadataType, defaultValue, expressionSupport, false, Collections.emptySet(), objectField.getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElse(Collections.emptyList()));
            }

            public void visitString(StringType stringType) {
                if (((DslElementSyntax)fieldDsl.get()).supportsChildDeclaration()) {
                    String elementName = ((DslElementSyntax)fieldDsl.get()).getElementName();
                    ExtensionDefinitionParser.this.addParameter(fieldName, AttributeDefinition.Builder.fromChildConfiguration(String.class).withWrapperIdentifier(elementName));
                    ExtensionDefinitionParser.this.addDefinition(ExtensionDefinitionParser.this.definitionBuilder.withIdentifier(elementName).withTypeDefinition(TypeDefinition.fromType(String.class)).withTypeConverter(value -> ExtensionDefinitionParser.this.valueResolverFactory.of(elementName, (MetadataType)stringType, value, defaultValue, expressionSupport, false, Collections.emptySet(), acceptsReferences)).build());
                } else {
                    this.defaultVisit((MetadataType)stringType);
                }
            }

            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    if (!this.parseAsContent(isContent, (MetadataType)objectType)) {
                        ExtensionDefinitionParser.this.parseMapParameters(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, (DslElementSyntax)fieldDsl.get(), Collections.emptySet(), Collections.emptyList());
                    }
                    return;
                }
                if (ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)objectField)) {
                    ExtensionDefinitionParser.this.dslResolver.resolve((MetadataType)objectType).ifPresent(objectDsl -> objectType.getFields().forEach(field -> ExtensionDefinitionParser.this.parseField(objectType, objectDsl, field, parametersRole)));
                    return;
                }
                if (this.parseAsContent(isContent, (MetadataType)objectType)) {
                    return;
                }
                DslElementSyntax dsl = (DslElementSyntax)fieldDsl.get();
                if (!ExtensionDefinitionParser.this.parsingContext.isRegistered(dsl.getElementName(), dsl.getPrefix())) {
                    ExtensionDefinitionParser.this.parsingContext.registerObjectType(dsl.getElementName(), dsl.getPrefix(), type);
                    ExtensionDefinitionParser.this.parseObjectParameter(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, acceptsReferences, dsl, Collections.emptySet(), Collections.emptyList());
                } else {
                    ExtensionDefinitionParser.this.parseObject(fieldName, fieldName, objectType, defaultValue, expressionSupport, false, acceptsReferences, dsl, Collections.emptySet(), Collections.emptyList());
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                if (!this.parseAsContent(isContent, (MetadataType)arrayType)) {
                    ExtensionDefinitionParser.this.parseCollectionParameter(fieldName, fieldName, arrayType, defaultValue, expressionSupport, false, false, (DslElementSyntax)fieldDsl.get(), Collections.emptySet());
                }
            }

            private boolean parseAsContent(boolean isContent2, MetadataType type2) {
                if (isContent2) {
                    ExtensionDefinitionParser.this.parseAstParameter(fieldName, fieldName, type2, (DslElementSyntax)fieldDsl.get(), defaultValue, expressionSupport, false, Collections.emptySet(), objectField.getAnnotation(StereotypeTypeAnnotation.class).map(StereotypeTypeAnnotation::getAllowedStereotypes).orElse(Collections.emptyList()), isContent2);
                    return true;
                }
                return false;
            }
        });
    }

    protected void parseCollectionParameter(ParameterModel parameter, ArrayType arrayType, DslElementSyntax parameterDsl) {
        this.parseCollectionParameter(parameter.getName(), parameter.getName(), arrayType, parameter.getDefaultValue(), parameter.getExpressionSupport(), parameter.isRequired(), parameter.getDslConfiguration().allowsReferences(), parameterDsl, parameter.getModelProperties());
    }

    protected void parseCollectionParameter(String key, final String name, ArrayType arrayType, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax parameterDsl, Set<ModelProperty> modelProperties) {
        this.parseAttributeParameter(key, name, (MetadataType)arrayType, defaultValue, expressionSupport, required, acceptsReferences, modelProperties, Collections.emptyList());
        Class collectionType = ExtensionMetadataTypeUtils.getType((MetadataType)arrayType).orElse(null);
        if (Set.class.equals((Object)collectionType)) {
            collectionType = HashSet.class;
        } else if (Collection.class.equals(collectionType) || Iterable.class.equals(collectionType) || collectionType == null) {
            collectionType = List.class;
        }
        String collectionElementName = parameterDsl.getElementName();
        this.addParameter(ExtensionParsingUtils.getChildKey(key), AttributeDefinition.Builder.fromChildConfiguration(collectionType).withWrapperIdentifier(collectionElementName));
        this.addDefinition(this.definitionBuilder.withIdentifier(collectionElementName).withTypeDefinition(TypeDefinition.fromType(collectionType)).build());
        final Optional collectionItemDsl = parameterDsl.getGeneric(arrayType.getType());
        if (parameterDsl.supportsChildDeclaration() && collectionItemDsl.isPresent()) {
            final String itemIdentifier = ((DslElementSyntax)collectionItemDsl.get()).getElementName();
            final String itemNamespace = ((DslElementSyntax)collectionItemDsl.get()).getPrefix();
            arrayType.getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                private void addBasicTypeDefinition(MetadataType metadataType) {
                    ComponentBuildingDefinition.Builder itemDefinitionBuilder = ExtensionDefinitionParser.this.definitionBuilder.withIdentifier(itemIdentifier).withNamespace(itemNamespace).withTypeDefinition(TypeDefinition.fromType(ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).orElse(Object.class))).withTypeConverter(value -> ExtensionDefinitionParser.this.valueResolverFactory.of(name, metadataType, value, MetadataTypeUtils.getDefaultValue((MetadataType)metadataType).orElse(null), ExtensionMetadataTypeUtils.getExpressionSupport((MetadataType)metadataType), false, Collections.emptySet()));
                    ExtensionDefinitionParser.this.addDefinition(itemDefinitionBuilder.build());
                }

                protected void visitBasicType(MetadataType metadataType) {
                    this.addBasicTypeDefinition(metadataType);
                }

                public void visitDate(DateType dateType) {
                    this.addBasicTypeDefinition((MetadataType)dateType);
                }

                public void visitDateTime(DateTimeType dateTimeType) {
                    this.addBasicTypeDefinition((MetadataType)dateTimeType);
                }

                public void visitObject(ObjectType objectType) {
                    if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
                        return;
                    }
                    DslElementSyntax itemDsl = (DslElementSyntax)collectionItemDsl.get();
                    if ((itemDsl.supportsTopLevelDeclaration() || itemDsl.supportsChildDeclaration()) && !ExtensionDefinitionParser.this.parsingContext.isRegistered(itemDsl.getElementName(), itemDsl.getPrefix())) {
                        try {
                            ExtensionDefinitionParser.this.parsingContext.registerObjectType(itemDsl.getElementName(), itemDsl.getPrefix(), objectType);
                            new ObjectTypeParameterParser(ExtensionDefinitionParser.this.definitionBuilder, objectType, ExtensionDefinitionParser.this.getContextClassLoader(), ExtensionDefinitionParser.this.dslResolver, ExtensionDefinitionParser.this.parsingContext).parse().forEach(definition -> ExtensionDefinitionParser.this.addDefinition((ComponentBuildingDefinition)definition));
                        }
                        catch (ConfigurationException e) {
                            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not create parser for collection complex type"), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    protected ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected void parseFromTextExpression(ParameterModel parameter, DslElementSyntax dsl, Supplier<TypeConverter> typeConverter) {
        this.parseFromTextExpression(parameter.getName(), dsl, typeConverter);
    }

    protected void parseFromTextExpression(String key, DslElementSyntax paramDsl, Supplier<TypeConverter> typeConverter) {
        this.addParameter(ExtensionParsingUtils.getChildKey(key), AttributeDefinition.Builder.fromSimpleParameter((String)key, (TypeConverter)typeConverter.get()));
        this.addDefinition(this.definitionBuilder.withIdentifier(paramDsl.getElementName()).withTypeDefinition(TypeDefinition.fromType(String.class)).withTypeConverter(typeConverter.get()).build());
    }

    protected AttributeDefinition.Builder parseAttributeParameter(ParameterModel parameterModel) {
        return this.parseAttributeParameter(parameterModel.getName(), parameterModel.getName(), parameterModel.getType(), parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), !parameterModel.getAllowedStereotypes().isEmpty(), parameterModel.getModelProperties(), parameterModel.getAllowedStereotypes());
    }

    protected AttributeDefinition.Builder parseAttributeParameter(String key, String name, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, List<StereotypeModel> allowedStereotypes) {
        return this.parseAttributeParameter(key, name, type, defaultValue, expressionSupport, required, !allowedStereotypes.isEmpty(), modelProperties, allowedStereotypes);
    }

    private AttributeDefinition.Builder parseAttributeParameter(String key, String name, MetadataType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, Set<ModelProperty> modelProperties, List<StereotypeModel> allowedStereotypes) {
        TypeConverter typeConverter = value -> this.valueResolverFactory.of(name, type, value, defaultValue, expressionSupport, required, modelProperties, acceptsReferences);
        AttributeDefinition.Builder definitionBuilder = acceptsReferences && type instanceof StringType && !allowedStereotypes.isEmpty() ? AttributeDefinition.Builder.fromSoftReferenceSimpleParameter((String)name) : (acceptsReferences && expressionSupport == ExpressionSupport.NOT_SUPPORTED && type instanceof ObjectType ? AttributeDefinition.Builder.fromSimpleReferenceParameter((String)key) : (acceptsReferences && type instanceof ObjectType ? AttributeDefinition.Builder.fromSimpleReferenceParameter((String)key, (TypeConverter)typeConverter) : AttributeDefinition.Builder.fromSimpleParameter((String)name, (TypeConverter)typeConverter)));
        definitionBuilder.withDefaultValue(defaultValue);
        this.addParameter(key, definitionBuilder);
        return definitionBuilder;
    }

    protected void parseAstParameter(String key, String name, MetadataType type, DslElementSyntax dsl, Object defaultValue, ExpressionSupport expressionSupport, boolean required, Set<ModelProperty> modelProperties, List<StereotypeModel> allowedStereotypes, boolean content) {
        if (content) {
            this.parseFromTextExpression(name, dsl, () -> value -> this.valueResolverFactory.of(name, type, value, defaultValue, expressionSupport, required, modelProperties, !allowedStereotypes.isEmpty(), content));
        } else {
            this.parseObjectParameter(key, name, (ObjectType)type, defaultValue, expressionSupport, required, !allowedStereotypes.isEmpty(), dsl, modelProperties, allowedStereotypes);
        }
    }

    protected void parseAstParameter(ParameterModel parameterModel, DslElementSyntax paramDsl) {
        if (ExtensionModelUtils.isContent((ParameterModel)parameterModel)) {
            this.parseFromTextExpression(parameterModel, paramDsl, () -> value -> this.valueResolverFactory.of(parameterModel.getName(), parameterModel.getType(), value, parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), parameterModel.getModelProperties(), ExtensionParsingUtils.acceptsReferences(parameterModel), true));
        } else {
            this.parseObjectParameter(parameterModel.getName(), parameterModel.getName(), (ObjectType)parameterModel.getType(), parameterModel.getDefaultValue(), parameterModel.getExpressionSupport(), parameterModel.isRequired(), ExtensionParsingUtils.acceptsReferences(parameterModel), paramDsl, parameterModel.getModelProperties(), parameterModel.getAllowedStereotypes());
        }
    }

    protected void parseObjectParameter(String key, String name, ObjectType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax elementDsl, Set<ModelProperty> modelProperties, List<StereotypeModel> allowedStereotypes) {
        this.parseObject(key, name, type, defaultValue, expressionSupport, required, acceptsReferences, elementDsl, modelProperties, allowedStereotypes);
        String elementNamespace = elementDsl.getPrefix();
        String elementName = elementDsl.getElementName();
        if (elementDsl.supportsChildDeclaration() && !elementDsl.isWrapped() && modelProperties.stream().noneMatch(m -> m.getName().equals("infrastructureParameter"))) {
            try {
                new ObjectTypeParameterParser(this.definitionBuilder, elementName, elementNamespace, type, this.getContextClassLoader(), this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)new ConfigurationException((Throwable)e));
            }
        }
    }

    protected void parseObject(String key, String name, ObjectType type, Object defaultValue, ExpressionSupport expressionSupport, boolean required, boolean acceptsReferences, DslElementSyntax elementDsl, Set<ModelProperty> modelProperties, List<StereotypeModel> allowedStereotypes) {
        this.parseAttributeParameter(key, name, (MetadataType)type, defaultValue, expressionSupport, required, acceptsReferences, modelProperties, allowedStereotypes);
        ObjectParsingDelegate delegate = (ObjectParsingDelegate)ExtensionParsingUtils.locateParsingDelegate(this.objectParsingDelegates, type).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find a parsing delegate for type " + JavaTypeUtils.getType((MetadataType)type).getName()))));
        this.addParameter(ExtensionParsingUtils.getChildKey(key), (AttributeDefinition.Builder)delegate.parse(name, type, elementDsl));
    }

    protected void addDefinition(ComponentBuildingDefinition definition) {
        this.parsedDefinitions.add(definition);
    }

    protected void addParameter(String key, AttributeDefinition.Builder definitionBuilder) {
        if (this.parameters.put(key, definitionBuilder) != null) {
            throw new IllegalArgumentException("An AttributeDefinition builder was already defined for parameter " + key);
        }
    }

    protected List<ParameterGroupModel> getInlineGroups(ParameterizedModel model) {
        return model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).collect(Collectors.toList());
    }

    private void parseProcessorChain(NestedChainModel chainModel) {
        String processorElementName = NameUtils.hyphenize((String)chainModel.getName());
        this.addParameter(ExtensionParsingUtils.getChildKey(chainModel.getName()), AttributeDefinition.Builder.fromChildConfiguration(ProcessorChainValueResolver.class).withWrapperIdentifier(processorElementName));
        this.addDefinition(this.definitionBuilder.withIdentifier(processorElementName).withTypeDefinition(TypeDefinition.fromType(ProcessorChainValueResolver.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
    }

    private void parseRoute(NestedRouteModel routeModel) {
        DslElementSyntax routeDsl = this.dslResolver.resolve((NamedObject)routeModel);
        Class type = (Class)MuleExtensionUtils.getImplementingType((EnrichableModel)routeModel).orElseThrow(() -> new IllegalStateException("Missing route information"));
        MetadataType metadataType = this.typeLoader.load((Type)type);
        this.addParameter(ExtensionParsingUtils.getChildKey(routeModel.getName()), new DefaultObjectParsingDelegate().parse(routeModel.getName(), (ObjectType)metadataType, routeDsl));
        try {
            new RouteComponentParser(this.definitionBuilder, routeModel, metadataType, this.getContextClassLoader(), routeDsl, this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)new ConfigurationException((Throwable)e));
        }
    }

    protected void parseParameters(ParameterizedModel parameterizedModel) throws ConfigurationException {
        List<ParameterGroupModel> inlineGroups = this.getInlineGroups(parameterizedModel);
        this.parseParameters(this.getFlatParameters(inlineGroups, parameterizedModel.getAllParameterModels()));
        for (ParameterGroupModel group : inlineGroups) {
            this.parseInlineParameterGroup(group);
        }
    }

    protected void parseInlineParameterGroup(ParameterGroupModel group) throws ConfigurationException {
        ParameterGroupDescriptor descriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElse(null);
        DslElementSyntax dslElementSyntax = this.dslResolver.resolveInline(group);
        if (descriptor != null) {
            this.addParameter(ExtensionParsingUtils.getChildKey(IntrospectionUtils.getContainerName((AnnotatedElement)descriptor.getContainer())), new DefaultObjectParsingDelegate().parse("", (ObjectType)null, dslElementSyntax));
            new TypedInlineParameterGroupParser(this.definitionBuilder, group, descriptor, this.getContextClassLoader(), dslElementSyntax, this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
        } else {
            AttributeDefinition.Builder builder = AttributeDefinition.Builder.fromChildConfiguration(Map.class);
            if (dslElementSyntax.isWrapped()) {
                builder.withWrapperIdentifier(dslElementSyntax.getElementName());
            } else {
                builder.withIdentifier(dslElementSyntax.getElementName());
            }
            this.addParameter(ExtensionParsingUtils.getChildKey(group.getName()), builder);
            new AnonymousInlineParameterGroupParser(this.definitionBuilder, group, this.getContextClassLoader(), dslElementSyntax, this.dslResolver, this.parsingContext).parse().forEach(this::addDefinition);
        }
    }

    protected List<ParameterModel> getFlatParameters(List<ParameterGroupModel> inlineGroups, List<ParameterModel> parameters) {
        List inlineParameters = inlineGroups.stream().flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        return inlineParameters.isEmpty() ? parameters : parameters.stream().filter(p -> !inlineParameters.contains(p)).collect(Collectors.toList());
    }

    protected Optional<String> getInfrastructureParameterName(MetadataType fieldType) {
        return ExtensionMetadataTypeUtils.getId((MetadataType)fieldType).map(this.infrastructureParameterMap::get);
    }
}

