/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.io;

import java.nio.ByteBuffer;
import org.mule.weave.v2.io.ByteBufferPool;
import org.mule.weave.v2.io.MemoryService;
import org.mule.weave.v2.io.MemoryServiceMonitor;
import org.mule.weave.v2.io.PooledDirectMemoryService$;
import org.mule.weave.v2.model.service.SettingsService;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015)\u0004\u0001\"\u00017\u0011!a\u0004\u0001#b\u0001\n\u0013i\u0004\u0002C!\u0001\u0011\u000b\u0007I\u0011B\u001f\t\u0011\t\u0003\u0001R1A\u0005\nuBqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004I\u0001\u0001\u0006I!\u0012\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006\u0017\u0002!\t\u0005\u0014\u0005\u0006E\u0002!\te\u0019\u0005\u0006[\u0002!\tE\u001c\u0005\u0006C\u0002!\tAS\u0004\u0006kVA\tA\u001e\u0004\u0006)UA\ta\u001e\u0005\u0006kE!\t\u0001\u001f\u0005\u0006sF!\tA\u001f\u0002\u001a!>|G.\u001a3ESJ,7\r^'f[>\u0014\u0018pU3sm&\u001cWM\u0003\u0002\u0017/\u0005\u0011\u0011n\u001c\u0006\u00031e\t!A\u001e\u001a\u000b\u0005iY\u0012!B<fCZ,'B\u0001\u000f\u001e\u0003\u0011iW\u000f\\3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&K\u0007\u0002+%\u0011!&\u0006\u0002\u000e\u001b\u0016lwN]=TKJ4\u0018nY3\u0002\u0011\r\f\u0007/Y2jif\u0004\"AI\u0017\n\u00059\u001a#aA%oi\u00069Q.\u0019=TSj,\u0017\u0001\u0005;fY\u0016lW\r\u001e:z\u000b:\f'\r\\3e!\t\u0011#'\u0003\u00024G\t9!i\\8mK\u0006t\u0017A\u00073fM\u0006,H\u000e\u001e\"zi\u0016\f%O]1z\u0005V4g-\u001a:TSj,\u0017A\u0002\u001fj]&$h\bF\u00038qeR4\b\u0005\u0002)\u0001!)1&\u0002a\u0001Y!)q&\u0002a\u0001Y!)\u0001'\u0002a\u0001c!)A'\u0002a\u0001Y\u0005aA-\u001b:fGRlU-\\8ssV\ta\b\u0005\u0002)\u007f%\u0011\u0001)\u0006\u0002\u0015\u001b\u0016lwN]=TKJ4\u0018nY3N_:LGo\u001c:\u0002\u0015!,\u0017\r]'f[>\u0014\u00180\u0001\fcsR,\u0017I\u001d:bs6+Wn\u001c:z\u001b>t\u0017\u000e^8s\u0003\u0011\u0001xn\u001c7\u0016\u0003\u0015\u0003\"\u0001\u000b$\n\u0005\u001d+\"A\u0004\"zi\u0016\u0014UO\u001a4feB{w\u000e\\\u0001\u0006a>|G\u000eI\u0001\u0012I\u00164\u0017-\u001e7u\u0005V4g-\u001a:TSj,G#\u0001\u0017\u0002\u00199,wOQ=uK\u0006\u0013(/Y=\u0015\u00075\u001b\u0006\rE\u0002#\u001dBK!aT\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\t\n\u0016B\u0001*$\u0005\u0011\u0011\u0015\u0010^3\t\u000bQc\u0001\u0019A+\u0002\u0005%$\u0007C\u0001,^\u001d\t96\f\u0005\u0002YG5\t\u0011L\u0003\u0002[?\u00051AH]8pizJ!\u0001X\u0012\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039\u000eBQ!\u0019\u0007A\u00021\nAa]5{K\u0006!A/Y6f)\t!G\u000e\u0005\u0002fU6\taM\u0003\u0002hQ\u0006\u0019a.[8\u000b\u0003%\fAA[1wC&\u00111N\u001a\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"\u0002+\u000e\u0001\u0004)\u0016a\u0002:fY\u0016\f7/\u001a\u000b\u0004_J$\bC\u0001\u0012q\u0013\t\t8E\u0001\u0003V]&$\b\"B:\u000f\u0001\u0004!\u0017A\u00032zi\u0016\u0014UO\u001a4fe\")AK\u0004a\u0001+\u0006I\u0002k\\8mK\u0012$\u0015N]3di6+Wn\u001c:z'\u0016\u0014h/[2f!\tA\u0013c\u0005\u0002\u0012CQ\ta/A\u0003baBd\u0017\u0010\u0006\u00028w\")Ap\u0005a\u0001{\u0006y1/\u001a;uS:<7oU3sm&\u001cW\rE\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0004tKJ4\u0018nY3\u000b\u0007\u0005\u0015q#A\u0003n_\u0012,G.C\u0002\u0002\n}\u0014qbU3ui&twm]*feZL7-\u001a")
public class PooledDirectMemoryService
implements MemoryService {
    private MemoryServiceMonitor directMemory;
    private MemoryServiceMonitor heapMemory;
    private MemoryServiceMonitor byteArrayMemoryMonitor;
    private final int capacity;
    private final int maxSize;
    private final boolean telemetryEnabled;
    private final int defaultByteArrayBufferSize;
    private final ByteBufferPool pool;
    private volatile byte bitmap$0;

    public static PooledDirectMemoryService apply(SettingsService settingsService) {
        return PooledDirectMemoryService$.MODULE$.apply(settingsService);
    }

    @Override
    public byte[] byteArrayBuffer(String id) {
        return MemoryService.byteArrayBuffer$(this, id);
    }

    private MemoryServiceMonitor directMemory$lzycompute() {
        PooledDirectMemoryService pooledDirectMemoryService = this;
        synchronized (pooledDirectMemoryService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.directMemory = new MemoryServiceMonitor("Direct", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)(this.maxSize * this.capacity))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.directMemory;
    }

    private MemoryServiceMonitor directMemory() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.directMemory$lzycompute() : this.directMemory;
    }

    private MemoryServiceMonitor heapMemory$lzycompute() {
        PooledDirectMemoryService pooledDirectMemoryService = this;
        synchronized (pooledDirectMemoryService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.heapMemory = new MemoryServiceMonitor("Heap", (Option<Object>)None$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.heapMemory;
    }

    private MemoryServiceMonitor heapMemory() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.heapMemory$lzycompute() : this.heapMemory;
    }

    private MemoryServiceMonitor byteArrayMemoryMonitor$lzycompute() {
        PooledDirectMemoryService pooledDirectMemoryService = this;
        synchronized (pooledDirectMemoryService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.byteArrayMemoryMonitor = new MemoryServiceMonitor("Heap_ByteArray", (Option<Object>)None$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.byteArrayMemoryMonitor;
    }

    private MemoryServiceMonitor byteArrayMemoryMonitor() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.byteArrayMemoryMonitor$lzycompute() : this.byteArrayMemoryMonitor;
    }

    private ByteBufferPool pool() {
        return this.pool;
    }

    @Override
    public int defaultBufferSize() {
        return this.defaultByteArrayBufferSize;
    }

    @Override
    public byte[] newByteArray(String id, int size) {
        block0: {
            if (!this.telemetryEnabled) break block0;
            this.byteArrayMemoryMonitor().taken(size, id);
        }
        return new byte[size];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer take(String id) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = this.pool().take();
        if (byteBuffer2 == null) {
            if (this.telemetryEnabled) {
                this.heapMemory().taken(this.capacity, id);
            }
            byteBuffer = ByteBuffer.allocate(this.capacity);
        } else {
            void var2_2;
            if (this.telemetryEnabled) {
                this.directMemory().taken(this.capacity, id);
            }
            byteBuffer = var2_2;
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer, String id) {
        block2: {
            block1: {
                if (!byteBuffer.isDirect() || byteBuffer.capacity() != this.capacity) break block1;
                if (this.telemetryEnabled) {
                    this.directMemory().release(this.capacity, id);
                }
                this.pool().release(byteBuffer);
                break block2;
            }
            if (!this.telemetryEnabled) break block2;
            this.heapMemory().release(this.capacity, id);
        }
    }

    public int size() {
        return this.pool().size();
    }

    public PooledDirectMemoryService(int capacity, int maxSize, boolean telemetryEnabled, int defaultByteArrayBufferSize) {
        this.capacity = capacity;
        this.maxSize = maxSize;
        this.telemetryEnabled = telemetryEnabled;
        this.defaultByteArrayBufferSize = defaultByteArrayBufferSize;
        MemoryService.$init$(this);
        this.pool = new ByteBufferPool(capacity, maxSize);
    }
}

