/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.ListCursorIteratorProvider;
import org.mule.runtime.core.privileged.util.EventUtils;

public final class StreamingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreEvent withCursoredEvent(CoreEvent event, final CheckedFunction<CoreEvent, CoreEvent> f) throws MuleException {
        CoreEvent coreEvent;
        block8: {
            if (event.getMessage().getPayload() == null) {
                return event;
            }
            final Reference exception = new Reference();
            CheckedFunction<CoreEvent, CoreEvent> function = new CheckedFunction<CoreEvent, CoreEvent>(){

                @Override
                public CoreEvent applyChecked(CoreEvent event) throws Throwable {
                    return (CoreEvent)f.apply(event);
                }

                @Override
                public CoreEvent handleException(Throwable throwable) {
                    exception.set((Object)Exceptions.unwrap(throwable));
                    return null;
                }
            };
            Object payload = event.getMessage().getPayload().getValue();
            CursorProvider cursorProvider = null;
            Cursor cursor = null;
            try {
                CoreEvent value;
                if (payload instanceof CursorProvider) {
                    cursorProvider = (CursorProvider)payload;
                    cursor = cursorProvider.openCursor();
                    event = StreamingUtils.replacePayload(event, cursor);
                }
                if ((value = (CoreEvent)function.apply(event)) == null) {
                    StreamingUtils.handlePossibleException((Reference<Throwable>)exception);
                } else if (value.getMessage().getPayload().getValue() == cursor) {
                    value = StreamingUtils.replacePayload(value, cursorProvider);
                }
                coreEvent = value;
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    StreamingUtils.closeQuietly(cursor);
                }
                throw throwable;
            }
            StreamingUtils.closeQuietly(cursor);
        }
        return coreEvent;
    }

    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, EventContext eventContext, ComponentLocation originatingLocation) {
        if (cursorProviderFactory != null && cursorProviderFactory.accepts(value)) {
            return cursorProviderFactory.of(eventContext, value, originatingLocation);
        }
        return value;
    }

    @Deprecated
    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, EventContext eventContext) {
        return StreamingUtils.streamingContent(value, cursorProviderFactory, eventContext, null);
    }

    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, CoreEvent event, ComponentLocation originatingLocation) {
        return StreamingUtils.streamingContent(value, cursorProviderFactory, EventUtils.getRoot(event.getContext()), originatingLocation);
    }

    @Deprecated
    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        return StreamingUtils.streamingContent(value, cursorProviderFactory, event, null);
    }

    public static boolean closeQuietly(Cursor cursor) {
        if (cursor == null) {
            return false;
        }
        try {
            cursor.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> CursorIteratorProvider asCursorProvider(List<T> items) {
        return new ListCursorIteratorProvider(items);
    }

    public static CursorStreamProvider asCursorProvider(byte[] bytes) {
        return new ByteArrayCursorStreamProvider(bytes);
    }

    public static CoreEvent consumeRepeatablePayload(CoreEvent event) {
        TypedValue payload = event.getMessage().getPayload();
        if (payload.getValue() == null) {
            return event;
        }
        TypedValue replacedPayload = StreamingUtils.consumeRepeatableValue(payload);
        if (replacedPayload != payload) {
            event = CoreEvent.builder(event).message(Message.builder((Message)event.getMessage()).payload(replacedPayload).build()).build();
        }
        return event;
    }

    public static TypedValue consumeRepeatableValue(TypedValue typedValue) {
        Object originalPayload = typedValue.getValue();
        if (originalPayload == null) {
            return typedValue;
        }
        DataType originalDataType = typedValue.getDataType();
        TypedValue replacedPayload = typedValue;
        if (originalPayload instanceof CursorStreamProvider) {
            CursorStreamProvider consumedPayload = StreamingUtils.asCursorProvider(IOUtils.toByteArray((CursorStreamProvider)originalPayload));
            replacedPayload = new TypedValue((Object)consumedPayload, DataType.builder((DataType)originalDataType).type(consumedPayload.getClass()).build());
        } else if (originalPayload instanceof CursorIteratorProvider) {
            DataType newDataType;
            LinkedList consumed = new LinkedList();
            ((CursorIterator)((CursorIteratorProvider)originalPayload).openCursor()).forEachRemaining(consumed::add);
            if (originalDataType instanceof CollectionDataType) {
                CollectionDataType collectionDataType = (CollectionDataType)originalDataType;
                newDataType = DataType.builder((DataType)originalDataType).collectionType(consumed.getClass()).itemType(collectionDataType.getItemDataType().getType()).itemMediaType(collectionDataType.getItemDataType().getMediaType()).build();
            } else {
                newDataType = DataType.builder((DataType)originalDataType).type(consumed.getClass()).build();
            }
            replacedPayload = new TypedValue(consumed, newDataType);
        }
        return replacedPayload;
    }

    private static CoreEvent replacePayload(CoreEvent event, Object newPayload) {
        return CoreEvent.builder(event).message(Message.builder((Message)event.getMessage()).value(newPayload).build()).build();
    }

    private static void handlePossibleException(Reference<Throwable> exception) throws MuleException {
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            throw Exceptions.rxExceptionToMuleException(t);
        }
    }

    private StreamingUtils() {
    }

    public static TypedValue updateTypedValueForStreaming(TypedValue value, CoreEvent event, StreamingManager streamingManager) {
        if (event == null) {
            return value;
        }
        return StreamingUtils.updateTypedValueForStreaming(value, EventUtils.getRoot(event.getContext()), streamingManager);
    }

    public static TypedValue updateTypedValueForStreaming(TypedValue value, EventContext rootEventContext, StreamingManager streamingManager) {
        Object payload = value.getValue();
        if (payload instanceof CursorProvider) {
            CursorProvider cursorProvider = streamingManager.manage((CursorProvider)payload, rootEventContext);
            if (cursorProvider == payload) {
                return value;
            }
            DataType dataType = DataType.builder((DataType)value.getDataType()).type(cursorProvider.getClass()).build();
            return new TypedValue((Object)cursorProvider, dataType, value.getByteLength());
        }
        return value;
    }

    public static Function<CoreEvent, CoreEvent> updateEventForStreaming(StreamingManager streamingManager) {
        return event -> {
            TypedValue payload = event.getMessage().getPayload();
            if (payload.getValue() instanceof CursorProvider) {
                TypedValue updatedPayload = StreamingUtils.updateTypedValueForStreaming(payload, event, streamingManager);
                if (updatedPayload == payload) {
                    return event;
                }
                Message message = Message.builder((Message)event.getMessage()).payload(updatedPayload).build();
                return CoreEvent.builder(event).message(message).build();
            }
            return event;
        };
    }

    @Deprecated
    public static TypedValue updateTypedValueWithCursorProvider(TypedValue value, CoreEvent event, StreamingManager streamingManager) {
        if (event == null) {
            return value;
        }
        return StreamingUtils.updateTypedValueWithCursorProvider(value, streamingManager);
    }

    public static TypedValue updateTypedValueWithCursorProvider(TypedValue value, StreamingManager streamingManager) {
        Object payload = value.getValue();
        if (payload instanceof CursorStream) {
            CursorProvider provider = ((CursorStream)payload).getProvider();
            DataType dataType = DataType.builder((DataType)value.getDataType()).type(provider.getClass()).build();
            return new TypedValue((Object)provider, dataType, value.getByteLength());
        }
        return value;
    }

    public static boolean supportsStreaming(ComponentModel componentModel) {
        return componentModel instanceof ConnectableComponentModel && ((ConnectableComponentModel)componentModel).supportsStreaming();
    }
}

