/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProcessingStrategyAdapter;
import org.mule.runtime.core.internal.processor.strategy.ProcessingStrategyDecorator;
import org.mule.runtime.core.internal.processor.strategy.StreamPerThreadSink;
import org.mule.runtime.core.internal.processor.strategy.TransactionalDelegateSink;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class TransactionAwareStreamEmitterProcessingStrategyDecorator
extends ProcessingStrategyDecorator {
    private static final String TX_SCOPES_KEY = "mule.tx.activeTransactionsInReactorChain";
    private static final Consumer<CoreEvent> NULL_EVENT_CONSUMER = event -> {};
    @Inject
    private ProfilingService profilingService;
    @Inject
    private FeatureFlaggingService featureFlags;
    @Inject
    private MuleContext muleContext;

    public TransactionAwareStreamEmitterProcessingStrategyDecorator(ProcessingStrategy delegate) {
        super(delegate);
        if (delegate instanceof ProcessingStrategyAdapter) {
            ProcessingStrategyAdapter adapter = (ProcessingStrategyAdapter)delegate;
            adapter.setOnEventConsumer(NULL_EVENT_CONSUMER);
            Function<ScheduledExecutorService, ScheduledExecutorService> delegateDecorator = adapter.getSchedulerDecorator();
            adapter.setSchedulerDecorator(scheduler -> new ConditionalExecutorServiceDecorator((ScheduledExecutorService)delegateDecorator.apply((ScheduledExecutorService)scheduler), currentScheduler -> TransactionCoordination.isTransactionActive()));
        }
    }

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        Sink delegateSink = this.delegate.createSink(flowConstruct, pipeline);
        StreamPerThreadSink syncSink = new StreamPerThreadSink(p -> Flux.from((Publisher)p).subscriberContext(TransactionAwareStreamEmitterProcessingStrategyDecorator.popTxFromSubscriberContext()).transform((Function)pipeline).subscriberContext(TransactionAwareStreamEmitterProcessingStrategyDecorator.pushTxToSubscriberContext("source")), NULL_EVENT_CONSUMER, flowConstruct);
        return new TransactionalDelegateSink(syncSink, delegateSink);
    }

    @Override
    public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
        ComponentLocation location = ProfilingUtils.getLocation(pipeline);
        String artifactId = ProfilingUtils.getArtifactId(this.muleContext);
        String artifactType = ProfilingUtils.getArtifactType(this.muleContext);
        return pub -> Mono.subscriberContext().flatMapMany(ctx -> {
            if (this.isTxActive((Context)ctx)) {
                return ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)pub).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION), artifactId, artifactType).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION), artifactId, artifactType).transform(BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onPipeline(pipeline)).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.FLOW_EXECUTED), artifactId, artifactType).build();
            }
            return Flux.from((Publisher)pub).transform((Function)this.delegate.onPipeline(pipeline));
        });
    }

    private Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> getDataProducer(ProfilingEventType<ProcessingStrategyProfilingEventContext> eventType) {
        if (this.featureFlags.isEnabled((Feature)MuleRuntimeFeature.ENABLE_PROFILING_SERVICE)) {
            return Optional.of(this.profilingService.getProfilingDataProducer(eventType));
        }
        return Optional.empty();
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        ComponentLocation location = ProfilingUtils.getLocation(processor);
        String artifactId = this.muleContext.getConfiguration().getId();
        String artifactType = this.muleContext.getArtifactType().getAsString();
        return pub -> Mono.subscriberContext().flatMapMany(ctx -> {
            if (this.isTxActive((Context)ctx)) {
                return ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)pub).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION), artifactId, artifactType).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION), artifactId, artifactType).transform(BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onProcessor(processor)).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.OPERATION_EXECUTED), artifactId, artifactType).profileEvent(location, this.getDataProducer((ProfilingEventType<ProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING), artifactId, artifactType).build();
            }
            return Flux.from((Publisher)pub).transform((Function)this.delegate.onProcessor(processor));
        });
    }

    private boolean isTxActive(Context ctx) {
        return ctx.getOrEmpty((Object)TX_SCOPES_KEY).map(txScopes -> !txScopes.isEmpty()).orElse(false);
    }

    public static Function<Context, Context> popTxFromSubscriberContext() {
        return context -> {
            ArrayDeque currentTxChains = new ArrayDeque((Collection)context.getOrDefault((Object)TX_SCOPES_KEY, Collections.emptyList()));
            currentTxChains.pop();
            return context.put((Object)TX_SCOPES_KEY, currentTxChains);
        };
    }

    public static Function<Context, Context> pushTxToSubscriberContext(String location) {
        return context -> {
            ArrayDeque<String> currentTxChains = new ArrayDeque<String>((Collection)context.getOrDefault((Object)TX_SCOPES_KEY, Collections.emptyList()));
            currentTxChains.push(location);
            return context.put((Object)TX_SCOPES_KEY, currentTxChains);
        };
    }
}

