/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.forkjoin;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.event.DefaultEventBuilder;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.routing.CompositeRoutingException;
import org.mule.runtime.core.privileged.routing.RoutingResult;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractForkJoinStrategyFactory
implements ForkJoinStrategyFactory {
    public static final String TIMEOUT_EXCEPTION_DESCRIPTION = "Route Timeout";
    public static final String TIMEOUT_EXCEPTION_DETAILED_DESCRIPTION_PREFIX = "Timeout while processing route/part:";
    private final boolean mergeVariables;

    public AbstractForkJoinStrategyFactory() {
        this(true);
    }

    public AbstractForkJoinStrategyFactory(boolean mergeVariables) {
        this.mergeVariables = mergeVariables;
    }

    @Override
    public ForkJoinStrategy createForkJoinStrategy(ProcessingStrategy processingStrategy, int maxConcurrency, boolean delayErrors, long timeout, org.mule.runtime.api.scheduler.Scheduler timeoutScheduler, ErrorType timeoutErrorType) {
        Scheduler reactorTimeoutScheduler = Schedulers.fromExecutorService((ExecutorService)timeoutScheduler);
        return (original, routingPairs) -> {
            AtomicInteger count = new AtomicInteger();
            CoreEvent.Builder resultBuilder = CoreEvent.builder(original);
            return Flux.from((Publisher)routingPairs).map(this.addSequence(count)).flatMapSequential(this.processRoutePair(processingStrategy, maxConcurrency, delayErrors, timeout, reactorTimeoutScheduler, timeoutErrorType), maxConcurrency).reduce((Object)new Pair(new ArrayList(), (Object)false), (pair, event) -> {
                ((List)pair.getFirst()).add(event);
                boolean hasNewError = event.getError().map(err -> !this.isOriginalError((Error)err, original.getError())).orElse(false);
                return new Pair(pair.getFirst(), (Object)((Boolean)pair.getSecond() != false || hasNewError ? 1 : 0));
            }).doOnNext(p -> {
                Pair pair = (Pair)p;
                if (((Boolean)pair.getSecond()).booleanValue()) {
                    throw Exceptions.propagate((Throwable)((Object)this.createCompositeRoutingException(((List)pair.getFirst()).stream().map(event -> this.removeOriginalError((CoreEvent)event, original.getError())).collect(Collectors.toList()))));
                }
            }).map(pair -> (List)((Pair)pair).getFirst()).doOnNext(this.mergeVariables(original, resultBuilder)).map(this.createResultEvent(original, resultBuilder));
        };
    }

    private boolean isOriginalError(Error newError, Optional<Error> originalError) {
        return originalError.map(error -> error.equals(newError)).orElse(false);
    }

    private CoreEvent removeOriginalError(CoreEvent event, Optional<Error> originalError) {
        return event.getError().map(err -> this.isOriginalError((Error)err, originalError) ? CoreEvent.builder(event).error(null).build() : event).orElse(event);
    }

    protected abstract Function<List<CoreEvent>, CoreEvent> createResultEvent(CoreEvent var1, CoreEvent.Builder var2);

    private Function<ForkJoinStrategy.RoutingPair, ForkJoinStrategy.RoutingPair> addSequence(AtomicInteger count) {
        return pair -> ForkJoinStrategy.RoutingPair.of(CoreEvent.builder(pair.getEvent()).groupCorrelation(Optional.of(GroupCorrelation.of(count.getAndIncrement()))).build(), pair.getRoute());
    }

    private Function<ForkJoinStrategy.RoutingPair, Publisher<? extends CoreEvent>> processRoutePair(ProcessingStrategy processingStrategy, int maxConcurrency, boolean delayErrors, long timeout, Scheduler timeoutScheduler, ErrorType timeoutErrorType) {
        return pair -> {
            ReactiveProcessor route = publisher -> Flux.from((Publisher)publisher).transform((Function)pair.getRoute());
            return Flux.from(MessageProcessors.processWithChildContextDontComplete(pair.getEvent(), this.applyProcessingStrategy(processingStrategy, route, maxConcurrency), Optional.empty())).timeout(Duration.ofMillis(timeout), this.onTimeout(processingStrategy, delayErrors, timeoutErrorType, (ForkJoinStrategy.RoutingPair)pair), timeoutScheduler).map(event -> ((DefaultEventBuilder)CoreEvent.builder(event)).removeInternalParameter("error.context").build()).onErrorResume(MessagingException.class, me -> delayErrors ? Mono.just((Object)me.getEvent()) : Mono.error((Throwable)((Object)me)));
        };
    }

    private Mono<CoreEvent> onTimeout(ProcessingStrategy processingStrategy, boolean delayErrors, ErrorType timeoutErrorType, ForkJoinStrategy.RoutingPair pair) {
        return Mono.defer(() -> delayErrors ? Mono.just((Object)this.createTimeoutErrorEvent(timeoutErrorType, pair)) : Mono.error((Throwable)new TimeoutException(this.buildDetailedDescription(pair)))).transform((Function)processingStrategy.onPipeline(p -> p));
    }

    private ReactiveProcessor applyProcessingStrategy(ProcessingStrategy processingStrategy, ReactiveProcessor processor, int maxConcurrency) {
        if (maxConcurrency > 1) {
            return processingStrategy.onPipeline(processor);
        }
        return processor;
    }

    private CoreEvent createTimeoutErrorEvent(ErrorType timeoutErrorType, ForkJoinStrategy.RoutingPair pair) {
        String detailedDescription = this.buildDetailedDescription(pair);
        return CoreEvent.builder(pair.getEvent()).message(Message.of(null)).error(ErrorBuilder.builder().errorType(timeoutErrorType).exception(new TimeoutException(detailedDescription)).description(TIMEOUT_EXCEPTION_DESCRIPTION).detailedDescription(detailedDescription).build()).build();
    }

    private String buildDetailedDescription(ForkJoinStrategy.RoutingPair pair) {
        return "Timeout while processing route/part: '" + pair.getEvent().getGroupCorrelation().get().getSequence() + "'";
    }

    private CompositeRoutingException createCompositeRoutingException(List<CoreEvent> results) {
        LinkedHashMap<String, Message> successMap = new LinkedHashMap<String, Message>();
        LinkedHashMap<String, Error> errorMap = new LinkedHashMap<String, Error>();
        for (CoreEvent event : results) {
            String key = Integer.toString(event.getGroupCorrelation().get().getSequence());
            if (event.getError().isPresent()) {
                errorMap.put(key, (Error)event.getError().get());
                continue;
            }
            successMap.put(key, event.getMessage());
        }
        return new CompositeRoutingException(new RoutingResult(successMap, errorMap));
    }

    private Consumer<List<CoreEvent>> mergeVariables(CoreEvent original, CoreEvent.Builder result) {
        return list -> {
            if (!this.mergeVariables) {
                return;
            }
            HashMap<String, TypedValue> routeVars = new HashMap<String, TypedValue>();
            list.forEach(event -> event.getVariables().forEach((key, value) -> {
                if (!value.equals(original.getVariables().get(key))) {
                    if (!routeVars.containsKey(key)) {
                        routeVars.put((String)key, (TypedValue)value);
                    } else {
                        if (!(((TypedValue)routeVars.get(key)).getValue() instanceof List)) {
                            ArrayList<Object> newList = new ArrayList<Object>();
                            newList.add(((TypedValue)routeVars.get(key)).getValue());
                            routeVars.put((String)key, new TypedValue(newList, DataType.builder().collectionType(List.class).itemType(((TypedValue)routeVars.get(key)).getDataType().getType()).build()));
                        }
                        List valueList = (List)((TypedValue)routeVars.get(key)).getValue();
                        valueList.add(value.getValue());
                        if (((CollectionDataType)((TypedValue)routeVars.get(key)).getDataType()).getItemDataType().isCompatibleWith(value.getDataType())) {
                            routeVars.put((String)key, new TypedValue((Object)valueList, ((TypedValue)routeVars.get(key)).getDataType()));
                        } else {
                            routeVars.put((String)key, new TypedValue((Object)valueList, DataType.builder().collectionType(List.class).build()));
                        }
                    }
                }
            }));
            routeVars.forEach((s, typedValue) -> result.addVariable((String)s, (TypedValue<?>)typedValue));
        };
    }
}

