/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.exception.IndexOutOfBoundsException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.indexed.TokenArray;
import org.mule.weave.v2.module.xml.reader.indexed.TokenArray$;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\r\u001b\u0001-B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\to\u0001\u0011\t\u0011)A\u0005e!I\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0010\u0005\t}\u0001\u0011\t\u0011)A\u0006\u007f!)Q\t\u0001C\u0001\r\"9A\n\u0001b\u0001\n\u0003i\u0005BB)\u0001A\u0003%a\nC\u0004S\u0001\t\u0007I\u0011A*\t\ru\u0003\u0001\u0015!\u0003U\u0011\u001dq\u0006\u00011A\u0005\u0002}CqA\u001a\u0001A\u0002\u0013\u0005q\r\u0003\u0004n\u0001\u0001\u0006K\u0001\u0019\u0005\b]\u0002\u0001\r\u0011\"\u0001p\u0011\u001d\u0019\b\u00011A\u0005\u0002QDaA\u001e\u0001!B\u0013\u0001\b\"B<\u0001\t\u0003A\b\"B>\u0001\t\u0003a\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002.\u0001!\t!!\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011q\u0006\u0001\u0005\u0002\u0005m\"\u0001E%oI\u0016DX\rZ\"T-B\u000b'o]3s\u0015\tYB$\u0001\u0004qCJ\u001cXM\u001d\u0006\u0003;y\taA]3bI\u0016\u0014(BA\u0010!\u0003\r\u00197O\u001e\u0006\u0003C\t\na!\\8ek2,'BA\u0012%\u0003\t1(G\u0003\u0002&M\u0005)q/Z1wK*\u0011q\u0005K\u0001\u0005[VdWMC\u0001*\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0006\u0005\u0002.]5\t!$\u0003\u000205\tI1i\u0015,QCJ\u001cXM]\u0001\rg>,(oY3SK\u0006$WM]\u000b\u0002eA\u00111'N\u0007\u0002i)\u0011Q\u0004I\u0005\u0003mQ\u0012AbU8ve\u000e,'+Z1eKJ\fQb]8ve\u000e,'+Z1eKJ\u0004\u0013aC2T-N+G\u000f^5oON\u0004\"!\f\u001e\n\u0005mR\"aC\"T-N+G\u000f^5oONL!!\u0010\u0018\u0002\u0017\r\u001choU3ui&twm]\u0001\u0004GRD\bC\u0001!D\u001b\u0005\t%B\u0001\"#\u0003\u0015iw\u000eZ3m\u0013\t!\u0015IA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA$K\u0017R\u0011\u0001*\u0013\t\u0003[\u0001AQAP\u0003A\u0004}BQ\u0001M\u0003A\u0002IBQ\u0001O\u0003A\u0002e\nAB]3d_J$Gk\\6f]N,\u0012A\u0014\t\u0003g=K!\u0001\u0015\u001b\u0003!\u0011+g-Y;mi2{gnZ!se\u0006L\u0018!\u0004:fG>\u0014H\rV8lK:\u001c\b%\u0001\u0006dgZ,e\u000e\u001e:jKN,\u0012\u0001\u0016\t\u0003+nk\u0011A\u0016\u0006\u0003/b\u000bq!\u001b8eKb,GM\u0003\u0002\u001e3*\u0011!\fI\u0001\u0004q6d\u0017B\u0001/W\u0005)!vn[3o\u0003J\u0014\u0018-_\u0001\fGN4XI\u001c;sS\u0016\u001c\b%\u0001\u0005m_\u000e\fG/[8o+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014'\u0001\u0002'p]\u001e\fA\u0002\\8dCRLwN\\0%KF$\"\u0001[6\u0011\u0005\u0005L\u0017B\u00016c\u0005\u0011)f.\u001b;\t\u000f1\\\u0011\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002\u00131|7-\u0019;j_:\u0004\u0013a\u00045fC\u0012,'\u000f\u0015:pG\u0016\u001c8/\u001a3\u0016\u0003A\u0004\"!Y9\n\u0005I\u0014'a\u0002\"p_2,\u0017M\\\u0001\u0014Q\u0016\fG-\u001a:Qe>\u001cWm]:fI~#S-\u001d\u000b\u0003QVDq\u0001\u001c\b\u0002\u0002\u0003\u0007\u0001/\u0001\tiK\u0006$WM\u001d)s_\u000e,7o]3eA\u0005A1m\u001c8uC&t7\u000f\u0006\u0002qs\")!\u0010\u0005a\u0001A\u0006)\u0011N\u001c3fq\u0006\u0019q-\u001a;\u0015\u0007u\f\t\u0001\u0005\u0002.}&\u0011qP\u0007\u0002\n\u0007N3&+Z2pe\u0012DQA_\tA\u0002\u0001\f\u0001b]6ja2Kg.\u001a\u000b\u0002Q\u0006IQ\r\\3nK:$\u0018\t\u001e\u000b\u0005\u0003\u0017\ti\u0002E\u0003b\u0003\u001b\t\t\"C\u0002\u0002\u0010\t\u0014aa\u00149uS>t\u0007#B1\u0002\u0014\u0005]\u0011bAA\u000bE\n)\u0011I\u001d:bsB\u0019Q&!\u0007\n\u0007\u0005m!DA\bJ]\u0012,\u00070\u001a3D'Z+e\u000e\u001e:z\u0011\u0015Q8\u00031\u0001a\u0003%\u0001\u0018M]:f\u001d\u0016DH\u000f\u0006\u0002\u0002\f\u0005)\u0002O]8dKN\u001chj\u001c8Rk>$X\rZ#oiJLHCAA\u0014!\u0019\t\u0017\u0011FA\fa&\u0019\u00111\u00062\u0003\rQ+\b\u000f\\33\u0003I\u0001(o\\2fgN\fVo\u001c;fI\u0016sGO]=\u0002\u0017\r\u0014X-\u0019;f\u000b:$(/\u001f\u000b\u0007\u0003/\t\u0019$a\u000e\t\r\u0005Ur\u00031\u0001a\u0003)1\u0018\r\\;f\u0013:$W\r\u001f\u0005\u0007\u0003s9\u0002\u0019\u00019\u0002\u0011%\u001c\u0018+^8uK\u0012$\u0002\"a\u0006\u0002>\u0005}\u00121\t\u0005\u0007\u0003kA\u0002\u0019\u00011\t\r\u0005\u0005\u0003\u00041\u0001a\u0003\u0011\u0019\u0018N_3\t\r\u0005e\u0002\u00041\u0001q\u0001")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader sourceReader;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;
    private boolean headerProcessed;

    @Override
    public SourceReader sourceReader() {
        return this.sourceReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean headerProcessed() {
        return this.headerProcessed;
    }

    public void headerProcessed_$eq(boolean x$1) {
        this.headerProcessed = x$1;
    }

    public boolean contains(long index) {
        return this.recordTokens().size() > index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(long index) {
        Option<IndexedCSVEntry[]> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new IndexOutOfBoundsException((Location)UnknownLocation$.MODULE$, index, this.recordTokens().size());
        }
        return new CSVRecord((CSVEntry[])parsed.get(), this.headers(), (Map<String, ArrayBuffer<Object>>)this.headersWithIndex(), new IndexedCSVRecordLocation((CSVEntry[])parsed.get(), this.sourceReader()));
    }

    @Override
    public void skipLine() {
        this.sourceReader().seek(this.location());
        char next = this.sourceReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.sourceReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.sourceReader().readAscii();
                next = this.sourceReader().lookAheadAscii();
                this.location_$eq(this.sourceReader().position());
            }
        }
    }

    private Option<IndexedCSVEntry[]> elementAt(long index) {
        None$ none$;
        long size;
        if (!this.headerProcessed()) {
            Option<IndexedCSVEntry[]> headerParsing;
            boolean hasHeaderLine;
            int headerLine = super.csvSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.csvSettings().header() && (headerParsing = this.parseNext()).isDefined()) {
                this.processHeaders((CSVEntry[])headerParsing.get());
            }
            this.skipLines(this.linesToSkipBeforeBody());
            this.headerProcessed_$eq(true);
        }
        if ((size = this.recordTokens().size()) <= index) {
            for (long remaining = index - size; remaining >= 0L; --remaining) {
                Option<IndexedCSVEntry[]> nextRecordMaybe = this.parseNext();
                if (!nextRecordMaybe.isDefined()) continue;
                IndexedCSVEntry[] nextRecord = (IndexedCSVEntry[])nextRecordMaybe.get();
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length;
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((long[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nextRecord)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)))));
                if (remaining != 0L) continue;
                return new Some((Object)nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply(index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.sourceReader(), this.helper());
            none$ = new Some((Object)record);
        }
        return none$;
    }

    private Option<IndexedCSVEntry[]> parseNext() {
        None$ none$;
        block3: {
            block2: {
                ArrayBuffer recordEntries;
                do {
                    this.sourceReader().seek(this.location());
                    recordEntries = new ArrayBuffer();
                    char value = this.sourceReader().lookAheadAscii();
                    if (value == '\uffff') break block2;
                    boolean recordFinished = false;
                    while (!recordFinished) {
                        Tuple2<IndexedCSVEntry, Object> quotedEntry = this.processNonQuotedEntry();
                        recordEntries.$plus$eq(quotedEntry._1());
                        recordFinished = quotedEntry._2$mcZ$sp();
                    }
                    this.location_$eq(this.sourceReader().position());
                } while (super.csvSettings().ignoreEmptyLine() && recordEntries.length() == 1 && ((IndexedCSVEntry)recordEntries.apply(0)).length() == 0L);
                none$ = new Some(recordEntries.toArray(ClassTag$.MODULE$.apply(IndexedCSVEntry.class)));
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processNonQuotedEntry() {
        void var1_1;
        Tuple2 result = null;
        boolean isBlank = true;
        long valueIndex = this.sourceReader().position();
        boolean isQuoted = false;
        while (result == null) {
            Object object;
            char next = this.read();
            if (this.isQuoteChar(next) && isBlank) {
                result = this.processQuotedEntry();
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEscapeChar(next) && this.requiresEscape(this.sourceReader().lookAheadAscii())) {
                char c = this.read();
                if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c))) {
                    isBlank = false;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isColumnSeparator(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEndOfInput(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, this.sourceReader().position() - valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isLineEnding(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                if (next == '\r' && this.sourceReader().lookAheadAscii() == '\n') {
                    object = BoxesRunTime.boxToCharacter((char)this.sourceReader().readAscii());
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(next))) {
                isBlank = false;
            }
            object = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processQuotedEntry() {
        void var3_2;
        long valueIndex = this.sourceReader().position();
        Tuple2 result = null;
        boolean isQuoted = true;
        while (result == null) {
            Character c;
            char next = this.read();
            long size = this.sourceReader().previousPosition() - valueIndex;
            if (this.isEscapeChar(next) && this.requiresEscapeInQuoted(this.sourceReader().lookAheadAscii())) {
                c = BoxesRunTime.boxToCharacter((char)this.read());
                continue;
            }
            if (this.isQuoteChar(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, size, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)this.consumeUntilEndOfEntry()));
            } else if (this.isEndOfInput(next)) {
                this.logInvalidEndOfString();
                long newSize = this.sourceReader().position() - valueIndex;
                result = new Tuple2((Object)this.createEntry(valueIndex, newSize < 0L ? 0L : newSize, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            c = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public IndexedCSVEntry createEntry(long valueIndex, boolean isQuoted) {
        return this.createEntry(valueIndex, this.sourceReader().previousPosition() - valueIndex, isQuoted);
    }

    public IndexedCSVEntry createEntry(long valueIndex, long size, boolean isQuoted) {
        long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size, isQuoted);
        return new IndexedCSVEntry(token, this.sourceReader(), this.helper());
    }

    public IndexedCSVParser(SourceReader sourceReader, CSVSettings cSVSettings, EvaluationContext ctx) {
        this.sourceReader = sourceReader;
        super(cSVSettings, ctx);
        this.recordTokens = (DefaultLongArray)ctx.registerCloseable((AutoCloseable)new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.csvEntries = (TokenArray)ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.location = 0L;
        this.headerProcessed = false;
    }
}

