/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ProcessingStrategyAdapter;
import org.mule.runtime.core.internal.processor.strategy.ProcessingStrategyDecorator;
import org.mule.runtime.core.internal.processor.strategy.StreamPerThreadSink;
import org.mule.runtime.core.internal.processor.strategy.TransactionalDelegateSink;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.ReactorAwareProfilingService;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;
import org.mule.runtime.core.internal.util.rx.ReactorTransactionUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransactionAwareStreamEmitterProcessingStrategyDecorator
extends ProcessingStrategyDecorator {
    private static final Consumer<CoreEvent> NULL_EVENT_CONSUMER = event -> {};
    @Inject
    private ReactorAwareProfilingService profilingService;
    @Inject
    private MuleContext muleContext;
    @Inject
    private FeatureFlaggingService featureFlaggingService;

    public TransactionAwareStreamEmitterProcessingStrategyDecorator(ProcessingStrategy delegate) {
        super(delegate);
        if (delegate instanceof ProcessingStrategyAdapter) {
            ProcessingStrategyAdapter adapter = (ProcessingStrategyAdapter)delegate;
            adapter.setOnEventConsumer(NULL_EVENT_CONSUMER);
            Function<ScheduledExecutorService, ScheduledExecutorService> delegateDecorator = adapter.getSchedulerDecorator();
            adapter.setSchedulerDecorator(scheduler -> new ConditionalExecutorServiceDecorator((ScheduledExecutorService)delegateDecorator.apply((ScheduledExecutorService)scheduler), currentScheduler -> TransactionCoordination.isTransactionActive()));
        }
    }

    @Override
    public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
        Sink delegateSink = this.delegate.createSink(flowConstruct, pipeline);
        StreamPerThreadSink syncSink = new StreamPerThreadSink(p -> Flux.from((Publisher)p).subscriberContext(ReactorTransactionUtils.popTxFromSubscriberContext()).transform((Function)pipeline).subscriberContext(ReactorTransactionUtils.pushTxToSubscriberContext("source")), NULL_EVENT_CONSUMER, flowConstruct, this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.USE_TRANSACTION_SINK_INDEX));
        return new TransactionalDelegateSink(syncSink, delegateSink);
    }

    @Override
    public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
        ComponentLocation location = ProfilingUtils.getLocation(pipeline);
        String artifactId = ProfilingUtils.getArtifactId(this.muleContext);
        String artifactType = ProfilingUtils.getArtifactType(this.muleContext);
        Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transfomer = coreEvent -> new DefaultComponentProcessingStrategyProfilingEventContext((CoreEvent)coreEvent, ProfilingUtils.getLocation(pipeline), Thread.currentThread().getName(), artifactId, artifactType, System.currentTimeMillis());
        return pub -> Mono.subscriberContext().flatMapMany(ctx -> {
            if (ReactorTransactionUtils.isTxActiveByContext(ctx)) {
                return ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)pub).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION), transfomer).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION), transfomer).transform(BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onPipeline(pipeline)).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.FLOW_EXECUTED), transfomer).build();
            }
            return Flux.from((Publisher)pub).transform((Function)this.delegate.onPipeline(pipeline));
        });
    }

    private ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> getDataProducer(ProfilingEventType<ComponentProcessingStrategyProfilingEventContext> eventType) {
        return this.profilingService.getProfilingDataProducer(eventType);
    }

    @Override
    public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
        ComponentLocation location = ProfilingUtils.getLocation(processor);
        String artifactId = this.muleContext.getConfiguration().getId();
        String artifactType = this.muleContext.getArtifactType().getAsString();
        Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transfomer = coreEvent -> new DefaultComponentProcessingStrategyProfilingEventContext((CoreEvent)coreEvent, ProfilingUtils.getLocation(processor), Thread.currentThread().getName(), artifactId, artifactType, System.currentTimeMillis());
        return pub -> Mono.subscriberContext().flatMapMany(ctx -> {
            if (ReactorTransactionUtils.isTxActiveByContext(ctx)) {
                return ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)pub).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION), transfomer).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION), transfomer).transform(BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE.onProcessor(processor)).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED), transfomer).profileProcessingStrategyEvent(this.profilingService, this.getDataProducer((ProfilingEventType<ComponentProcessingStrategyProfilingEventContext>)RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING), transfomer).build();
            }
            return Flux.from((Publisher)pub).transform((Function)this.delegate.onProcessor(processor));
        });
    }
}

